/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class WizardExportResourcesPage
extends WizardDataTransferPage {
    private IStructuredSelection initialResourceSelection;
    private List selectedTypes = new ArrayList();
    private ResourceTreeAndListGroup resourceGroup;
    private static final String SELECT_TYPES_TITLE = IDEWorkbenchMessages.WizardTransferPage_selectTypes;
    private static final String SELECT_ALL_TITLE = IDEWorkbenchMessages.WizardTransferPage_selectAll;
    private static final String DESELECT_ALL_TITLE = IDEWorkbenchMessages.WizardTransferPage_deselectAll;

    protected WizardExportResourcesPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.initialResourceSelection = iStructuredSelection;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected Button createButton(Composite composite, int n, String string, boolean bl) {
        ++((GridLayout)composite.getLayout()).numColumns;
        Button button = new Button(composite, 8);
        GridData gridData = new GridData(768);
        button.setLayoutData((Object)gridData);
        button.setData((Object)new Integer(n));
        button.setText(string);
        button.setFont(composite.getFont());
        if (bl) {
            Shell shell = composite.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(composite.getFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected final void createButtonsGroup(Composite composite) {
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        Button button = this.createButton(composite2, 20, SELECT_TYPES_TITLE, false);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardExportResourcesPage.this.handleTypesEditButtonPressed();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button.setFont(font);
        this.setButtonLayoutData(button);
        Button button2 = this.createButton(composite2, 18, SELECT_ALL_TITLE, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardExportResourcesPage.this.resourceGroup.setAllSelections(true);
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        button2.setFont(font);
        this.setButtonLayoutData(button2);
        Button button3 = this.createButton(composite2, 19, DESELECT_ALL_TITLE, false);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardExportResourcesPage.this.resourceGroup.setAllSelections(false);
            }
        };
        button3.addSelectionListener((SelectionListener)selectionAdapter);
        button3.setFont(font);
        this.setButtonLayoutData(button3);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(composite.getFont());
        this.createResourcesGroup(composite2);
        this.createButtonsGroup(composite2);
        this.createDestinationGroup(composite2);
        this.createOptionsGroup(composite2);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite2);
    }

    protected abstract void createDestinationGroup(Composite var1);

    protected final void createResourcesGroup(Composite composite) {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isOpen()) {
                arrayList.add(iProjectArray[n]);
            }
            ++n;
        }
        this.resourceGroup = new ResourceTreeAndListGroup(composite, arrayList, this.getResourceProvider(6), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode(composite));
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WizardExportResourcesPage.this.updateWidgetEnablements();
            }
        };
        this.resourceGroup.addCheckStateListener(iCheckStateListener);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_errorDialogTitle;
    }

    protected boolean ensureResourcesLocal(List list) {
        return true;
    }

    protected List extractNonLocalResources(List list) {
        Vector<IResource> vector = new Vector<IResource>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource.isLocal(0)) continue;
            vector.addElement(iResource);
        }
        return vector;
    }

    private ITreeContentProvider getResourceProvider(final int n) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof IContainer) {
                    IResource[] iResourceArray = null;
                    try {
                        iResourceArray = ((IContainer)object).members();
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> arrayList = new ArrayList<IResource>();
                    int n2 = 0;
                    while (n2 < iResourceArray.length) {
                        if ((iResourceArray[n2].getType() & n) > 0) {
                            arrayList.add(iResourceArray[n2]);
                        }
                        ++n2;
                    }
                    return arrayList.toArray();
                }
                if (object instanceof ArrayList) {
                    return ((ArrayList)object).toArray();
                }
                return new Object[0];
            }
        };
    }

    protected List getSelectedResources() {
        Iterator iterator = this.getSelectedResourcesIterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected Iterator getSelectedResourcesIterator() {
        return this.resourceGroup.getAllCheckedListItems().iterator();
    }

    protected List getTypesToExport() {
        return this.selectedTypes;
    }

    protected List getWhiteCheckedResources() {
        return this.resourceGroup.getAllWhiteCheckedItems();
    }

    protected void handleTypesEditButtonPressed() {
        Object[] objectArray = this.queryResourceTypesToExport();
        if (objectArray != null) {
            this.selectedTypes = new ArrayList(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                this.selectedTypes.add(objectArray[n]);
                ++n;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected boolean hasExportableExtension(String string) {
        if (this.selectedTypes == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        Iterator iterator = this.selectedTypes.iterator();
        while (iterator.hasNext()) {
            if (!string2.equalsIgnoreCase((String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    protected void internalSaveWidgetValues() {
    }

    protected Object[] queryResourceTypesToExport() {
        TypeFilteringDialog typeFilteringDialog = new TypeFilteringDialog(this.getContainer().getShell(), (Collection)this.getTypesToExport());
        typeFilteringDialog.open();
        return typeFilteringDialog.getResult();
    }

    protected void restoreResourceSpecificationWidgetValues() {
    }

    protected void saveWidgetValues() {
        this.internalSaveWidgetValues();
    }

    protected void setupBasedOnInitialSelections() {
        Iterator iterator = this.initialResourceSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            if (iResource.getType() == 1) {
                this.resourceGroup.initialCheckListItem(iResource);
                continue;
            }
            this.resourceGroup.initialCheckTreeItem(iResource);
        }
    }

    private void setupSelectionsBasedOnSelectedTypes() {
        Runnable runnable = new Runnable(){

            public void run() {
                Hashtable hashtable = new Hashtable();
                Iterator iterator = WizardExportResourcesPage.this.resourceGroup.getAllWhiteCheckedItems().iterator();
                while (iterator.hasNext()) {
                    IResource iResource = (IResource)iterator.next();
                    if (iResource.getType() == 1) {
                        if (!WizardExportResourcesPage.this.hasExportableExtension(iResource.getName())) continue;
                        List<Object> list = new ArrayList<IResource>();
                        IContainer iContainer = iResource.getParent();
                        if (hashtable.containsKey(iContainer)) {
                            list = (List)hashtable.get(iContainer);
                        }
                        list.add(iResource);
                        hashtable.put(iContainer, list);
                        continue;
                    }
                    WizardExportResourcesPage.this.setupSelectionsBasedOnSelectedTypes(hashtable, (IContainer)iResource);
                }
                WizardExportResourcesPage.this.resourceGroup.updateSelections(hashtable);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    private void setupSelectionsBasedOnSelectedTypes(Map map, IContainer iContainer) {
        IResource[] iResourceArray;
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        boolean bl = false;
        try {
            iResourceArray = iContainer.members();
        }
        catch (CoreException coreException) {
            return;
        }
        int n = 0;
        while (n < iResourceArray.length) {
            IResource iResource = iResourceArray[n];
            if (iResource.getType() == 1) {
                if (this.hasExportableExtension(iResource.getName())) {
                    bl = true;
                    arrayList.add(iResource);
                }
            } else {
                this.setupSelectionsBasedOnSelectedTypes(map, (IContainer)iResource);
            }
            ++n;
        }
        if (bl) {
            map.put(iContainer, arrayList);
        }
    }

    protected boolean saveDirtyEditors() {
        return IDEWorkbenchPlugin.getDefault().getWorkbench().saveAllEditors(true);
    }

    protected void updateWidgetEnablements() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }
}

