/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class WizardImportPage
extends WizardDataTransferPage {
    private IResource currentResourceSelection;
    private String initialContainerFieldValue;
    private Text containerNameField;
    private Button containerBrowseButton;

    protected WizardImportPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.currentResourceSelection = iStructuredSelection.size() == 1 ? (IResource)iStructuredSelection.getFirstElement() : null;
        if (this.currentResourceSelection != null) {
            if (this.currentResourceSelection.getType() == 1) {
                this.currentResourceSelection = this.currentResourceSelection.getParent();
            }
            if (!this.currentResourceSelection.isAccessible()) {
                this.currentResourceSelection = null;
            }
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setSize(composite2.computeSize(-1, -1));
        this.createSourceGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, IDEWorkbenchMessages.WizardImportPage_destinationLabel);
        this.createDestinationGroup(composite2);
        this.createSpacer(composite2);
        this.createBoldLabel(composite2, IDEWorkbenchMessages.WizardImportPage_options);
        this.createOptionsGroup(composite2);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite2);
    }

    protected final void createDestinationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.WizardImportPage_folder);
        this.containerNameField = new Text(composite2, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.containerNameField.setLayoutData((Object)gridData);
        this.containerBrowseButton = new Button(composite2, 8);
        this.containerBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browseLabel);
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.initialPopulateContainerField();
    }

    protected abstract void createSourceGroup(Composite var1);

    protected void displayErrorDialog(String string) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardImportPage_errorDialogTitle, (String)string);
    }

    protected IPath getContainerFullPath() {
        IPath iPath;
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IStatus iStatus = iWorkspace.validatePath((iPath = this.getResourcePath()).toString(), 6);
        if (iStatus.isOK()) {
            return iPath;
        }
        return null;
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath iPath = this.getContainerFullPath();
        if (iWorkspace.getRoot().exists(iPath)) {
            return (IContainer)iWorkspace.getRoot().findMember(iPath);
        }
        return null;
    }

    protected void handleContainerBrowseButtonPressed() {
        IPath iPath = this.queryForContainer(this.getSpecifiedContainer(), IDEWorkbenchMessages.WizardImportPage_selectFolderLabel);
        if (iPath != null) {
            this.containerNameField.setText(iPath.makeRelative().toString());
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.containerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        }
        this.setPageComplete(this.determinePageCompletion());
        this.updateWidgetEnablements();
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        } else if (this.currentResourceSelection != null) {
            this.containerNameField.setText(this.currentResourceSelection.getFullPath().toString());
        }
    }

    public void setContainerFieldValue(String string) {
        if (this.containerNameField == null) {
            this.initialContainerFieldValue = string;
        } else {
            this.containerNameField.setText(string);
        }
    }

    protected final boolean validateDestinationGroup() {
        if (this.getContainerFullPath() == null) {
            return false;
        }
        IContainer iContainer = this.getSpecifiedContainer();
        if (iContainer != null && !iContainer.isAccessible()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_folderMustExist);
            return false;
        }
        return true;
    }
}

