/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFile newFile;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private String initialFileName;
    private String initialFileExtension;
    private IPath initialContainerFullPath;
    private boolean initialAllowExistingResources = false;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFileCreationPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        this.setPageComplete(false);
        this.currentSelection = iStructuredSelection;
    }

    protected void createAdvancedControls(Composite composite) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(composite, 0);
            this.linkedResourceParent.setFont(composite.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)gridLayout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData gridData = this.setButtonLayoutData(this.advancedButton);
            gridData.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)gridData);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    WizardNewFileCreationPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(1, new Listener(){

            public void handleEvent(Event event) {
                WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
                WizardNewFileCreationPage.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public void setValue(String string) {
                WizardNewFileCreationPage.this.resourceGroup.setResource(string);
            }

            public String getValue() {
                return WizardNewFileCreationPage.this.resourceGroup.getResource();
            }

            public IProject getProject() {
                IPath iPath = WizardNewFileCreationPage.this.resourceGroup == null ? WizardNewFileCreationPage.this.initialContainerFullPath : WizardNewFileCreationPage.this.resourceGroup.getContainerFullPath();
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource != null) {
                    return iResource.getProject();
                }
                return null;
            }
        });
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(composite.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_file_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite2, this, this.getNewFileLabel(), IDEWorkbenchMessages.WizardNewFileCreationPage_file, false, 250);
        this.resourceGroup.setAllowExistingResources(this.initialAllowExistingResources);
        this.initialPopulateContainerNameField();
        this.createAdvancedControls(composite2);
        if (this.initialFileName != null) {
            this.resourceGroup.setResource(this.initialFileName);
        }
        if (this.initialFileExtension != null) {
            this.resourceGroup.setResourceExtension(this.initialFileExtension);
        }
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    protected void createFile(IFile iFile, InputStream inputStream, IProgressMonitor iProgressMonitor) throws CoreException {
        if (inputStream == null) {
            inputStream = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this.linkTargetPath != null) {
                iFile.createLink(this.linkTargetPath, 16, iProgressMonitor);
            } else {
                IPath iPath = iFile.getFullPath();
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                int n = iPath.segmentCount();
                if (n > 2 && !iWorkspaceRoot.getFolder(iPath.removeLastSegments(1)).exists()) {
                    int n2 = n - 2;
                    while (n2 > 0) {
                        IFolder iFolder = iWorkspaceRoot.getFolder(iPath.removeLastSegments(n2));
                        if (!iFolder.exists()) {
                            iFolder.create(false, true, iProgressMonitor);
                        }
                        --n2;
                    }
                }
                iFile.create(inputStream, false, iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFile.refreshLocal(0, null);
            }
            throw coreException;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath iPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFile(iPath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        IPath iPath = this.resourceGroup.getContainerFullPath();
        IPath iPath2 = iPath.append(this.resourceGroup.getResource());
        final IFile iFile = this.createFileHandle(iPath2);
        final InputStream inputStream = this.getInitialContents();
        this.createLinkTarget();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                CreateFileOperation createFileOperation = new CreateFileOperation(iFile, WizardNewFileCreationPage.this.linkTargetPath, inputStream, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                try {
                    createFileOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewFileCreationPage.this.getShell()));
                }
                catch (ExecutionException executionException) {
                    WizardNewFileCreationPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, executionException){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFileCreationPage.access$4(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewFile()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewFileCreationPage.access$4(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewFileCreationPage access$0(4 var0) {
                return var0.WizardNewFileCreationPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFile()", invocationTargetException.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)invocationTargetException.getTargetException().getMessage()));
            return null;
        }
        this.newFile = iFile;
        return this.newFile;
    }

    protected ISchedulingRule createRule(IResource iResource) {
        IContainer iContainer = iResource.getParent();
        while (iContainer != null) {
            if (iContainer.exists()) {
                return iResource.getWorkspace().getRuleFactory().createRule(iResource);
            }
            iResource = iContainer;
            iContainer = iContainer.getParent();
        }
        return iResource.getWorkspace().getRoot();
    }

    public IPath getContainerFullPath() {
        return this.resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this.resourceGroup == null) {
            return this.initialFileName;
        }
        return this.resourceGroup.getResource();
    }

    public String getFileExtension() {
        if (this.resourceGroup == null) {
            return this.initialFileExtension;
        }
        return this.resourceGroup.getResourceExtension();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return IDEWorkbenchMessages.WizardNewFileCreationPage_fileLabel;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(point.x, point.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point point2 = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = point2.y;
            }
            shell.setSize(point.x, point.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this.initialContainerFullPath != null) {
            this.resourceGroup.setContainerFullPath(this.initialContainerFullPath);
        } else {
            Iterator iterator = this.currentSelection.iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (iResource != null) {
                    if (iResource.getType() == 1) {
                        iResource = iResource.getParent();
                    }
                    if (iResource.isAccessible()) {
                        this.resourceGroup.setContainerFullPath(iResource.getFullPath());
                    }
                }
            }
        }
    }

    public void setAllowExistingResources(boolean bl) {
        if (this.resourceGroup == null) {
            this.initialAllowExistingResources = bl;
        } else {
            this.resourceGroup.setAllowExistingResources(bl);
        }
    }

    public void setContainerFullPath(IPath iPath) {
        if (this.resourceGroup == null) {
            this.initialContainerFullPath = iPath;
        } else {
            this.resourceGroup.setContainerFullPath(iPath);
        }
    }

    public void setFileName(String string) {
        if (this.resourceGroup == null) {
            this.initialFileName = string;
        } else {
            this.resourceGroup.setResource(string);
        }
    }

    public void setFileExtension(String string) {
        if (this.resourceGroup == null) {
            this.initialFileExtension = string;
        } else {
            this.resourceGroup.setResourceExtension(string);
        }
    }

    protected IStatus validateLinkedResource() {
        IPath iPath = this.resourceGroup.getContainerFullPath();
        IPath iPath2 = iPath.append(this.resourceGroup.getResource());
        IFile iFile = this.createFileHandle(iPath2);
        IStatus iStatus = this.linkedResourceGroup.validateLinkLocation((IResource)iFile);
        if (iStatus.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(iStatus.getMessage());
            } else {
                this.setErrorMessage(iStatus.getMessage());
            }
        } else if (iStatus.getSeverity() == 2) {
            this.setMessage(iStatus.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return iStatus;
    }

    protected boolean validatePage() {
        boolean bl = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            bl = false;
        }
        String string = this.resourceGroup.getResource();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IStatus iStatus = iWorkspace.validateName(string, 1);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        IStatus iStatus2 = null;
        if (bl && (iStatus2 = this.validateLinkedResource()).getSeverity() == 4) {
            bl = false;
        }
        if (bl && (iStatus2 == null || iStatus2.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
            if (this.resourceGroup.getAllowExistingResources()) {
                String string2 = NLS.bind((String)IDEWorkbenchMessages.ResourceGroup_nameExists, (Object)this.getFileName());
                IPath iPath = this.getContainerFullPath().append(this.getFileName());
                if (iWorkspace.getRoot().getFolder(iPath).exists()) {
                    this.setErrorMessage(string2);
                    bl = false;
                }
                if (iWorkspace.getRoot().getFile(iPath).exists()) {
                    this.setMessage(string2, 2);
                }
            }
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.resourceGroup.setFocus();
        }
    }
}

