/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class WizardNewFolderMainPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFolder newFolder;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFolderMainPage(String string, IStructuredSelection iStructuredSelection) {
        super("newFolderPage1");
        this.setTitle(string);
        this.setDescription(IDEWorkbenchMessages.WizardNewFolderMainPage_description);
        this.currentSelection = iStructuredSelection;
    }

    protected void createAdvancedControls(Composite composite) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(composite, 0);
            this.linkedResourceParent.setFont(composite.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)gridLayout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData gridData = this.setButtonLayoutData(this.advancedButton);
            gridData.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)gridData);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    WizardNewFolderMainPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event event) {
                WizardNewFolderMainPage.this.setPageComplete(WizardNewFolderMainPage.this.validatePage());
                WizardNewFolderMainPage.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public String getValue() {
                return WizardNewFolderMainPage.this.resourceGroup.getResource();
            }

            public void setValue(String string) {
                WizardNewFolderMainPage.this.resourceGroup.setResource(string);
            }

            public IProject getProject() {
                IPath iPath = WizardNewFolderMainPage.this.resourceGroup.getContainerFullPath();
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource iResource = iWorkspaceRoot.findMember(iPath);
                if (iResource != null) {
                    return iResource.getProject();
                }
                return null;
            }
        });
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_folder_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite2, this, IDEWorkbenchMessages.WizardNewFolderMainPage_folderName, IDEWorkbenchMessages.WizardNewFolderMainPage_folderLabel, false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.createAdvancedControls(composite2);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    protected void createFolder(IFolder iFolder, IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            if (!iFolder.exists()) {
                if (this.linkTargetPath != null) {
                    iFolder.createLink(this.linkTargetPath, 16, iProgressMonitor);
                } else {
                    IPath iPath = iFolder.getFullPath();
                    IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    int n = iPath.segmentCount();
                    if (n > 2 && !iWorkspaceRoot.getFolder(iPath.removeLastSegments(1)).exists()) {
                        int n2 = n - 2;
                        while (n2 > 0) {
                            IFolder iFolder2 = iWorkspaceRoot.getFolder(iPath.removeLastSegments(n2));
                            if (!iFolder2.exists()) {
                                iFolder2.create(false, true, iProgressMonitor);
                            }
                            --n2;
                        }
                    }
                    iFolder.create(false, true, iProgressMonitor);
                }
            }
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 374) {
                iFolder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 500));
            }
            throw coreException;
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFolder createFolderHandle(IPath iPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(iPath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFolder createNewFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        IPath iPath = this.resourceGroup.getContainerFullPath();
        IPath iPath2 = iPath.append(this.resourceGroup.getResource());
        final IFolder iFolder = this.createFolderHandle(iPath2);
        this.createLinkTarget();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                CreateFolderOperation createFolderOperation = new CreateFolderOperation(iFolder, WizardNewFolderMainPage.this.linkTargetPath, IDEWorkbenchMessages.WizardNewFolderCreationPage_title);
                try {
                    createFolderOperation.execute(iProgressMonitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewFolderMainPage.this.getShell()));
                }
                catch (ExecutionException executionException) {
                    WizardNewFolderMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, executionException){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFolderMainPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewFolder()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewFolderMainPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewFolderMainPage access$0(4 var0) {
                return var0.WizardNewFolderMainPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFolder()", invocationTargetException.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)invocationTargetException.getTargetException().getMessage()));
            return null;
        }
        this.newFolder = iFolder;
        return this.newFolder;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point point = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(point.x, point.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point point2 = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = point2.y;
            }
            shell.setSize(point.x, point.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Iterator iterator = this.currentSelection.iterator();
        if (iterator.hasNext()) {
            Object e = iterator.next();
            IResource iResource = null;
            if (e instanceof IResource) {
                iResource = (IResource)e;
            } else if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource != null) {
                if (iResource.getType() == 1) {
                    iResource = iResource.getParent();
                }
                if (iResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(iResource.getFullPath());
                }
            }
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.resourceGroup.setFocus();
        }
    }

    protected IStatus validateLinkedResource() {
        IPath iPath = this.resourceGroup.getContainerFullPath();
        IPath iPath2 = iPath.append(this.resourceGroup.getResource());
        IFolder iFolder = this.createFolderHandle(iPath2);
        IStatus iStatus = this.linkedResourceGroup.validateLinkLocation((IResource)iFolder);
        if (iStatus.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(iStatus.getMessage());
            } else {
                this.setErrorMessage(iStatus.getMessage());
            }
        } else if (iStatus.getSeverity() == 2) {
            this.setMessage(iStatus.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return iStatus;
    }

    protected boolean validatePage() {
        boolean bl = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            bl = false;
        }
        IStatus iStatus = null;
        if (bl && (iStatus = this.validateLinkedResource()).getSeverity() == 4) {
            bl = false;
        }
        if (bl && (iStatus == null || iStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return bl;
    }
}

