/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;

public class WizardNewLinkPage
extends WizardPage {
    private String initialLinkTarget;
    private int type;
    private boolean createLink = false;
    private IContainer container;
    private Text linkTargetField;
    private Button browseButton;
    private Button variablesButton;

    public WizardNewLinkPage(String string, int n) {
        super(string);
        this.type = n;
        this.setPageComplete(true);
    }

    public void createControl(Composite composite) {
        Font font = composite.getFont();
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setFont(font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_link_wizard_page_context");
        final Button button = new Button(composite2, 32);
        if (this.type == 1) {
            button.setText(IDEWorkbenchMessages.WizardNewLinkPage_linkFileButton);
        } else {
            button.setText(IDEWorkbenchMessages.WizardNewLinkPage_linkFolderButton);
        }
        button.setSelection(this.createLink);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        button.setLayoutData((Object)gridData);
        button.setFont(font);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardNewLinkPage.this.createLink = button.getSelection();
                WizardNewLinkPage.this.browseButton.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.variablesButton.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.linkTargetField.setEnabled(WizardNewLinkPage.this.createLink);
                WizardNewLinkPage.this.setPageComplete(WizardNewLinkPage.this.validatePage());
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        this.createLinkLocationGroup(composite2, this.createLink);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
    }

    private void createLinkLocationGroup(Composite composite, boolean bl) {
        Font font = composite.getFont();
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        Button button = new Button(composite, 32);
        gridData.widthHint = button.computeSize((int)-1, (int)-1).x;
        button.dispose();
        label.setLayoutData((Object)gridData);
        this.linkTargetField = new Text(composite, 2048);
        gridData = new GridData(768);
        this.linkTargetField.setLayoutData((Object)gridData);
        this.linkTargetField.setFont(font);
        this.linkTargetField.setEnabled(bl);
        this.linkTargetField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                WizardNewLinkPage.this.setPageComplete(WizardNewLinkPage.this.validatePage());
            }
        });
        if (this.initialLinkTarget != null) {
            this.linkTargetField.setText(this.initialLinkTarget);
        }
        this.browseButton = new Button(composite, 8);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.setFont(font);
        this.browseButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardNewLinkPage.this.handleLinkTargetBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(bl);
        label = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.variablesButton = new Button(composite, 8);
        this.setButtonLayoutData(this.variablesButton);
        this.variablesButton.setFont(font);
        this.variablesButton.setText(IDEWorkbenchMessages.WizardNewLinkPage_variablesButton);
        this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WizardNewLinkPage.this.handleVariablesButtonPressed();
            }
        });
        this.variablesButton.setEnabled(bl);
    }

    public String getLinkTarget() {
        if (this.createLink && this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            return this.linkTargetField.getText();
        }
        return null;
    }

    private void handleLinkTargetBrowseButtonPressed() {
        String string = this.linkTargetField.getText();
        String string2 = null;
        IFileStore iFileStore = null;
        if (!(string.length() <= 0 || (iFileStore = IDEResourceInfoUtils.getFileStore(string)) != null && iFileStore.fetchInfo().exists())) {
            iFileStore = null;
        }
        if (this.type == 1) {
            FileDialog fileDialog = new FileDialog(this.getShell());
            if (iFileStore != null) {
                if (iFileStore.fetchInfo().isDirectory()) {
                    fileDialog.setFilterPath(string);
                } else {
                    fileDialog.setFileName(string);
                }
            }
            string2 = fileDialog.open();
        } else {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
            if (iFileStore != null) {
                if (!iFileStore.fetchInfo().isDirectory()) {
                    string = iFileStore.getParent().getName();
                }
                if (string != null) {
                    directoryDialog.setFilterPath(string);
                }
            }
            directoryDialog.setMessage(IDEWorkbenchMessages.WizardNewLinkPage_targetSelectionLabel);
            string2 = directoryDialog.open();
        }
        if (string2 != null) {
            this.linkTargetField.setText(string2);
        }
    }

    private void handleVariablesButtonPressed() {
        IPathVariableManager iPathVariableManager;
        IPath iPath;
        String[] stringArray;
        PathVariableSelectionDialog pathVariableSelectionDialog = new PathVariableSelectionDialog(this.getShell(), this.type);
        if (pathVariableSelectionDialog.open() == 0 && (stringArray = (String[])pathVariableSelectionDialog.getResult()) != null && (iPath = (iPathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager()).getValue(stringArray[0])) != null) {
            this.linkTargetField.setText(iPath.toOSString());
        }
    }

    public void setContainer(IContainer iContainer) {
        this.container = iContainer;
    }

    public void setLinkTarget(String string) {
        this.initialLinkTarget = string;
        if (this.linkTargetField != null && !this.linkTargetField.isDisposed()) {
            this.linkTargetField.setText(string);
        }
    }

    private boolean validateFileType(IFileStore iFileStore) {
        boolean bl = true;
        if (this.type == 1 && iFileStore.fetchInfo().isDirectory()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNotFile);
            bl = false;
        } else if (this.type == 2 && !iFileStore.fetchInfo().isDirectory()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNotFolder);
            bl = false;
        }
        return bl;
    }

    private boolean validateLinkTargetName(String string) {
        boolean bl = true;
        if ("".equals(string)) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetEmpty);
            bl = false;
        } else {
            Path path = new Path("");
            if (!path.isValidPath(string)) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetInvalid);
                bl = false;
            }
        }
        return bl;
    }

    private boolean validatePage() {
        String string;
        boolean bl = true;
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        if (this.createLink && (bl = this.validateLinkTargetName(string = this.linkTargetField.getText()))) {
            IFileStore iFileStore = IDEResourceInfoUtils.getFileStore(string);
            if (iFileStore == null || !iFileStore.fetchInfo().exists()) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetNonExistent);
                bl = false;
            } else {
                IStatus iStatus = iWorkspace.validateLinkLocation((IResource)this.container, (IPath)new Path(string));
                if (!iStatus.isOK()) {
                    this.setErrorMessage(IDEWorkbenchMessages.WizardNewLinkPage_linkTargetLocationInvalid);
                    bl = false;
                } else {
                    bl = this.validateFileType(iFileStore);
                }
            }
        }
        if (bl) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return bl;
    }
}

