/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class WizardNewProjectCreationPage
extends WizardPage {
    private String initialProjectFieldValue;
    Text projectNameField;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event event) {
            WizardNewProjectCreationPage.this.setLocationForSelection();
            boolean bl = WizardNewProjectCreationPage.this.validatePage();
            WizardNewProjectCreationPage.this.setPageComplete(bl);
        }
    };
    private ProjectContentsLocationArea locationArea;
    private WorkingSetGroup workingSetGroup;
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardNewProjectCreationPage(String string) {
        super(string);
        this.setPageComplete(false);
    }

    public WizardNewProjectCreationPage(String string, IStructuredSelection iStructuredSelection, String[] stringArray) {
        this(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite2);
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), composite2);
        if (this.initialProjectFieldValue != null) {
            this.locationArea.updateProjectName(this.initialProjectFieldValue);
        }
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public WorkingSetGroup createWorkingSetGroup(Composite composite, IStructuredSelection iStructuredSelection, String[] stringArray) {
        if (this.workingSetGroup != null) {
            return this.workingSetGroup;
        }
        this.workingSetGroup = new WorkingSetGroup(composite, iStructuredSelection, stringArray);
        return this.workingSetGroup;
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String string, boolean bl) {
                boolean bl2;
                if (bl) {
                    WizardNewProjectCreationPage.this.setMessage(string, 1);
                    WizardNewProjectCreationPage.this.setErrorMessage(null);
                } else {
                    WizardNewProjectCreationPage.this.setErrorMessage(string);
                }
                boolean bl3 = bl2 = string == null;
                if (bl2) {
                    bl2 = WizardNewProjectCreationPage.this.validatePage();
                }
                WizardNewProjectCreationPage.this.setPageComplete(bl2);
            }
        };
    }

    private final void createProjectNameGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.WizardNewProjectCreationPage_nameLabel);
        label.setFont(composite.getFont());
        this.projectNameField = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.projectNameField.setLayoutData((Object)gridData);
        this.projectNameField.setFont(composite.getFont());
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    public IPath getLocationPath() {
        return new Path(this.locationArea.getProjectLocation());
    }

    public URI getLocationURI() {
        return this.locationArea.getProjectLocationURI();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    public void setInitialProjectName(String string) {
        if (string == null) {
            this.initialProjectFieldValue = null;
        } else {
            this.initialProjectFieldValue = string.trim();
            if (this.locationArea != null) {
                this.locationArea.updateProjectName(string.trim());
            }
        }
    }

    void setLocationForSelection() {
        this.locationArea.updateProjectName(this.getProjectNameFieldValue());
    }

    protected boolean validatePage() {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        String string = this.getProjectNameFieldValue();
        if (string.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectNameEmpty);
            return false;
        }
        IStatus iStatus = iWorkspace.validateName(string, 4);
        if (!iStatus.isOK()) {
            this.setErrorMessage(iStatus.getMessage());
            return false;
        }
        IProject iProject = this.getProjectHandle();
        if (iProject.exists()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardNewProjectCreationPage_projectExistsMessage);
            return false;
        }
        IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectNameFieldValue());
        this.locationArea.setExistingProject(iProject2);
        String string2 = this.locationArea.checkValidLocation();
        if (string2 != null) {
            this.setErrorMessage(string2);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.projectNameField.setFocus();
        }
    }

    public boolean useDefaults() {
        return this.locationArea.isDefault();
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        return this.workingSetGroup == null ? new IWorkingSet[]{} : this.workingSetGroup.getSelectedWorkingSets();
    }
}

