/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.TypeFilteringDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.IElementFilter;
import org.eclipse.ui.internal.ide.dialogs.ResourceTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public abstract class WizardResourceImportPage
extends WizardDataTransferPage {
    private IResource currentResourceSelection = null;
    private String initialContainerFieldValue;
    protected List selectedTypes = new ArrayList();
    private Text containerNameField;
    private Button containerBrowseButton;
    protected ResourceTreeAndListGroup selectionGroup;
    private static final String EMPTY_FOLDER_MESSAGE = IDEWorkbenchMessages.WizardImportPage_specifyFolder;
    private static final String EMPTY_PROJECT_MESSAGE = IDEWorkbenchMessages.WizardImportPage_specifyProject;
    private static final String INACCESSABLE_FOLDER_MESSAGE = IDEWorkbenchMessages.WizardImportPage_folderMustExist;
    static /* synthetic */ Class class$0;

    protected WizardResourceImportPage(String string, IStructuredSelection iStructuredSelection) {
        super(string);
        Object object;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof IAdaptable) {
            Object object2;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((object2 = iAdaptable.getAdapter((Class)clazz)) != null) {
                this.currentResourceSelection = (IResource)object2;
            }
        }
        if (this.currentResourceSelection != null) {
            if (this.currentResourceSelection.getType() == 1) {
                this.currentResourceSelection = this.currentResourceSelection.getParent();
            }
            if (!this.currentResourceSelection.isAccessible()) {
                this.currentResourceSelection = null;
            }
        }
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)new GridData(272));
        composite2.setSize(composite2.computeSize(-1, -1));
        composite2.setFont(composite.getFont());
        this.createSourceGroup(composite2);
        this.createDestinationGroup(composite2);
        this.createOptionsGroup(composite2);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite2);
    }

    protected final void createDestinationGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.WizardImportPage_folder);
        label.setFont(composite.getFont());
        this.containerNameField = new Text(composite2, 2052);
        this.containerNameField.addListener(24, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.containerNameField.setLayoutData((Object)gridData);
        this.containerNameField.setFont(composite.getFont());
        this.containerBrowseButton = new Button(composite2, 8);
        this.containerBrowseButton.setText(IDEWorkbenchMessages.WizardImportPage_browse2);
        this.containerBrowseButton.setLayoutData((Object)new GridData(256));
        this.containerBrowseButton.addListener(13, (Listener)this);
        this.containerBrowseButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.containerBrowseButton);
        this.initialPopulateContainerField();
    }

    protected void createFileSelectionGroup(Composite composite) {
        this.selectionGroup = new ResourceTreeAndListGroup(composite, new FileSystemElement("Dummy", null, true), this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, DialogUtil.inRegularFontMode(composite));
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WizardResourceImportPage.this.updateWidgetEnablements();
            }
        };
        WorkbenchViewerComparator workbenchViewerComparator = new WorkbenchViewerComparator();
        this.selectionGroup.setTreeComparator((ViewerComparator)workbenchViewerComparator);
        this.selectionGroup.setListComparator((ViewerComparator)workbenchViewerComparator);
        this.selectionGroup.addCheckStateListener(iCheckStateListener);
    }

    protected abstract void createSourceGroup(Composite var1);

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardImportPage_errorDialogTitle;
    }

    protected IPath getContainerFullPath() {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath iPath = this.getResourcePath();
        if (iPath.equals((Object)iWorkspace.getRoot().getFullPath())) {
            return iPath;
        }
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 14);
        if (iStatus.isOK()) {
            return iPath;
        }
        return null;
    }

    protected abstract ITreeContentProvider getFileProvider();

    protected abstract ITreeContentProvider getFolderProvider();

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    protected List getSelectedResources() {
        return this.selectionGroup.getAllCheckedListItems();
    }

    protected void getSelectedResources(IElementFilter iElementFilter, IProgressMonitor iProgressMonitor) throws InterruptedException {
        this.selectionGroup.getAllCheckedListItems(iElementFilter, iProgressMonitor);
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
        IPath iPath = this.getContainerFullPath();
        if (iWorkspace.getRoot().exists(iPath)) {
            IResource iResource = iWorkspace.getRoot().findMember(iPath);
            if (iResource.getType() == 1) {
                return null;
            }
            return (IContainer)iResource;
        }
        return null;
    }

    protected List getTypesToImport() {
        return this.selectedTypes;
    }

    protected void handleContainerBrowseButtonPressed() {
        IPath iPath = this.queryForContainer(this.getSpecifiedContainer(), IDEWorkbenchMessages.WizardImportPage_selectFolderLabel, IDEWorkbenchMessages.WizardImportPage_selectFolderTitle);
        if (iPath != null) {
            this.setErrorMessage(null);
            this.containerNameField.setText(iPath.makeRelative().toString());
        }
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.containerBrowseButton) {
            this.handleContainerBrowseButtonPressed();
        }
        this.updateWidgetEnablements();
    }

    protected void handleTypesEditButtonPressed() {
        TypeFilteringDialog typeFilteringDialog = new TypeFilteringDialog(this.getContainer().getShell(), (Collection)this.getTypesToImport());
        typeFilteringDialog.open();
        Object[] objectArray = typeFilteringDialog.getResult();
        if (objectArray != null) {
            this.selectedTypes = new ArrayList(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                this.selectedTypes.add(objectArray[n]);
                ++n;
            }
            this.setupSelectionsBasedOnSelectedTypes();
        }
    }

    protected final void initialPopulateContainerField() {
        if (this.initialContainerFieldValue != null) {
            this.containerNameField.setText(this.initialContainerFieldValue);
        } else if (this.currentResourceSelection != null) {
            this.containerNameField.setText(this.currentResourceSelection.getFullPath().makeRelative().toString());
        }
    }

    protected void setAllSelections(boolean bl) {
        this.selectionGroup.setAllSelections(bl);
    }

    public void setContainerFieldValue(String string) {
        if (this.containerNameField == null) {
            this.initialContainerFieldValue = string;
        } else {
            this.containerNameField.setText(string);
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
    }

    protected void updateSelections(final Map map) {
        Runnable runnable = new Runnable(){

            public void run() {
                WizardResourceImportPage.this.selectionGroup.updateSelections(map);
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)runnable);
    }

    protected void updateWidgetEnablements() {
        boolean bl = this.determinePageCompletion();
        this.setPageComplete(bl);
        if (bl) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected final boolean validateDestinationGroup() {
        IPath iPath = this.getContainerFullPath();
        if (iPath == null) {
            this.setMessage(EMPTY_FOLDER_MESSAGE);
            return false;
        }
        IContainer iContainer = this.getSpecifiedContainer();
        if (iContainer == null) {
            if (IDEWorkbenchPlugin.getPluginWorkspace().getRoot().exists(this.getContainerFullPath())) {
                return false;
            }
            IWorkspace iWorkspace = IDEWorkbenchPlugin.getPluginWorkspace();
            IPath iPath2 = iPath.removeLastSegments(iPath.segmentCount() - 1);
            if (iWorkspace.getRoot().exists(iPath2)) {
                return true;
            }
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_projectNotExist);
            return false;
        }
        if (!iContainer.isAccessible()) {
            this.setErrorMessage(INACCESSABLE_FOLDER_MESSAGE);
            return false;
        }
        if (iContainer.getLocationURI() == null) {
            if (iContainer.isLinked()) {
                this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_undefinedPathVariable);
            } else {
                this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_containerNotExist);
            }
            return false;
        }
        if (this.sourceConflictsWithDestination(iPath)) {
            this.setErrorMessage(this.getSourceConflictMessage());
            return false;
        }
        if (iContainer instanceof IWorkspaceRoot) {
            this.setErrorMessage(EMPTY_PROJECT_MESSAGE);
            return false;
        }
        return true;
    }

    protected final String getSourceConflictMessage() {
        return IDEWorkbenchMessages.WizardImportPage_importOnReceiver;
    }

    protected boolean sourceConflictsWithDestination(IPath iPath) {
        return false;
    }

    protected boolean determinePageCompletion() {
        if (this.noOpenProjects()) {
            this.setErrorMessage(IDEWorkbenchMessages.WizardImportPage_noOpenProjects);
            return false;
        }
        return super.determinePageCompletion();
    }

    private boolean noOpenProjects() {
        IProject[] iProjectArray = IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isOpen()) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

