/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.MultiPartInitException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.model.StandardPropertiesAdapterFactory;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterFactory;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.part.FileEditorInput;

public final class IDE {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    public static final String EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    private static MarkerHelpRegistry markerHelpRegistry = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    private IDE() {
    }

    public static IMarkerHelpRegistry getMarkerHelpRegistry() {
        if (markerHelpRegistry == null) {
            markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(markerHelpRegistry);
        }
        return markerHelpRegistry;
    }

    public static void gotoMarker(IEditorPart iEditorPart, IMarker iMarker) {
        IGotoMarker iGotoMarker = null;
        if (iEditorPart instanceof IGotoMarker) {
            iGotoMarker = (IGotoMarker)iEditorPart;
        } else {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iGotoMarker = (IGotoMarker)iEditorPart.getAdapter((Class)clazz);
        }
        if (iGotoMarker != null) {
            iGotoMarker.gotoMarker(iMarker);
        }
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IEditorInput iEditorInput, String string) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        return iWorkbenchPage.openEditor(iEditorInput, string);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, URI uRI, String string, boolean bl) throws PartInitException {
        IFileStore iFileStore;
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        try {
            iFileStore = EFS.getStore((URI)uRI);
        }
        catch (CoreException coreException) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_coreExceptionFileStore, (Throwable)coreException);
        }
        IEditorInput iEditorInput = IDE.getEditorInput(iFileStore);
        return iWorkbenchPage.openEditor(iEditorInput, string, bl);
    }

    private static IEditorInput getEditorInput(IFileStore iFileStore) {
        IFile iFile = IDE.getWorkspaceFile(iFileStore);
        if (iFile != null) {
            return new FileEditorInput(iFile);
        }
        return new FileStoreEditorInput(iFileStore);
    }

    private static IFile getWorkspaceFile(IFileStore iFileStore) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = iWorkspaceRoot.findFilesForLocationURI(iFileStore.toURI());
        if ((iFileArray = IDE.filterNonExistentFiles(iFileArray)) == null || iFileArray.length == 0) {
            return null;
        }
        return iFileArray[0];
    }

    private static IFile[] filterNonExistentFiles(IFile[] iFileArray) {
        if (iFileArray == null) {
            return null;
        }
        int n = iFileArray.length;
        ArrayList<IFile> arrayList = new ArrayList<IFile>(n);
        int n2 = 0;
        while (n2 < n) {
            if (iFileArray[n2].exists()) {
                arrayList.add(iFileArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IEditorInput iEditorInput, String string, boolean bl) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        return iWorkbenchPage.openEditor(iEditorInput, string, bl);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IFile iFile, boolean bl) throws PartInitException {
        return IDE.openEditor(iWorkbenchPage, iFile, bl, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IFile iFile, boolean bl, boolean bl2) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor(iFile, bl2);
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId(), bl);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IFile iFile) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        IEditorDescriptor iEditorDescriptor = IDE.getEditorDescriptor(iFile);
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId());
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IFile iFile, String string) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), string);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IFile iFile, String string, boolean bl) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        return iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), string, bl);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile iFile) throws PartInitException {
        return IDE.getEditorDescriptor(iFile, true);
    }

    public static IEditorDescriptor getEditorDescriptor(IFile iFile, boolean bl) throws PartInitException {
        if (iFile == null) {
            throw new IllegalArgumentException();
        }
        return IDE.getEditorDescriptor(iFile.getName(), PlatformUI.getWorkbench().getEditorRegistry(), IDE.getDefaultEditor(iFile, bl));
    }

    private static String getEditorId(IFileStore iFileStore) throws PartInitException {
        Object object;
        String string = iFileStore.fetchInfo().getName();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        IContentType iContentType = null;
        try {
            object = null;
            try {
                object = iFileStore.openInputStream(0, null);
                iContentType = Platform.getContentTypeManager().findContentTypeFor((InputStream)object, string);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        object = PlatformUI.getWorkbench().getEditorRegistry();
        return IDE.getEditorDescriptor(string, (IEditorRegistry)object, object.getDefaultEditor(string, iContentType)).getId();
    }

    public static IEditorDescriptor getEditorDescriptor(String string) throws PartInitException {
        return IDE.getEditorDescriptor(string, true);
    }

    public static IEditorDescriptor getEditorDescriptor(String string, boolean bl) throws PartInitException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        IContentType iContentType = bl ? Platform.getContentTypeManager().findContentTypeFor(string) : null;
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        return IDE.getEditorDescriptor(string, iEditorRegistry, iEditorRegistry.getDefaultEditor(string, iContentType));
    }

    private static IEditorDescriptor getEditorDescriptor(String string, IEditorRegistry iEditorRegistry, IEditorDescriptor iEditorDescriptor) throws PartInitException {
        if (iEditorDescriptor != null) {
            return iEditorDescriptor;
        }
        IEditorDescriptor iEditorDescriptor2 = iEditorDescriptor;
        if (iEditorRegistry.isSystemInPlaceEditorAvailable(string)) {
            iEditorDescriptor2 = iEditorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (iEditorDescriptor2 == null && iEditorRegistry.isSystemExternalEditorAvailable(string)) {
            iEditorDescriptor2 = iEditorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (iEditorDescriptor2 == null) {
            iEditorDescriptor2 = iEditorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (iEditorDescriptor2 == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return iEditorDescriptor2;
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IMarker iMarker) throws PartInitException {
        return IDE.openEditor(iWorkbenchPage, iMarker, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage iWorkbenchPage, IMarker iMarker, boolean bl) throws PartInitException {
        String string;
        if (iWorkbenchPage == null || iMarker == null) {
            throw new IllegalArgumentException();
        }
        if (!(iMarker.getResource() instanceof IFile)) {
            IDEWorkbenchPlugin.log("Open editor on marker failed; marker resource not an IFile");
            return null;
        }
        IFile iFile = (IFile)iMarker.getResource();
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = null;
        try {
            string = (String)iMarker.getAttribute(EDITOR_ID_ATTR);
            if (string != null) {
                iEditorDescriptor = iEditorRegistry.findEditor(string);
            }
        }
        catch (CoreException coreException) {}
        string = null;
        string = iEditorDescriptor == null ? IDE.openEditor(iWorkbenchPage, iFile, bl) : iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId(), bl);
        if (string != null) {
            IDE.gotoMarker((IEditorPart)string, iMarker);
        }
        return string;
    }

    public static IEditorPart openEditorOnFileStore(IWorkbenchPage iWorkbenchPage, IFileStore iFileStore) throws PartInitException {
        if (iWorkbenchPage == null) {
            throw new IllegalArgumentException();
        }
        IEditorInput iEditorInput = IDE.getEditorInput(iFileStore);
        String string = IDE.getEditorId(iFileStore);
        return iWorkbenchPage.openEditor(iEditorInput, string);
    }

    public static boolean saveAllEditors(final IResource[] iResourceArray, final boolean bl) {
        if (iResourceArray.length == 0) {
            return true;
        }
        final boolean[] blArray = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnSaveAll){

            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray;
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null && (iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                    iWorkbenchWindow = iWorkbenchWindowArray[0];
                }
                if (iWorkbenchWindow != null) {
                    blArray[0] = PlatformUI.getWorkbench().saveAll((IShellProvider)iWorkbenchWindow, (IRunnableContext)iWorkbenchWindow, (ISaveableFilter)new SaveFilter(iResourceArray), bl);
                }
            }
        });
        return blArray[0];
    }

    public static void setDefaultEditor(IFile iFile, String string) {
        try {
            iFile.setPersistentProperty(EDITOR_KEY, string);
        }
        catch (CoreException coreException) {}
    }

    public static IEditorDescriptor getDefaultEditor(IFile iFile) {
        return IDE.getDefaultEditor(iFile, true);
    }

    public static IEditorDescriptor getDefaultEditor(IFile iFile, boolean bl) {
        String string;
        IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        try {
            IEditorDescriptor iEditorDescriptor;
            string = iFile.getPersistentProperty(EDITOR_KEY);
            if (string != null && (iEditorDescriptor = iEditorRegistry.findEditor(string)) != null) {
                return iEditorDescriptor;
            }
        }
        catch (CoreException coreException) {}
        string = null;
        if (bl) {
            string = IDE.getContentType(iFile);
        }
        return iEditorRegistry.getDefaultEditor(iFile.getName(), (IContentType)string);
    }

    public static List computeSelectedResources(IStructuredSelection iStructuredSelection) {
        ArrayList<Object> arrayList = null;
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = null;
            if (e instanceof IResource) {
                object = e;
            } else if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object = iAdaptable.getAdapter((Class)clazz);
            }
            if (object == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Object>(iStructuredSelection.size());
            }
            arrayList.add(object);
        }
        if (arrayList == null) {
            return Collections.EMPTY_LIST;
        }
        return arrayList;
    }

    public static IContentType getContentType(IFile iFile) {
        try {
            UIStats.start((int)14, (String)iFile.getName());
            IContentDescription iContentDescription = iFile.getContentDescription();
            if (iContentDescription == null) {
                return null;
            }
            IContentType iContentType = iContentDescription.getContentType();
            return iContentType;
        }
        catch (CoreException coreException) {
            if (coreException.getStatus().getCode() == 274) {
                IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(iFile.getName());
                return iContentType;
            }
            return null;
        }
        finally {
            UIStats.end((int)14, (Object)iFile, (String)iFile.getName());
        }
    }

    public static IContentType guessContentType(IFile iFile) {
        String string = iFile.getName();
        try {
            UIStats.start((int)14, (String)string);
            IContentTypeMatcher iContentTypeMatcher = iFile.getProject().getContentTypeMatcher();
            IContentType iContentType = iContentTypeMatcher.findContentTypeFor(string);
            return iContentType;
        }
        catch (CoreException coreException) {
            return null;
        }
        finally {
            UIStats.end((int)14, (Object)iFile, (String)string);
        }
    }

    public static boolean promptToConfirm(final Shell shell, final String string, String string2, IResourceDelta iResourceDelta, String[] stringArray, boolean bl) {
        Object object;
        Object[] objectArray;
        Object object2;
        IStatus iStatus = ResourceChangeValidator.getValidator().validateChange(iResourceDelta, null);
        if (iStatus.isOK()) {
            return true;
        }
        if (iStatus.isMultiStatus()) {
            object2 = new ArrayList();
            objectArray = iStatus.getChildren();
            int n = 0;
            while (n < objectArray.length) {
                IStatus iStatus2 = objectArray[n];
                if (!IDE.isIgnoredStatus(iStatus2, stringArray)) {
                    object2.add(iStatus2);
                }
                ++n;
            }
            if (object2.isEmpty()) {
                return true;
            }
            object = object2.size() == 1 ? (IStatus)object2.get(0) : new MultiStatus(iStatus.getPlugin(), iStatus.getCode(), object2.toArray(new IStatus[object2.size()]), iStatus.getMessage(), iStatus.getException());
        } else {
            if (IDE.isIgnoredStatus(iStatus, stringArray)) {
                return true;
            }
            object = iStatus;
        }
        if (string2 == null) {
            string2 = IDEWorkbenchMessages.IDE_sideEffectWarning;
        }
        object2 = NLS.bind((String)IDEWorkbenchMessages.IDE_areYouSure, (Object)string2);
        objectArray = new boolean[1];
        Runnable runnable = new Runnable((String)object2, (IStatus)object, (boolean[])objectArray){
            private final /* synthetic */ String val$dialogMessage;
            private final /* synthetic */ IStatus val$displayStatus;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$dialogMessage = string2;
                this.val$displayStatus = iStatus;
                this.val$result = blArray;
            }

            public void run() {
                ErrorDialog errorDialog = new ErrorDialog(this, shell, string, this.val$dialogMessage, this.val$displayStatus, 7){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected void createButtonsForButtonBar(Composite composite) {
                        this.createButton(composite, 2, IDialogConstants.YES_LABEL, false);
                        this.createButton(composite, 3, IDialogConstants.NO_LABEL, true);
                        this.createDetailsButton(composite);
                    }

                    protected void buttonPressed(int n) {
                        if (n == 2) {
                            super.buttonPressed(0);
                        } else if (n == 3) {
                            super.buttonPressed(1);
                        }
                        super.buttonPressed(n);
                    }
                };
                int n = errorDialog.open();
                this.val$result[0] = n == 0;
            }
        };
        if (bl) {
            shell.getDisplay().syncExec(runnable);
        } else {
            runnable.run();
        }
        return (boolean)objectArray[0];
    }

    public static void registerAdapters() {
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        WorkbenchAdapterFactory workbenchAdapterFactory = new WorkbenchAdapterFactory();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IWorkspace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.core.resources.IWorkspaceRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz3);
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz4);
        Class<?> clazz5 = class$6;
        if (clazz5 == null) {
            try {
                clazz5 = class$6 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz5);
        Class<?> clazz6 = class$7;
        if (clazz6 == null) {
            try {
                clazz6 = class$7 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)workbenchAdapterFactory, (Class)clazz6);
        StandardPropertiesAdapterFactory standardPropertiesAdapterFactory = new StandardPropertiesAdapterFactory();
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("org.eclipse.core.resources.IWorkspace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz7);
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("org.eclipse.core.resources.IWorkspaceRoot");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz8);
        Class<?> clazz9 = class$4;
        if (clazz9 == null) {
            try {
                clazz9 = class$4 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz9);
        Class<?> clazz10 = class$5;
        if (clazz10 == null) {
            try {
                clazz10 = class$5 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz10);
        Class<?> clazz11 = class$6;
        if (clazz11 == null) {
            try {
                clazz11 = class$6 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz11);
        Class<?> clazz12 = class$7;
        if (clazz12 == null) {
            try {
                clazz12 = class$7 = Class.forName("org.eclipse.core.resources.IMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iAdapterManager.registerAdapters((IAdapterFactory)standardPropertiesAdapterFactory, (Class)clazz12);
    }

    private static boolean isIgnoredStatus(IStatus iStatus, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        if (iStatus instanceof ModelStatus) {
            ModelStatus modelStatus = (ModelStatus)iStatus;
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (modelStatus.getModelProviderId().equals(string)) {
                    return true;
                }
                IModelProviderDescriptor iModelProviderDescriptor = ModelProvider.getModelProviderDescriptor((String)string);
                String[] stringArray2 = iModelProviderDescriptor.getExtendedModels();
                if (IDE.isIgnoredStatus(iStatus, stringArray2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static IEditorReference[] openEditors(IWorkbenchPage iWorkbenchPage, IFile[] iFileArray) throws MultiPartInitException {
        if (iWorkbenchPage == null || iFileArray == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = new String[iFileArray.length];
        IEditorInput[] iEditorInputArray = new IEditorInput[iFileArray.length];
        int n = 0;
        while (n < iFileArray.length) {
            iEditorInputArray[n] = new FileEditorInput(iFileArray[n]);
            try {
                stringArray[n] = IDE.getEditorDescriptor(iFileArray[n]).getId();
            }
            catch (PartInitException partInitException) {
                PartInitException[] partInitExceptionArray = new PartInitException[iFileArray.length];
                partInitExceptionArray[n] = partInitException;
                throw new MultiPartInitException(new IWorkbenchPartReference[iFileArray.length], partInitExceptionArray);
            }
            ++n;
        }
        return iWorkbenchPage.openEditors(iEditorInputArray, stringArray, 1);
    }

    public static interface Preferences {
        public static final String PROJECT_OPEN_NEW_PERSPECTIVE = "PROJECT_OPEN_NEW_PERSPECTIVE";
        public static final String SHOW_WORKSPACE_SELECTION_DIALOG = "SHOW_WORKSPACE_SELECTION_DIALOG";
        public static final String MAX_RECENT_WORKSPACES = "MAX_RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES = "RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES_PROTOCOL = "RECENT_WORKSPACES_PROTOCOL";
    }

    private static class SaveFilter
    implements ISaveableFilter {
        private final IResource[] roots;

        public SaveFilter(IResource[] iResourceArray) {
            this.roots = iResourceArray;
        }

        public boolean select(Saveable saveable, IWorkbenchPart[] iWorkbenchPartArray) {
            if (this.isDescendantOfRoots(saveable)) {
                return true;
            }
            int n = 0;
            while (n < iWorkbenchPartArray.length) {
                IEditorPart iEditorPart;
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartArray[n];
                if (iWorkbenchPart instanceof IEditorPart && this.isEditingDescendantOf(iEditorPart = (IEditorPart)iWorkbenchPart)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isDescendantOfRoots(Saveable saveable) {
            ResourceMapping resourceMapping = ResourceUtil.getResourceMapping(saveable);
            if (resourceMapping == null) {
                IFile iFile = ResourceUtil.getFile(saveable);
                if (iFile == null) return false;
                return this.isDescendantOfRoots((IResource)iFile);
            }
            try {
                ResourceTraversal[] resourceTraversalArray = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
                int n = 0;
                block2: while (true) {
                    if (n >= resourceTraversalArray.length) {
                        return false;
                    }
                    ResourceTraversal resourceTraversal = resourceTraversalArray[n];
                    IResource[] iResourceArray = resourceTraversal.getResources();
                    int n2 = 0;
                    while (true) {
                        if (n2 >= iResourceArray.length) {
                            ++n;
                            continue block2;
                        }
                        IResource iResource = iResourceArray[n2];
                        if (this.isDescendantOfRoots(iResource)) {
                            return true;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (CoreException coreException) {
                IDEWorkbenchPlugin.log(NLS.bind((String)"An internal error occurred while determining the resources for {0}", (Object)saveable.getName()), coreException);
                return false;
            }
        }

        private boolean isDescendantOfRoots(IResource iResource) {
            int n = 0;
            while (n < this.roots.length) {
                IResource iResource2 = this.roots[n];
                if (iResource2.getFullPath().isPrefixOf(iResource.getFullPath())) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private boolean isEditingDescendantOf(IEditorPart iEditorPart) {
            IFile iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
            if (iFile != null) {
                return this.isDescendantOfRoots((IResource)iFile);
            }
            return false;
        }
    }

    public static interface SharedImages {
        public static final String IMG_OBJ_PROJECT = "IMG_OBJ_PROJECT";
        public static final String IMG_OBJ_PROJECT_CLOSED = "IMG_OBJ_PROJECT_CLOSED";
        public static final String IMG_OPEN_MARKER = "IMG_OPEN_MARKER";
        public static final String IMG_OBJS_TASK_TSK = "IMG_OBJS_TASK_TSK";
        public static final String IMG_OBJS_BKMRK_TSK = "IMG_OBJS_BKMRK_TSK";
    }
}

