/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class IDEEncoding {
    private static String IDE_ENCODINGS_PREFERENCE = "IDE_ENCODINGS_PREFERENCE";
    private static String PREFERENCE_SEPARATOR = "'";
    public static String BOM_UTF_8 = "UTF-8 (BOM)";
    public static String BOM_UTF_16BE = "UTF-16 Big-Endian (BOM)";
    public static String BOM_UTF_16LE = "UTF-16 Little-Endian (BOM)";

    private IDEEncoding() {
    }

    public static List getIDEEncodings() {
        List list = IDEEncoding.getIDEEncodingsPreference();
        list.addAll(WorkbenchEncoding.getDefinedEncodings());
        String string = IDEEncoding.getResourceEncoding();
        if (string != null && !list.contains(string)) {
            list.add(string);
        }
        Collections.sort(list);
        return list;
    }

    public static String getResourceEncoding() {
        String string = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    public static void addIDEEncoding(String string) {
        if (WorkbenchEncoding.getDefinedEncodings().contains(string)) {
            return;
        }
        IDEEncoding.writeEncodingsPreference(string, IDEEncoding.getIDEEncodingsPreference());
    }

    private static void writeEncodingsPreference(String string, Collection collection) {
        boolean bl = string != null;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            stringBuffer.append(string2);
            stringBuffer.append(PREFERENCE_SEPARATOR);
            if (!bl || !string2.equals(string)) continue;
            bl = false;
        }
        if (bl) {
            stringBuffer.append(string);
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(IDE_ENCODINGS_PREFERENCE, stringBuffer.toString());
    }

    private static List getIDEEncodingsPreference() {
        boolean bl = false;
        String string = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(IDE_ENCODINGS_PREFERENCE);
        if (string == null || string.length() == 0) {
            return new ArrayList();
        }
        String[] stringArray = string.split(PREFERENCE_SEPARATOR);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            boolean bl2;
            String string2 = stringArray[n];
            try {
                bl2 = Charset.isSupported(string2);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                bl2 = false;
            }
            if (bl2) {
                arrayList.add(string2);
            } else {
                WorkbenchPlugin.log((String)NLS.bind((String)IDEWorkbenchMessages.WorkbenchEncoding_invalidCharset, (Object)string2));
                bl = true;
            }
            ++n;
        }
        if (bl) {
            IDEEncoding.writeEncodingsPreference(null, arrayList);
        }
        return arrayList;
    }

    public static void clearUserEncodings() {
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setToDefault(IDE_ENCODINGS_PREFERENCE);
    }

    public static String getByteOrderMarkLabel(IContentDescription iContentDescription) {
        if (iContentDescription == null) {
            return null;
        }
        byte[] byArray = (byte[])iContentDescription.getProperty(IContentDescription.BYTE_ORDER_MARK);
        if (byArray == null) {
            return null;
        }
        if (byArray == IContentDescription.BOM_UTF_8) {
            return BOM_UTF_8;
        }
        if (byArray == IContentDescription.BOM_UTF_16BE) {
            return BOM_UTF_16BE;
        }
        if (byArray == IContentDescription.BOM_UTF_16LE) {
            return BOM_UTF_16LE;
        }
        return null;
    }
}

