/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public abstract class AbstractEncodingFieldEditor
extends FieldEditor {
    private Composite container;
    private Button defaultEncodingButton;
    private String defaultEnc;
    private Button otherEncodingButton;
    private Combo encodingCombo;
    private boolean isValid = true;
    private String oldSelectedEncoding;
    private String groupTitle = IDEWorkbenchMessages.WorkbenchPreference_encoding;

    protected AbstractEncodingFieldEditor() {
    }

    protected AbstractEncodingFieldEditor(String string, String string2, Composite composite) {
        super(string, string2, composite);
    }

    protected AbstractEncodingFieldEditor(String string, String string2, String string3, Composite composite) {
        this.init(string, string2);
        this.groupTitle = string3;
        this.createControl(composite);
    }

    protected void adjustForNumColumns(int n) {
        ((GridData)this.getContainer().getLayoutData()).horizontalSpan = n;
    }

    protected void doFillIntoGrid(Composite composite, int n) {
        this.container = this.createEncodingGroup(composite, n);
    }

    protected void doLoad() {
        if (this.encodingCombo != null) {
            List list = IDEEncoding.getIDEEncodings();
            String string = this.getStoredValue();
            this.populateEncodingsCombo(list, string);
            this.updateEncodingState(string == null);
        }
    }

    protected abstract String getStoredValue();

    protected void doLoadDefault() {
        this.updateEncodingState(true);
    }

    public int getNumberOfControls() {
        return 1;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.updateValidState();
    }

    public void setPreferenceStore(IPreferenceStore iPreferenceStore) {
        super.setPreferenceStore(iPreferenceStore);
        this.defaultEnc = iPreferenceStore.getDefaultString(this.getPreferenceName());
        this.updateDefaultEncoding();
    }

    private void updateDefaultEncoding() {
        this.defaultEncodingButton.setText(this.defaultButtonText());
    }

    private Composite getContainer() {
        return this.container;
    }

    protected Composite createEncodingGroup(Composite composite, int n) {
        Group group;
        Composite composite2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        if (this.groupTitle == null) {
            composite2 = new Composite(composite, 0);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
        } else {
            group = new Group(composite, 0);
            group.setText(this.groupTitle);
            composite2 = group;
        }
        group = new GridData(768);
        composite2.setLayoutData((Object)group);
        composite2.setLayout((Layout)gridLayout);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractEncodingFieldEditor.this.updateEncodingState(AbstractEncodingFieldEditor.this.defaultEncodingButton.getSelection());
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        };
        this.defaultEncodingButton = new Button(composite2, 16);
        this.defaultEnc = this.findDefaultEncoding();
        this.defaultEncodingButton.setText(this.defaultButtonText());
        group = new GridData();
        group.horizontalSpan = 2;
        this.defaultEncodingButton.setLayoutData((Object)group);
        this.defaultEncodingButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.otherEncodingButton = new Button(composite2, 16);
        this.otherEncodingButton.setText(IDEWorkbenchMessages.WorkbenchPreference_otherEncoding);
        this.otherEncodingButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.encodingCombo = new Combo(composite2, 0);
        group = new GridData();
        this.encodingCombo.setLayoutData((Object)group);
        this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        });
        this.encodingCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                AbstractEncodingFieldEditor.this.updateValidState();
            }
        });
        return composite2;
    }

    public void setEnabled(boolean bl, Composite composite) {
        if (this.container != null) {
            this.container.setEnabled(bl);
        }
        if (this.defaultEncodingButton != null) {
            this.defaultEncodingButton.setEnabled(bl);
        }
        if (this.otherEncodingButton != null) {
            this.otherEncodingButton.setEnabled(bl);
        }
        if (this.encodingCombo != null) {
            this.encodingCombo.setEnabled(bl && this.otherEncodingButton.getSelection());
        }
    }

    protected String findDefaultEncoding() {
        return WorkbenchEncoding.getWorkbenchDefaultEncoding();
    }

    protected String defaultButtonText() {
        return NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_defaultEncoding, (Object)this.defaultEnc);
    }

    private void populateEncodingsCombo(List list, String string) {
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        this.encodingCombo.setItems(stringArray);
        if (string == null) {
            this.encodingCombo.setText(this.getDefaultEnc());
        } else {
            this.encodingCombo.setText(string);
        }
    }

    private void updateEncodingState(boolean bl) {
        this.defaultEncodingButton.setSelection(bl);
        this.otherEncodingButton.setSelection(!bl);
        if (bl) {
            this.encodingCombo.setText(this.getDefaultEnc());
        }
        this.encodingCombo.setEnabled(!bl);
        this.setPresentsDefaultValue(bl);
        this.updateValidState();
    }

    private void updateValidState() {
        boolean bl = this.isEncodingValid();
        if (bl != this.isValid) {
            this.isValid = bl;
            if (this.isValid) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage(IDEWorkbenchMessages.WorkbenchPreference_unsupportedEncoding);
            }
            this.fireStateChanged("field_editor_is_valid", !this.isValid, this.isValid);
        }
        String string = this.getSelectedEncoding();
        if (this.isValid && !string.equals(this.oldSelectedEncoding)) {
            this.fireValueChanged("field_editor_value", this.oldSelectedEncoding, string);
            this.oldSelectedEncoding = string;
        }
    }

    protected String getSelectedEncoding() {
        if (this.defaultEncodingButton.getSelection()) {
            return this.defaultEnc;
        }
        return this.encodingCombo.getText();
    }

    private boolean isEncodingValid() {
        return this.defaultEncodingButton.getSelection() || this.isValidEncoding(this.encodingCombo.getText());
    }

    private boolean isValidEncoding(String string) {
        try {
            return Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            return false;
        }
    }

    protected String getDefaultEnc() {
        return this.defaultEnc;
    }

    protected boolean hasSameEncoding(String string) {
        String string2 = this.getStoredValue();
        if (string == null) {
            return string2 == null || string2.length() == 0;
        }
        return string.equals(string2);
    }

    boolean isDefaultSelected() {
        return this.defaultEncodingButton.getSelection();
    }

    public void setGroupTitle(String string) {
        this.groupTitle = string;
    }
}

