/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.dialogs.PathVariableEditDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ImportTypeDialog
extends MessageDialog
implements SelectionListener {
    public static final String AUTOMATIC = "PROJECT_LOC";
    public static final String ABSOLUTE_PATH = "default";
    public static final int IMPORT_COPY = 1;
    public static final int IMPORT_GROUPS_AND_LINKS = 2;
    public static final int IMPORT_LINK = 4;
    public static final int IMPORT_MOVE = 8;
    public static final int IMPORT_NONE = 0;
    private int operationMask;
    private int currentSelection;
    private Button copyButton = null;
    private Button shadowCopyButton = null;
    private Button linkButton = null;
    private Button moveButton = null;
    private Combo variableCombo = null;
    private Button alwaysPerformThisOperation = null;
    private Label variableLabel = null;
    private String variable = "default";
    private IProject receivingProject = null;

    public ImportTypeDialog(Shell shell, int n) {
        super(shell, IDEWorkbenchMessages.ImportTypeDialog_title, null, IDEWorkbenchMessages.ImportTypeDialog_question, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.operationMask = n;
        this.currentSelection = 0;
        String string = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE");
        if (string.length() > 0) {
            this.currentSelection = Integer.parseInt(string);
        }
        this.currentSelection &= n;
        if (this.currentSelection == 0) {
            this.currentSelection = (n & 1) != 0 ? 1 : 8;
        }
    }

    private String readContextPreference(String string) {
        String string2 = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(string);
        String[] stringArray = string2.split(":");
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = stringArray[n].split(",");
            if (stringArray2.length == 2 && stringArray2[0].equals(Integer.toString(this.operationMask))) {
                return stringArray2[1];
            }
            ++n;
        }
        return "";
    }

    private void writeContextPreference(String string, String string2) {
        String string3 = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(string);
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string3.split(":");
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2;
            if (n > 0) {
                stringBuffer.append(":");
            }
            if ((stringArray2 = stringArray[n].split(",")).length == 2) {
                if (stringArray2[0].equals(Integer.toString(this.operationMask))) {
                    stringBuffer.append(String.valueOf(stringArray2[0]) + "," + string2);
                    bl = true;
                } else {
                    stringBuffer.append(stringArray[n]);
                }
            }
            ++n;
        }
        if (!bl) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(String.valueOf(Integer.toString(this.operationMask)) + "," + string2);
        }
        String string4 = stringBuffer.toString();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(string, string4);
    }

    public String getVariable() {
        if (this.variable == ABSOLUTE_PATH) {
            return null;
        }
        return this.variable;
    }

    public int getSelection() {
        return this.currentSelection;
    }

    public int open() {
        String string = this.readContextPreference("IMPORT_FILES_AND_FOLDERS_SHOW_DIALOG");
        if (string.length() == 0 || !Boolean.valueOf(string).booleanValue()) {
            return super.open();
        }
        return 0;
    }

    protected Control createCustomArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 9;
        gridLayout.marginLeft = 32;
        composite2.setLayout((Layout)gridLayout);
        if ((this.operationMask & 1) != 0) {
            this.copyButton = new Button(composite2, 16);
            this.copyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_copyFilesAndDirectories);
            gridData = new GridData(768);
            this.copyButton.setLayoutData((Object)gridData);
            this.copyButton.setData((Object)new Integer(1));
            this.copyButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 8) != 0) {
            this.moveButton = new Button(composite2, 16);
            this.moveButton.setText(IDEWorkbenchMessages.ImportTypeDialog_moveFilesAndDirectories);
            gridData = new GridData(768);
            this.moveButton.setLayoutData((Object)gridData);
            this.moveButton.setData((Object)new Integer(8));
            this.moveButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 2) != 0) {
            this.shadowCopyButton = new Button(composite2, 16);
            this.shadowCopyButton.setText(IDEWorkbenchMessages.ImportTypeDialog_recreateFilesAndDirectories);
            gridData = new GridData(768);
            this.shadowCopyButton.setLayoutData((Object)gridData);
            this.shadowCopyButton.setData((Object)new Integer(2));
            this.shadowCopyButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 4) != 0) {
            this.linkButton = new Button(composite2, 16);
            this.linkButton.setText(IDEWorkbenchMessages.ImportTypeDialog_createLinks);
            gridData = new GridData(768);
            this.linkButton.setLayoutData((Object)gridData);
            this.linkButton.setData((Object)new Integer(4));
            this.linkButton.addSelectionListener((SelectionListener)this);
        }
        if ((this.operationMask & 6) != 0) {
            Composite composite3 = new Composite(composite2, 0);
            gridData = new GridData(4, 4, true, true);
            composite3.setLayoutData((Object)gridData);
            gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            gridLayout.verticalSpacing = 9;
            composite3.setLayout((Layout)gridLayout);
            this.variableLabel = new Label(composite3, 0);
            this.variableLabel.setText(IDEWorkbenchMessages.ImportTypeDialog_importElementsAs);
            gridData = new GridData(32);
            this.variableLabel.setLayoutData((Object)gridData);
            this.variableCombo = new Combo(composite3, 12);
            gridData = new GridData(32);
            this.variableCombo.setLayoutData((Object)gridData);
            this.variableCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (ImportTypeDialog.this.variableCombo.getSelectionIndex() == ImportTypeDialog.this.variableCombo.getItemCount() - 1) {
                        ImportTypeDialog.this.editVariables();
                    } else {
                        ImportTypeDialog.this.selectVariable(ImportTypeDialog.this.variableCombo.getItem(ImportTypeDialog.this.variableCombo.getSelectionIndex()));
                    }
                }
            });
            this.setupVariableContent();
            this.selectVariable(this.readContextPreference("IMPORT_FILES_AND_FOLDERS_VARIABLE"));
        }
        this.alwaysPerformThisOperation = new Button(composite2, 32);
        this.alwaysPerformThisOperation.setText(IDEWorkbenchMessages.ImportTypeDialog_alwaysPerformThisOperation);
        gridData = new GridData(32);
        this.alwaysPerformThisOperation.setLayoutData((Object)gridData);
        this.refreshSelection();
        return composite2;
    }

    private void editVariables() {
        String[] stringArray;
        PathVariableEditDialog pathVariableEditDialog = new PathVariableEditDialog(this.getShell());
        pathVariableEditDialog.setProject(this.receivingProject);
        if (pathVariableEditDialog.open() == 0 && (stringArray = (String[])pathVariableEditDialog.getResult()) != null && stringArray.length >= 1) {
            this.variable = stringArray[0];
        }
        this.setupVariableContent();
        this.selectVariable(this.variable);
    }

    private void selectVariable(String string) {
        if (string.equals(IDEWorkbenchMessages.ImportTypeDialog_automatic) || string.equals(AUTOMATIC)) {
            this.variableCombo.select(0);
            this.variable = string;
        } else if (string.equals(IDEWorkbenchMessages.ImportTypeDialog_absolutePath) || string.equals(ABSOLUTE_PATH)) {
            this.variableCombo.select(1);
            this.variable = string;
        } else {
            String[] stringArray = this.variableCombo.getItems();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    this.variableCombo.select(n);
                    this.variable = n == 0 ? AUTOMATIC : (n == 1 ? ABSOLUTE_PATH : stringArray[n]);
                    return;
                }
                ++n;
            }
            this.variableCombo.select(0);
            this.variable = AUTOMATIC;
        }
    }

    private void setupVariableContent() {
        IPathVariableManager iPathVariableManager = this.receivingProject != null ? this.receivingProject.getPathVariableManager() : ResourcesPlugin.getWorkspace().getPathVariableManager();
        String[] stringArray = iPathVariableManager.getPathVariableNames();
        String[] stringArray2 = new String[stringArray.length + 3];
        stringArray2[0] = IDEWorkbenchMessages.ImportTypeDialog_automatic;
        stringArray2[1] = IDEWorkbenchMessages.ImportTypeDialog_absolutePath;
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 2] = stringArray[n];
            ++n;
        }
        stringArray2[stringArray2.length - 1] = IDEWorkbenchMessages.ImportTypeDialog_editVariables;
        this.variableCombo.setItems(stringArray2);
        super.getShell().layout(true);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_TYPE", Integer.toString(this.currentSelection));
            String string = this.currentSelection == 0 ? AUTOMATIC : (this.currentSelection == 1 ? ABSOLUTE_PATH : this.variable);
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_VARIABLE", string);
            this.writeContextPreference("IMPORT_FILES_AND_FOLDERS_SHOW_DIALOG", Boolean.toString(this.alwaysPerformThisOperation.getSelection()));
        }
        super.buttonPressed(n);
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        this.currentSelection = (Integer)selectionEvent.widget.getData();
        this.refreshSelection();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.currentSelection = (Integer)selectionEvent.widget.getData();
        this.refreshSelection();
    }

    private void refreshSelection() {
        if (this.copyButton != null) {
            this.copyButton.setSelection(this.currentSelection == 1);
        }
        if (this.shadowCopyButton != null) {
            this.shadowCopyButton.setSelection(this.currentSelection == 2);
        }
        if (this.linkButton != null) {
            this.linkButton.setSelection(this.currentSelection == 4);
        }
        if (this.moveButton != null) {
            this.moveButton.setSelection(this.currentSelection == 8);
        }
        if (this.variableCombo != null) {
            this.variableCombo.setEnabled((this.currentSelection & 6) != 0);
        }
        if (this.variableLabel != null) {
            this.variableLabel.setEnabled((this.currentSelection & 6) != 0);
        }
    }

    public void setProject(IProject iProject) {
        this.receivingProject = iProject;
    }
}

