/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;

public class PathVariableEditDialog
extends SelectionDialog {
    private PathVariablesGroup pathVariablesGroup;

    public PathVariableEditDialog(Shell shell) {
        super(shell);
        this.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_title);
        this.pathVariablesGroup = new PathVariablesGroup(false, 2, null);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setProject(IProject iProject) {
        this.pathVariablesGroup.setProject(iProject);
    }

    protected void buttonPressed(int n) {
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.pathVariablesGroup.createContents(composite2);
        return composite2;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        try {
            if (this.pathVariablesGroup.performOk()) {
                PathVariablesGroup.PathVariableElement[] pathVariableElementArray = this.pathVariablesGroup.getSelection();
                Object[] objectArray = new String[pathVariableElementArray.length];
                int n = 0;
                while (n < pathVariableElementArray.length) {
                    objectArray[n] = pathVariableElementArray[n].name;
                    ++n;
                }
                this.setSelectionResult(objectArray);
            } else {
                this.setSelectionResult(null);
            }
            super.okPressed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

