/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectVariableProviderManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.FileFolderSelectionDialog;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.PathVariablesGroup;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public final class PathVariableSelectionDialog
extends SelectionDialog {
    private static final int EXTEND_ID = 1025;
    private PathVariablesGroup pathVariablesGroup;
    private IProject currentProject = null;
    private int variableType;

    public PathVariableSelectionDialog(Shell shell, int n) {
        super(shell);
        this.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_title);
        this.variableType = n;
        this.pathVariablesGroup = new PathVariablesGroup(false, n, new Listener(){

            public void handleEvent(Event event) {
                PathVariableSelectionDialog.this.updateExtendButtonState();
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int n) {
        if (n == 1025) {
            PathVariablesGroup.PathVariableElement pathVariableElement = this.pathVariablesGroup.getSelection()[0];
            ProjectVariableProviderManager.Descriptor descriptor = ProjectVariableProviderManager.getDefault().findDescriptor(pathVariableElement.name);
            if (descriptor != null && descriptor.getExtensions(pathVariableElement.name, this.currentProject) != null) {
                EnvSelectionDialog envSelectionDialog = new EnvSelectionDialog(this.getShell(), descriptor.getExtensions(pathVariableElement.name, this.currentProject));
                envSelectionDialog.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_title);
                envSelectionDialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_description, (Object)pathVariableElement.name));
                if (envSelectionDialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                    this.setSelectionResult(new String[]{"${" + pathVariableElement.name + "-" + envSelectionDialog.getResult()[0] + "}"});
                    super.okPressed();
                }
            } else {
                FileFolderSelectionDialog fileFolderSelectionDialog = new FileFolderSelectionDialog(this.getShell(), false, this.variableType);
                fileFolderSelectionDialog.setTitle(IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_title);
                fileFolderSelectionDialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.PathVariableSelectionDialog_ExtensionDialog_description, (Object)pathVariableElement.name));
                IPath iPath = pathVariableElement.path;
                if (this.currentProject != null) {
                    iPath = this.currentProject.getPathVariableManager().resolvePath(iPath);
                }
                try {
                    fileFolderSelectionDialog.setInput(EFS.getStore((URI)URIUtil.toURI((IPath)iPath)));
                }
                catch (CoreException coreException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)coreException.getStatus());
                }
                if (fileFolderSelectionDialog.open() == 0 && this.pathVariablesGroup.performOk()) {
                    this.setExtensionResult(pathVariableElement, (IFileStore)fileFolderSelectionDialog.getResult()[0]);
                    super.okPressed();
                }
            }
        } else {
            super.buttonPressed(n);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.ide.path_variable_selection_dialog");
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1025, IDEWorkbenchMessages.PathVariableSelectionDialog_extendButton, false);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateExtendButtonState();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.pathVariablesGroup.createContents(composite2);
        return composite2;
    }

    public boolean close() {
        this.pathVariablesGroup.dispose();
        return super.close();
    }

    protected void okPressed() {
        if (this.pathVariablesGroup.performOk()) {
            PathVariablesGroup.PathVariableElement[] pathVariableElementArray = this.pathVariablesGroup.getSelection();
            Object[] objectArray = new String[pathVariableElementArray.length];
            int n = 0;
            while (n < pathVariableElementArray.length) {
                objectArray[n] = pathVariableElementArray[n].name;
                ++n;
            }
            this.setSelectionResult(objectArray);
        } else {
            this.setSelectionResult(null);
        }
        super.okPressed();
    }

    private void setExtensionResult(PathVariablesGroup.PathVariableElement pathVariableElement, IFileStore iFileStore) {
        Path path = new Path(iFileStore.toString());
        IPath iPath = pathVariableElement.path;
        if (this.currentProject != null) {
            iPath = this.currentProject.getPathVariableManager().resolvePath(iPath);
        }
        int n = path.matchingFirstSegments(iPath);
        Path path2 = new Path(pathVariableElement.name);
        path = path.removeFirstSegments(n);
        path2 = path2.append((IPath)path);
        this.setSelectionResult(new String[]{path2.toPortableString()});
    }

    private void updateExtendButtonState() {
        PathVariablesGroup.PathVariableElement[] pathVariableElementArray = this.pathVariablesGroup.getSelection();
        Button button = this.getButton(1025);
        if (button == null) {
            return;
        }
        if (pathVariableElementArray.length == 1) {
            IPath iPath = pathVariableElementArray[0].path;
            if (this.currentProject != null) {
                iPath = this.currentProject.getPathVariableManager().resolvePath(iPath);
            }
            IFileInfo iFileInfo = IDEResourceInfoUtils.getFileInfo(iPath);
            ProjectVariableProviderManager.Descriptor descriptor = ProjectVariableProviderManager.getDefault().findDescriptor(pathVariableElementArray[0].name);
            if (iFileInfo.exists() && iFileInfo.isDirectory() || descriptor != null && descriptor.getExtensions(pathVariableElementArray[0].name, this.currentProject) != null) {
                button.setEnabled(true);
            } else {
                button.setEnabled(false);
            }
        } else {
            button.setEnabled(false);
        }
    }

    public void setProject(IProject iProject) {
        this.currentProject = iProject;
        this.pathVariablesGroup.setProject(iProject);
    }

    class EnvSelectionDialog
    extends SelectionDialog {
        ListViewer viewer;
        Object[] extensions;

        protected EnvSelectionDialog(Shell shell, Object[] objectArray) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.extensions = objectArray;
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            this.createMessageArea(composite2);
            this.viewer = new ListViewer(composite2, 2820);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(10);
            gridData.widthHint = this.convertWidthInCharsToPixels(30);
            this.viewer.getList().setLayoutData((Object)gridData);
            this.viewer.getList().setFont(composite.getFont());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public String getText(Object object) {
                    if (object instanceof String) {
                        return (String)object;
                    }
                    return null;
                }
            });
            SimpleListContentProvider simpleListContentProvider = new SimpleListContentProvider();
            simpleListContentProvider.setElements(this.extensions);
            this.viewer.setContentProvider((IContentProvider)simpleListContentProvider);
            this.viewer.setInput(new Object());
            this.viewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    this.this$1.getOkButton().setEnabled(!selectionChangedEvent.getSelection().isEmpty());
                }
            });
            this.viewer.addDoubleClickListener(new IDoubleClickListener(this){
                final /* synthetic */ EnvSelectionDialog this$1;
                {
                    this.this$1 = envSelectionDialog;
                }

                public void doubleClick(DoubleClickEvent doubleClickEvent) {
                    this.this$1.okPressed();
                }
            });
            return composite2;
        }

        protected Control createButtonBar(Composite composite) {
            Control control = super.createButtonBar(composite);
            this.getOkButton().setEnabled(false);
            return control;
        }

        protected void okPressed() {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.viewer.getSelection();
            this.setResult(iStructuredSelection.toList());
            super.okPressed();
        }
    }
}

