/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class ResourceEncodingFieldEditor
extends AbstractEncodingFieldEditor {
    private IResource resource;
    private Composite group;

    public ResourceEncodingFieldEditor(String string, Composite composite, IResource iResource) {
        this.setLabelAndResource(string, iResource);
        this.createControl(composite);
    }

    public ResourceEncodingFieldEditor(String string, Composite composite, IResource iResource, String string2) {
        this.setLabelAndResource(string, iResource);
        this.setGroupTitle(string2);
        this.createControl(composite);
    }

    private void setLabelAndResource(String string, IResource iResource) {
        Assert.isTrue((iResource instanceof IContainer || iResource instanceof IFile ? 1 : 0) != 0);
        this.setLabelText(string);
        this.resource = iResource;
    }

    protected String getStoredValue() {
        try {
            if (this.resource instanceof IContainer) {
                return ((IContainer)this.resource).getDefaultCharset(false);
            }
            return ((IFile)this.resource).getCharset(false);
        }
        catch (CoreException coreException) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorLoadingMessage, coreException.getStatus());
            return WorkbenchEncoding.getWorkbenchDefaultEncoding();
        }
    }

    protected void doStore() {
        Object object;
        String string;
        String string2 = this.getSelectedEncoding();
        if (this.isDefaultSelected()) {
            string2 = null;
        }
        if (this.hasSameEncoding(string2)) {
            return;
        }
        String string3 = this.getCharsetFromDescription();
        if (string3 != null && !string3.equals(string2) && string2 != null) {
            MessageDialog messageDialog;
            string = null;
            object = this.getPage();
            if (object != null) {
                string = object.getShell();
            }
            if ((messageDialog = new MessageDialog((Shell)string, IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictTitle, null, NLS.bind((String)IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictMessage, (Object)string2, (Object)string3), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0)).open() > 0) {
                return;
            }
        }
        IDEEncoding.addIDEEncoding(string2);
        string = string2;
        object = new Job(IDEWorkbenchMessages.IDEEncoding_EncodingJob){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    if (ResourceEncodingFieldEditor.this.resource instanceof IContainer) {
                        ((IContainer)ResourceEncodingFieldEditor.this.resource).setDefaultCharset(string, iProgressMonitor);
                    } else {
                        ((IFile)ResourceEncodingFieldEditor.this.resource).setCharset(string, iProgressMonitor);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException coreException) {
                    IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorStoringMessage, coreException.getStatus());
                    return coreException.getStatus();
                }
            }
        };
        object.schedule();
    }

    public void store() {
        this.doStore();
    }

    public void load() {
        this.setPresentsDefaultValue(false);
        this.doLoad();
    }

    public void loadDefault() {
        this.setPresentsDefaultValue(true);
        this.doLoadDefault();
        this.refreshValidState();
    }

    protected String findDefaultEncoding() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.findDefaultEncoding();
        }
        String string = this.getCharsetFromDescription();
        string = this.getCharsetFromDescription();
        if (string != null && string.length() > 0) {
            return string;
        }
        try {
            string = this.resource.getParent().getDefaultCharset(true);
        }
        catch (CoreException coreException) {}
        if (string != null && string.length() > 0) {
            return string;
        }
        return super.findDefaultEncoding();
    }

    private String getCharsetFromDescription() {
        IContentDescription iContentDescription = this.getContentDescription();
        if (iContentDescription != null) {
            return iContentDescription.getCharset();
        }
        return null;
    }

    protected String defaultButtonText() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.defaultButtonText();
        }
        if (this.resource instanceof IFile) {
            try {
                IContentDescription iContentDescription = ((IFile)this.resource).getContentDescription();
                if (iContentDescription == null || iContentDescription.getCharset() == null) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContainerEncodingFormat, (Object)this.getDefaultEnc());
                }
                return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContentEncodingFormat, (Object)this.getDefaultEnc());
            }
            catch (CoreException coreException) {}
        }
        return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_containerEncodingFormat, (Object)this.getDefaultEnc());
    }

    protected Composite createEncodingGroup(Composite composite, int n) {
        this.group = super.createEncodingGroup(composite, n);
        String string = IDEEncoding.getByteOrderMarkLabel(this.getContentDescription());
        if (string != null) {
            Label label = new Label(this.group, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_encoding_encodingMessage, (Object)string));
            GridData gridData = new GridData();
            gridData.horizontalSpan = n + 1;
            label.setLayoutData((Object)gridData);
        }
        return this.group;
    }

    private IContentDescription getContentDescription() {
        try {
            if (this.resource instanceof IFile) {
                return ((IFile)this.resource).getContentDescription();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void setEnabled(boolean bl, Composite composite) {
        super.setEnabled(bl, composite);
        this.group.setEnabled(bl);
        Control[] controlArray = this.group.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }
}

