/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractCopyOrMoveResourcesOperation
extends AbstractResourcesOperation {
    protected IPath[] destinationPaths = null;
    protected IPath destination = null;
    protected boolean fCreateGroups = false;
    protected boolean fCreateLinks = false;
    protected String fRelativeToVariable = null;

    AbstractCopyOrMoveResourcesOperation(IResource[] iResourceArray, IPath[] iPathArray, String string) {
        super(iResourceArray, string);
        if (this.resources == null || iPathArray == null) {
            throw new IllegalArgumentException("The resource and destination paths may not be null");
        }
        if (this.resources.length != iResourceArray.length) {
            throw new IllegalArgumentException("The resource list contained descendants that cannot be moved to separate destination paths");
        }
        if (this.resources.length != iPathArray.length) {
            throw new IllegalArgumentException("The resource and destination paths must be the same length");
        }
        int n = 0;
        while (n < this.resources.length) {
            if (this.resources[n] == null) {
                throw new IllegalArgumentException("The resources array may not contain null resources");
            }
            if (iPathArray[n] == null) {
                throw new IllegalArgumentException("The destination paths array may not contain null paths");
            }
            ++n;
        }
        this.destinationPaths = iPathArray;
    }

    AbstractCopyOrMoveResourcesOperation(IResource[] iResourceArray, IPath iPath, String string) {
        super(iResourceArray, string);
        this.destination = iPath;
    }

    AbstractCopyOrMoveResourcesOperation(IResource[] iResourceArray, String string) {
        super(iResourceArray, string);
    }

    protected IStatus computeMoveOrCopyStatus() {
        if (this.resources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        int n = 0;
        while (n < this.resources.length) {
            IResource iResource = this.resources[n];
            if (!iResource.exists()) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractCopyOrMoveResourcesOperation_ResourceDoesNotExist);
            }
            if (!this.isDestinationPathValid(iResource, n)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractCopyOrMoveResourcesOperation_SameNameOrLocation);
            }
            IStatus iStatus = this.getWorkspace().validateName(this.getProposedName(iResource, n), iResource.getType());
            if (iStatus.getSeverity() == 4) {
                this.markInvalid();
            }
            if (!iStatus.isOK()) {
                return iStatus;
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    protected IPath getDestinationPath(IResource iResource, int n) {
        if (this.destinationPaths != null) {
            return this.destinationPaths[n];
        }
        return this.destination.append(iResource.getName());
    }

    protected void appendDescriptiveText(StringBuffer stringBuffer) {
        super.appendDescriptiveText(stringBuffer);
        stringBuffer.append(" destination: ");
        stringBuffer.append(this.destination);
        stringBuffer.append(", destinationPaths: ");
        stringBuffer.append(this.destinationPaths);
        stringBuffer.append('\'');
    }

    protected boolean isDestinationPathValid(IResource iResource, int n) {
        return !iResource.getFullPath().equals((Object)this.getDestinationPath(iResource, n));
    }

    protected String getProposedName(IResource iResource, int n) {
        return this.getDestinationPath(iResource, n).lastSegment();
    }

    public IStatus computeExecutionStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeExecutionStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeMoveOrCopyStatus();
        }
        return iStatus;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeRedoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeMoveOrCopyStatus();
        }
        return iStatus;
    }

    public void setCreateGroups(boolean bl) {
        this.fCreateGroups = bl;
    }

    public void setCreateLinks(boolean bl) {
        this.fCreateLinks = bl;
    }

    public void setRelativeVariable(String string) {
        this.fRelativeToVariable = string;
    }
}

