/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;

abstract class AbstractCreateResourcesOperation
extends AbstractResourcesOperation {
    AbstractCreateResourcesOperation(ResourceDescription[] resourceDescriptionArray, String string) {
        super(resourceDescriptionArray, string);
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.recreate(iProgressMonitor, iAdaptable);
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.delete(iProgressMonitor, iAdaptable, false);
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        boolean bl = false;
        if (n == UNDO) {
            int n2 = 0;
            while (n2 < this.resources.length) {
                IResource iResource = this.resources[n2];
                iResourceChangeDescriptionFactory.delete(iResource);
                bl = true;
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[n3] != null) {
                    IResource iResource = this.resourceDescriptions[n3].createResourceHandle();
                    iResourceChangeDescriptionFactory.create(iResource);
                    bl = true;
                }
                ++n3;
            }
        }
        return bl;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        return super.computeCreateSchedulingRule();
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return super.computeDeleteSchedulingRule();
    }

    public IStatus computeExecutionStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeExecutionStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeCreateStatus(true);
        }
        return iStatus;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeDeleteStatus();
        }
        return iStatus;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeRedoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeCreateStatus(true);
        }
        return iStatus;
    }
}

