/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.MarkerDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractMarkersOperation
extends AbstractWorkspaceOperation {
    MarkerDescription[] markerDescriptions;
    IMarker[] markers;
    Map[] attributes;

    AbstractMarkersOperation(IMarker[] iMarkerArray, MarkerDescription[] markerDescriptionArray, Map map, String string) {
        super(string);
        this.markers = iMarkerArray;
        this.attributes = null;
        if (map != null && iMarkerArray != null) {
            if (iMarkerArray.length > 1) {
                this.attributes = new Map[iMarkerArray.length];
                int n = 0;
                while (n < iMarkerArray.length) {
                    HashMap hashMap = new HashMap();
                    hashMap.putAll(map);
                    this.attributes[n] = hashMap;
                    ++n;
                }
            } else {
                this.attributes = new Map[]{map};
            }
        }
        this.setMarkerDescriptions(markerDescriptionArray);
    }

    protected void deleteMarkers(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.markers == null || this.markers.length == 0) {
            iProgressMonitor.worked(n);
            return;
        }
        int n2 = n / this.markers.length;
        this.markerDescriptions = new MarkerDescription[this.markers.length];
        int n3 = 0;
        while (n3 < this.markers.length) {
            this.markerDescriptions[n3] = new MarkerDescription(this.markers[n3]);
            this.markers[n3].delete();
            iProgressMonitor.worked(n2);
            ++n3;
        }
        this.markers = new IMarker[0];
    }

    protected void createMarkers(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.markerDescriptions == null || this.markerDescriptions.length == 0) {
            iProgressMonitor.worked(n);
            return;
        }
        int n2 = n / this.markerDescriptions.length;
        this.markers = new IMarker[this.markerDescriptions.length];
        int n3 = 0;
        while (n3 < this.markerDescriptions.length) {
            this.markers[n3] = this.markerDescriptions[n3].createMarker();
            iProgressMonitor.worked(n2);
            ++n3;
        }
    }

    protected void updateMarkers(int n, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        if (this.attributes == null || this.markers == null || this.attributes.length != this.markers.length || this.markers.length == 0) {
            iProgressMonitor.worked(n);
            return;
        }
        int n2 = n / this.markers.length;
        int n3 = 0;
        while (n3 < this.markers.length) {
            Map map;
            if (bl) {
                map = this.markers[n3].getAttributes();
                int n4 = n2 / this.attributes[n3].size();
                HashMap hashMap = new HashMap();
                Iterator iterator = this.attributes[n3].keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Object v = this.attributes[n3].get(string);
                    this.markers[n3].setAttribute(string, v);
                    hashMap.put(string, map.get(string));
                    iProgressMonitor.worked(n4);
                }
                this.attributes[n3] = hashMap;
            } else {
                map = this.markers[n3].getAttributes();
                this.markers[n3].setAttributes(this.attributes[n3]);
                this.attributes[n3] = map;
            }
            ++n3;
        }
    }

    protected void setMarkerDescriptions(MarkerDescription[] markerDescriptionArray) {
        this.markerDescriptions = markerDescriptionArray;
        this.addUndoContexts();
        this.updateTargetResources();
    }

    private void updateTargetResources() {
        IResource[] iResourceArray = null;
        if (this.markers == null) {
            if (this.markerDescriptions != null) {
                iResourceArray = new IResource[this.markerDescriptions.length];
                int n = 0;
                while (n < this.markerDescriptions.length) {
                    iResourceArray[n] = this.markerDescriptions[n].getResource();
                    ++n;
                }
            }
        } else {
            iResourceArray = new IResource[this.markers.length];
            int n = 0;
            while (n < this.markers.length) {
                iResourceArray[n] = this.markers[n].getResource();
                ++n;
            }
        }
        this.setTargetResources(iResourceArray);
    }

    private void addUndoContexts() {
        int n;
        String[] stringArray = null;
        if (this.markers == null) {
            if (this.markerDescriptions != null) {
                stringArray = new String[this.markerDescriptions.length];
                n = 0;
                while (n < this.markerDescriptions.length) {
                    stringArray[n] = this.markerDescriptions[n].getType();
                    ++n;
                }
            }
        } else {
            stringArray = new String[this.markers.length];
            n = 0;
            while (n < this.markers.length) {
                try {
                    stringArray[n] = this.markers[n].getType();
                }
                catch (CoreException coreException) {}
                ++n;
            }
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null) {
                    if (stringArray[n].equals("org.eclipse.core.resources.bookmark")) {
                        this.addContext(WorkspaceUndoUtil.getBookmarksUndoContext());
                    } else if (stringArray[n].equals("org.eclipse.core.resources.taskmarker")) {
                        this.addContext(WorkspaceUndoUtil.getTasksUndoContext());
                    } else if (stringArray[n] != null) {
                        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
                    }
                }
                ++n;
            }
        }
    }

    public IMarker[] getMarkers() {
        return this.markers;
    }

    protected boolean markersExist() {
        if (this.markers == null || this.markers.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.markers.length) {
            if (!this.markers[n].exists()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected abstract IStatus getBasicUndoStatus();

    protected abstract IStatus getBasicRedoStatus();

    public IStatus computeExecutionStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = this.getBasicRedoStatus();
        if (iStatus.isOK()) {
            return super.computeExecutionStatus(iProgressMonitor);
        }
        if (iStatus.getSeverity() == 4) {
            this.markInvalid();
        }
        return iStatus;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = this.getBasicUndoStatus();
        if (iStatus.isOK()) {
            return super.computeUndoableStatus(iProgressMonitor);
        }
        if (iStatus.getSeverity() == 4) {
            this.markInvalid();
        }
        return iStatus;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = this.getBasicRedoStatus();
        if (iStatus.isOK()) {
            return super.computeRedoableStatus(iProgressMonitor);
        }
        if (iStatus.getSeverity() == 4) {
            this.markInvalid();
        }
        return iStatus;
    }

    protected IStatus getMarkerDeletionStatus() {
        if (this.markersExist()) {
            return Status.OK_STATUS;
        }
        return this.getErrorStatus(UndoMessages.MarkerOperation_MarkerDoesNotExist);
    }

    protected IStatus getMarkerCreationStatus() {
        if (!this.resourcesExist()) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_ResourceDoesNotExist);
        }
        if (this.markerDescriptions == null) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_NotEnoughInfo);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getMarkerUpdateStatus() {
        if (!this.markersExist()) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_MarkerDoesNotExist);
        }
        if (this.attributes == null) {
            return this.getErrorStatus(UndoMessages.MarkerOperation_NotEnoughInfo);
        }
        return Status.OK_STATUS;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.resources.length];
        int n = 0;
        while (n < this.resources.length) {
            iSchedulingRuleArray[n] = this.getWorkspaceRuleFactory().markerRule(this.resources[n]);
            ++n;
        }
        return MultiRule.combine((ISchedulingRule[])iSchedulingRuleArray);
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return this.getExecuteSchedulingRule();
    }

    protected void appendDescriptiveText(StringBuffer stringBuffer) {
        super.appendDescriptiveText(stringBuffer);
        stringBuffer.append(" markers: ");
        stringBuffer.append(this.markers);
        stringBuffer.append('\'');
        stringBuffer.append(" markerDescriptions: ");
        stringBuffer.append(this.markerDescriptions);
        stringBuffer.append('\'');
        stringBuffer.append(" attributes: ");
        stringBuffer.append(this.attributes);
        stringBuffer.append('\'');
    }
}

