/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.undo.AbstractWorkspaceOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

abstract class AbstractResourcesOperation
extends AbstractWorkspaceOperation {
    protected ResourceDescription[] resourceDescriptions;

    private static boolean isDescendantOf(IResource iResource, IResource iResource2) {
        return !iResource.equals((Object)iResource2) && iResource2.getFullPath().isPrefixOf(iResource.getFullPath());
    }

    AbstractResourcesOperation(IResource[] iResourceArray, String string) {
        super(string);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setTargetResources(iResourceArray);
    }

    AbstractResourcesOperation(ResourceDescription[] resourceDescriptionArray, String string) {
        super(string);
        this.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
        this.setResourceDescriptions(resourceDescriptionArray);
    }

    protected void delete(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl) throws CoreException {
        this.setResourceDescriptions(WorkspaceUndoUtil.delete(this.resources, iProgressMonitor, iAdaptable, bl));
        this.setTargetResources(new IResource[0]);
    }

    protected void recreate(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.setTargetResources(WorkspaceUndoUtil.recreate(this.resourceDescriptions, iProgressMonitor, iAdaptable));
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected IStatus computeCreateStatus(boolean bl) {
        if (this.resourceDescriptions == null || this.resourceDescriptions.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        int n = 0;
        while (n < this.resourceDescriptions.length) {
            if (this.resourceDescriptions[n] == null || !this.resourceDescriptions[n].isValid()) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_InvalidRestoreInfo);
            }
            if (!bl && this.resourceDescriptions[n].verifyExistence(false)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesAlreadyExist);
            }
            ++n;
        }
        return Status.OK_STATUS;
    }

    protected IStatus computeDeleteStatus() {
        if (this.resources == null || this.resources.length == 0) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (!this.resourcesExist()) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_ResourcesDoNotExist);
        }
        return this.checkReadOnlyResources(this.resources);
    }

    IStatus checkReadOnlyResources(IResource[] iResourceArray) {
        if (!this.quietCompute) {
            ReadOnlyStateChecker readOnlyStateChecker = new ReadOnlyStateChecker(this.getShell(null), IDEWorkbenchMessages.DeleteResourceAction_title1, IDEWorkbenchMessages.DeleteResourceAction_readOnlyQuestion);
            readOnlyStateChecker.setIgnoreLinkedResources(true);
            IResource[] iResourceArray2 = readOnlyStateChecker.checkReadOnlyResources(iResourceArray);
            if (iResourceArray2.length == 0) {
                return Status.CANCEL_STATUS;
            }
            this.setTargetResources(iResourceArray2);
        }
        return Status.OK_STATUS;
    }

    protected void setResourceDescriptions(ResourceDescription[] resourceDescriptionArray) {
        this.resourceDescriptions = resourceDescriptionArray == null ? new ResourceDescription[0] : resourceDescriptionArray;
    }

    protected void appendDescriptiveText(StringBuffer stringBuffer) {
        super.appendDescriptiveText(stringBuffer);
        stringBuffer.append(" resourceDescriptions: ");
        stringBuffer.append(this.resourceDescriptions);
        stringBuffer.append('\'');
    }

    protected ISchedulingRule computeCreateSchedulingRule() {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.resourceDescriptions.length * 3];
        int n = 0;
        while (n < this.resourceDescriptions.length) {
            if (this.resourceDescriptions[n] != null) {
                IResource iResource = this.resourceDescriptions[n].createResourceHandle();
                iSchedulingRuleArray[n * 3] = this.getWorkspaceRuleFactory().createRule(iResource);
                iSchedulingRuleArray[n * 3 + 1] = this.getWorkspaceRuleFactory().modifyRule(iResource);
                iSchedulingRuleArray[n * 3 + 2] = this.getWorkspaceRuleFactory().charsetRule(iResource);
            }
            ++n;
        }
        return MultiRule.combine((ISchedulingRule[])iSchedulingRuleArray);
    }

    protected ISchedulingRule computeDeleteSchedulingRule() {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[this.resources.length * 2];
        int n = 0;
        while (n < this.resources.length) {
            iSchedulingRuleArray[n * 2] = this.getWorkspaceRuleFactory().deleteRule(this.resources[n]);
            iSchedulingRuleArray[n * 2 + 1] = this.getWorkspaceRuleFactory().modifyRule(this.resources[n]);
            ++n;
        }
        return MultiRule.combine((ISchedulingRule[])iSchedulingRuleArray);
    }

    protected void setTargetResources(IResource[] iResourceArray) {
        int n;
        HashSet<IResource> hashSet = new HashSet<IResource>();
        int n2 = 0;
        while (n2 < iResourceArray.length) {
            IResource iResource = iResourceArray[n2];
            n = 0;
            while (n < iResourceArray.length) {
                IResource iResource2 = iResourceArray[n];
                if (AbstractResourcesOperation.isDescendantOf(iResource, iResource2) && !hashSet.contains(iResource)) {
                    hashSet.add(iResource);
                }
                ++n;
            }
            ++n2;
        }
        IResource[] iResourceArray2 = new IResource[iResourceArray.length - hashSet.size()];
        int n3 = 0;
        n = 0;
        while (n < iResourceArray.length) {
            if (!hashSet.contains(iResourceArray[n])) {
                iResourceArray2[n3] = iResourceArray[n];
                ++n3;
            }
            ++n;
        }
        super.setTargetResources(iResourceArray2);
    }
}

