/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class AbstractWorkspaceOperation
extends AbstractOperation
implements IAdvancedUndoableOperation,
IAdvancedUndoableOperation2 {
    private static String ELLIPSIS = "...";
    protected static int EXECUTE = 1;
    protected static int UNDO = 2;
    protected static int REDO = 3;
    protected IResource[] resources;
    private boolean isValid = true;
    protected boolean quietCompute = false;
    String[] modelProviderIds;
    static /* synthetic */ Class class$0;

    AbstractWorkspaceOperation(String string) {
        super(Action.removeMnemonics((String)string));
        String string2 = this.getLabel();
        if (string2.endsWith(ELLIPSIS)) {
            this.setLabel(string2.substring(0, string2.length() - ELLIPSIS.length()));
        }
    }

    public void setModelProviderIds(String[] stringArray) {
        this.modelProviderIds = stringArray;
    }

    protected void setTargetResources(IResource[] iResourceArray) {
        this.resources = iResourceArray;
    }

    protected IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected IResourceRuleFactory getWorkspaceRuleFactory() {
        return this.getWorkspace().getRuleFactory();
    }

    protected void markInvalid() {
        this.isValid = false;
    }

    public boolean canExecute() {
        return this.isValid();
    }

    public boolean canUndo() {
        return this.isValid();
    }

    public boolean canRedo() {
        return this.isValid();
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, final IAdaptable iAdaptable) throws ExecutionException {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doExecute(iProgressMonitor, iAdaptable);
                }
            }, this.getExecuteSchedulingRule(), 1, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ExecuteErrorTitle, (Object)this.getLabel()), (Throwable)coreException);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, final IAdaptable iAdaptable) throws ExecutionException {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doExecute(iProgressMonitor, iAdaptable);
                }
            }, this.getRedoSchedulingRule(), 1, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_RedoErrorTitle, (Object)this.getLabel()), (Throwable)coreException);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, final IAdaptable iAdaptable) throws ExecutionException {
        try {
            this.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    AbstractWorkspaceOperation.this.doUndo(iProgressMonitor, iAdaptable);
                }
            }, this.getUndoSchedulingRule(), 1, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw new ExecutionException(NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_UndoErrorTitle, (Object)this.getLabel()), (Throwable)coreException);
        }
        this.isValid = true;
        return Status.OK_STATUS;
    }

    protected abstract void doUndo(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected abstract void doExecute(IProgressMonitor var1, IAdaptable var2) throws CoreException;

    protected boolean isValid() {
        return this.isValid;
    }

    public void aboutToNotify(OperationHistoryEvent operationHistoryEvent) {
    }

    public Object[] getAffectedObjects() {
        return this.resources;
    }

    public IStatus computeExecutionStatus(IProgressMonitor iProgressMonitor) {
        boolean bl;
        IStatus iStatus = Status.OK_STATUS;
        if (this.quietCompute) {
            return iStatus;
        }
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(iResourceChangeDescriptionFactory, EXECUTE) && !(bl = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ExecuteSideEffectsWarningMessage, (Object)this.getLabel()), iResourceChangeDescriptionFactory.getDelta(), this.modelProviderIds, true))) {
            iStatus = Status.CANCEL_STATUS;
        }
        return iStatus;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        boolean bl;
        IStatus iStatus = Status.OK_STATUS;
        if (this.quietCompute) {
            return iStatus;
        }
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(iResourceChangeDescriptionFactory, UNDO) && !(bl = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_UndoSideEffectsWarningMessage, (Object)this.getLabel()), iResourceChangeDescriptionFactory.getDelta(), this.modelProviderIds, true))) {
            iStatus = Status.CANCEL_STATUS;
        }
        return iStatus;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) {
        boolean bl;
        IStatus iStatus = Status.OK_STATUS;
        if (this.quietCompute) {
            return iStatus;
        }
        IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = ResourceChangeValidator.getValidator().createDeltaFactory();
        if (this.updateResourceChangeDescriptionFactory(iResourceChangeDescriptionFactory, REDO) && !(bl = IDE.promptToConfirm(this.getShell(null), UndoMessages.AbstractWorkspaceOperation_SideEffectsWarningTitle, NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_RedoSideEffectsWarningMessage, (Object)this.getLabel()), iResourceChangeDescriptionFactory.getDelta(), this.modelProviderIds, true))) {
            iStatus = Status.CANCEL_STATUS;
        }
        return iStatus;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        return false;
    }

    protected IStatus getErrorStatus(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_ErrorInvalidMessage, (Object)this.getLabel());
        }
        return new Status(4, "org.eclipse.ui.ide", 3, string2, null);
    }

    protected IStatus getWarningStatus(String string, int n) {
        String string2 = string;
        if (string2 == null) {
            string2 = NLS.bind((String)UndoMessages.AbstractWorkspaceOperation_GenericWarningMessage, (Object)this.getLabel());
        }
        return new Status(2, "org.eclipse.ui.ide", n, string2, null);
    }

    protected boolean resourcesExist() {
        if (this.resources == null || this.resources.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.resources.length) {
            if (this.resources[n] == null || !this.resources[n].exists()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean resourcesIncludesProjects() {
        if (this.resources == null || this.resources.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.resources.length) {
            if (this.resources[n].getType() == 4) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        return this.getWorkspace().getRoot();
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return this.getWorkspace().getRoot();
    }

    protected ISchedulingRule getRedoSchedulingRule() {
        return this.getExecuteSchedulingRule();
    }

    public void setQuietCompute(boolean bl) {
        this.quietCompute = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append(((Object)((Object)this)).getClass().getName());
        this.appendDescriptiveText(stringBuffer);
        return stringBuffer.toString();
    }

    protected void appendDescriptiveText(StringBuffer stringBuffer) {
        stringBuffer.append(" resources: ");
        stringBuffer.append(this.resources);
        stringBuffer.append('\'');
    }

    protected Shell getShell(IAdaptable iAdaptable) {
        if (iAdaptable != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)iAdaptable.getAdapter((Class)clazz)) != null) {
                return shell;
            }
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public boolean runInBackground() {
        return true;
    }
}

