/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyProjectOperation
extends AbstractCopyOrMoveResourcesOperation {
    private URI projectLocation;
    private IProject originalProject;
    private ProjectDescription originalProjectDescription;

    public CopyProjectOperation(IProject iProject, String string, URI uRI, String string2) {
        super(new IResource[]{iProject}, (IPath)new Path(string), string2);
        Assert.isLegal((iProject != null ? 1 : 0) != 0);
        this.originalProject = iProject;
        this.projectLocation = uRI != null && URIUtil.toPath((URI)uRI).equals((Object)Platform.getLocation()) ? null : uRI;
    }

    private IProject getProposedProjectHandle() {
        if (this.destination.segmentCount() == 1) {
            return this.getWorkspace().getRoot().getProject(this.destination.lastSegment());
        }
        return null;
    }

    protected IStatus computeMoveOrCopyStatus() {
        IStatus iStatus = Status.OK_STATUS;
        IProject iProject = this.getProposedProjectHandle();
        if (iProject == null) {
            return this.getErrorStatus(UndoMessages.AbstractResourcesOperation_NotEnoughInfo);
        }
        if (this.projectLocation != null) {
            iStatus = this.getWorkspace().validateProjectLocationURI(iProject, this.projectLocation);
        }
        if (iStatus.isOK()) {
            return super.computeMoveOrCopyStatus();
        }
        return iStatus;
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        IProject iProject = this.copyProject(this.originalProject, this.destination, this.projectLocation, iProgressMonitor);
        this.setTargetResources(new IResource[]{iProject});
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, true);
        this.setTargetResources(new IResource[]{this.originalProject});
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected boolean isDestinationPathValid(IResource iResource, int n) {
        return true;
    }

    protected String getProposedName(IResource iResource, int n) {
        return this.destination.lastSegment();
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        boolean bl = false;
        if (n == UNDO) {
            int n2 = 0;
            while (n2 < this.resources.length) {
                bl = true;
                IResource iResource = this.resources[n2];
                iResourceChangeDescriptionFactory.delete(iResource);
                ++n2;
            }
        } else {
            iResourceChangeDescriptionFactory.copy((IResource)this.originalProject, this.getDestinationPath((IResource)this.originalProject, 0));
        }
        return bl;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        if (this.originalProject == null || !this.originalProjectDescription.verifyExistence(true)) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        if (iStatus.isOK()) {
            iStatus = this.computeDeleteStatus();
        }
        return iStatus;
    }

    IProject copyProject(IProject iProject, IPath iPath, URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.setTaskName(UndoMessages.AbstractCopyOrMoveResourcesOperation_copyProjectProgress);
        boolean bl = iProject.isOpen();
        if (!bl) {
            iProject.open(null);
        }
        this.originalProjectDescription = new ProjectDescription(iProject);
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setName(iPath.lastSegment());
        iProjectDescription.setLocationURI(uRI);
        iProject.copy(iProjectDescription, 33, iProgressMonitor);
        if (!bl) {
            iProject.close(null);
        }
        return (IProject)this.getWorkspace().getRoot().findMember(iPath);
    }
}

