/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    ResourceDescription[] snapshotResourceDescriptions;

    public CopyResourcesOperation(IResource iResource, IPath iPath, String string) {
        super(new IResource[]{iResource}, new IPath[]{iPath}, string);
        this.setOriginalResources(new IResource[]{iResource});
    }

    public CopyResourcesOperation(IResource[] iResourceArray, IPath iPath, String string) {
        super(iResourceArray, iPath, string);
        this.setOriginalResources(this.resources);
    }

    public CopyResourcesOperation(IResource[] iResourceArray, IPath[] iPathArray, String string) {
        super(iResourceArray, iPathArray, string);
        this.setOriginalResources(this.resources);
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.copy(iProgressMonitor, iAdaptable);
    }

    protected void copy(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        iProgressMonitor.beginTask("", 2000);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList arrayList = new ArrayList();
        ArrayList<ResourceDescription> arrayList2 = new ArrayList<ResourceDescription>();
        int n = 0;
        while (n < this.resources.length) {
            ResourceDescription[] resourceDescriptionArray = WorkspaceUndoUtil.copy(new IResource[]{this.resources[n]}, this.getDestinationPath(this.resources[n], n), arrayList, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000 / this.resources.length), iAdaptable, true, this.fCreateGroups, this.fCreateLinks, this.fRelativeToVariable);
            int n2 = 0;
            while (n2 < resourceDescriptionArray.length) {
                arrayList2.add(resourceDescriptionArray[n2]);
                ++n2;
            }
            ++n;
        }
        if (this.resourceDescriptions != null) {
            n = 0;
            while (n < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[n] != null) {
                    this.resourceDescriptions[n].createResource((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000 / this.resourceDescriptions.length));
                }
                ++n;
            }
        }
        this.setResourceDescriptions(arrayList2.toArray(new ResourceDescription[arrayList2.size()]));
        this.setTargetResources(arrayList.toArray(new IResource[arrayList.size()]));
        iProgressMonitor.done();
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        iProgressMonitor.beginTask("", 2);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, true);
        WorkspaceUndoUtil.recreate(this.resourceDescriptions, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable);
        this.setResourceDescriptions(new ResourceDescription[0]);
        this.setTargetResources(this.originalResources);
        iProgressMonitor.done();
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        boolean bl = false;
        if (n == UNDO) {
            IResource iResource;
            int n2 = 0;
            while (n2 < this.resources.length) {
                bl = true;
                iResource = this.resources[n2];
                iResourceChangeDescriptionFactory.delete(iResource);
                ++n2;
            }
            n2 = 0;
            while (n2 < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[n2] != null) {
                    bl = true;
                    iResource = this.resourceDescriptions[n2].createResourceHandle();
                    iResourceChangeDescriptionFactory.create(iResource);
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.resources.length) {
                bl = true;
                IResource iResource = this.resources[n3];
                iResourceChangeDescriptionFactory.copy(iResource, this.getDestinationPath(iResource, n3));
                ++n3;
            }
        }
        return bl;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (!iStatus.isOK()) {
            return iStatus;
        }
        if (this.originalResources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        int n = 0;
        while (n < this.snapshotResourceDescriptions.length) {
            if (!this.snapshotResourceDescriptions[n].verifyExistence(true)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
            }
            ++n;
        }
        if (iStatus.isOK()) {
            iStatus = this.computeDeleteStatus();
        }
        if (iStatus.isOK() && this.resourceDescriptions != null && this.resourceDescriptions.length > 0) {
            iStatus = this.computeCreateStatus(true);
        }
        return iStatus;
    }

    private void setOriginalResources(IResource[] iResourceArray) {
        this.originalResources = iResourceArray;
        this.snapshotResourceDescriptions = new ResourceDescription[iResourceArray.length];
        int n = 0;
        while (n < iResourceArray.length) {
            this.snapshotResourceDescriptions[n] = ResourceDescription.fromResource(iResourceArray[n]);
            ++n;
        }
    }
}

