/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.ide.undo.AbstractCreateResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.IFileContentDescription;

public class CreateFileOperation
extends AbstractCreateResourcesOperation {
    public CreateFileOperation(IFile iFile, URI uRI, InputStream inputStream, String string) {
        super((ResourceDescription[])null, string);
        AbstractResourceDescription abstractResourceDescription;
        if (iFile.getParent().exists()) {
            abstractResourceDescription = new FileDescription(iFile, uRI, this.createFileContentDescription(iFile, inputStream));
        } else {
            ContainerDescription containerDescription = ContainerDescription.fromContainer(iFile.getParent());
            containerDescription.getFirstLeafFolder().addMember(new FileDescription(iFile, uRI, this.createFileContentDescription(iFile, inputStream)));
            abstractResourceDescription = containerDescription;
        }
        this.setResourceDescriptions(new ResourceDescription[]{abstractResourceDescription});
    }

    private IFileContentDescription createFileContentDescription(final IFile iFile, final InputStream inputStream) {
        return new IFileContentDescription(){

            public InputStream getContents() {
                if (inputStream != null) {
                    return inputStream;
                }
                return new ByteArrayInputStream(new byte[0]);
            }

            public String getCharset() {
                try {
                    return iFile.getCharset(false);
                }
                catch (CoreException coreException) {
                    return null;
                }
            }

            public boolean exists() {
                return true;
            }
        };
    }
}

