/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.ide.undo.AbstractResourcesOperation;

public class DeleteResourcesOperation
extends AbstractResourcesOperation {
    private boolean deleteContent = false;

    public DeleteResourcesOperation(IResource[] iResourceArray, String string, boolean bl) {
        super(iResourceArray, string);
        this.deleteContent = bl;
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.delete(iProgressMonitor, iAdaptable, this.deleteContent);
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.recreate(iProgressMonitor, iAdaptable);
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        boolean bl = false;
        if (n == UNDO) {
            int n2 = 0;
            while (n2 < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[n2] != null) {
                    IResource iResource = this.resourceDescriptions[n2].createResourceHandle();
                    iResourceChangeDescriptionFactory.create(iResource);
                    bl = true;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.resources.length) {
                IResource iResource = this.resources[n3];
                iResourceChangeDescriptionFactory.delete(iResource);
                bl = true;
                ++n3;
            }
        }
        return bl;
    }

    protected ISchedulingRule getExecuteSchedulingRule() {
        return super.computeDeleteSchedulingRule();
    }

    protected ISchedulingRule getUndoSchedulingRule() {
        return super.computeCreateSchedulingRule();
    }

    public IStatus computeExecutionStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeExecutionStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeDeleteStatus();
        }
        return iStatus;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeCreateStatus(false);
        }
        return iStatus;
    }

    public IStatus computeRedoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeRedoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeDeleteStatus();
        }
        return iStatus;
    }

    protected void appendDescriptiveText(StringBuffer stringBuffer) {
        super.appendDescriptiveText(stringBuffer);
        stringBuffer.append(" deleteContent: ");
        stringBuffer.append(this.deleteContent);
        stringBuffer.append('\'');
    }

    IStatus checkReadOnlyResources(IResource[] iResourceArray) {
        if (!this.deleteContent) {
            ArrayList<IResource> arrayList = new ArrayList<IResource>();
            int n = 0;
            while (n < iResourceArray.length) {
                if (iResourceArray[n].getType() != 4) {
                    arrayList.add(iResourceArray[n]);
                }
                ++n;
            }
            if (arrayList.isEmpty()) {
                return Status.OK_STATUS;
            }
            return super.checkReadOnlyResources(arrayList.toArray(new IResource[arrayList.size()]));
        }
        return super.checkReadOnlyResources(iResourceArray);
    }
}

