/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class MoveProjectOperation
extends AbstractCopyOrMoveResourcesOperation {
    private URI projectLocation;

    public MoveProjectOperation(IProject iProject, URI uRI, String string) {
        super(new IResource[]{iProject}, string);
        Assert.isLegal((iProject != null ? 1 : 0) != 0);
        this.projectLocation = URIUtil.toPath((URI)uRI).equals((Object)Platform.getLocation()) ? null : uRI;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        return false;
    }

    private IProject getProject() {
        return (IProject)this.resources[0];
    }

    protected boolean isDestinationPathValid(IResource iResource, int n) {
        return true;
    }

    protected String getProposedName(IResource iResource, int n) {
        return this.getProject().getName();
    }

    protected IStatus computeMoveOrCopyStatus() {
        IStatus iStatus = Status.OK_STATUS;
        if (this.projectLocation != null) {
            iStatus = this.getWorkspace().validateProjectLocationURI(this.getProject(), this.projectLocation);
        }
        if (iStatus.isOK()) {
            return super.computeMoveOrCopyStatus();
        }
        return iStatus;
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.projectLocation = this.moveProject(this.getProject(), this.projectLocation, iProgressMonitor);
        this.setResourceDescriptions(new ResourceDescription[0]);
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.doExecute(iProgressMonitor, iAdaptable);
    }

    URI moveProject(IProject iProject, URI uRI, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.setTaskName(UndoMessages.AbstractCopyOrMoveResourcesOperation_moveProjectProgress);
        IProjectDescription iProjectDescription = iProject.getDescription();
        URI uRI2 = iProjectDescription.getLocationURI();
        iProjectDescription.setLocationURI(uRI);
        iProject.move(iProjectDescription, 33, iProgressMonitor);
        return uRI2;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeMoveOrCopyStatus();
        }
        return iStatus;
    }
}

