/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class MoveResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    IPath originalDestination;
    IPath[] originalDestinationPaths;

    public MoveResourcesOperation(IResource[] iResourceArray, IPath iPath, String string) {
        super(iResourceArray, iPath, string);
        this.originalResources = this.resources;
        this.originalDestination = this.destination;
        this.originalDestinationPaths = this.destinationPaths;
    }

    public MoveResourcesOperation(IResource iResource, IPath iPath, String string) {
        super(new IResource[]{iResource}, new IPath[]{iPath}, string);
        this.originalResources = this.resources;
        this.originalDestination = this.destination;
        this.originalDestinationPaths = this.destinationPaths;
    }

    protected void doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.move(iProgressMonitor, iAdaptable);
    }

    protected void move(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        iProgressMonitor.beginTask("", 2000);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_MovingResources);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<ResourceDescription> arrayList3 = new ArrayList<ResourceDescription>();
        int n = 0;
        while (n < this.resources.length) {
            ResourceDescription[] resourceDescriptionArray = WorkspaceUndoUtil.move(new IResource[]{this.resources[n]}, this.getDestinationPath(this.resources[n], n), arrayList, arrayList2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000 / this.resources.length), iAdaptable, true);
            int n2 = 0;
            while (n2 < resourceDescriptionArray.length) {
                arrayList3.add(resourceDescriptionArray[n2]);
                ++n2;
            }
            ++n;
        }
        if (this.resourceDescriptions != null) {
            n = 0;
            while (n < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[n] != null) {
                    this.resourceDescriptions[n].createResource((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1000 / this.resourceDescriptions.length));
                }
                ++n;
            }
        }
        this.setResourceDescriptions(arrayList3.toArray(new ResourceDescription[arrayList3.size()]));
        this.setTargetResources(arrayList.toArray(new IResource[arrayList.size()]));
        this.destinationPaths = arrayList2.toArray(new IPath[arrayList2.size()]);
        this.destination = null;
        iProgressMonitor.done();
    }

    protected void doUndo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        this.move(iProgressMonitor, iAdaptable);
        this.setTargetResources(this.originalResources);
        this.resourceDescriptions = new ResourceDescription[0];
        this.destination = this.originalDestination;
        this.destinationPaths = this.originalDestinationPaths;
    }

    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory, int n) {
        int n2 = 0;
        while (n2 < this.resources.length) {
            IResource iResource = this.resources[n2];
            iResourceChangeDescriptionFactory.move(iResource, this.getDestinationPath(iResource, n2));
            ++n2;
        }
        return true;
    }

    public IStatus computeUndoableStatus(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = super.computeUndoableStatus(iProgressMonitor);
        if (iStatus.isOK()) {
            iStatus = this.computeMoveOrCopyStatus();
        }
        return iStatus;
    }
}

