/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.undo.ContainerDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class WorkspaceUndoUtil {
    private static ObjectUndoContext tasksUndoContext;
    private static ObjectUndoContext bookmarksUndoContext;
    static /* synthetic */ Class class$0;

    public static IUndoContext getWorkspaceUndoContext() {
        return WorkbenchPlugin.getDefault().getOperationSupport().getUndoContext();
    }

    public static IUndoContext getTasksUndoContext() {
        if (tasksUndoContext == null) {
            tasksUndoContext = new ObjectUndoContext(new Object(), "Tasks Context");
            tasksUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return tasksUndoContext;
    }

    public static IUndoContext getBookmarksUndoContext() {
        if (bookmarksUndoContext == null) {
            bookmarksUndoContext = new ObjectUndoContext(new Object(), "Bookmarks Context");
            bookmarksUndoContext.addMatch(WorkspaceUndoUtil.getWorkspaceUndoContext());
        }
        return bookmarksUndoContext;
    }

    public static IAdaptable getUIInfoAdapter(final Shell shell) {
        return new IAdaptable(){

            public Object getAdapter(Class clazz) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    return shell;
                }
                return null;
            }
        };
    }

    private WorkspaceUndoUtil() {
    }

    static ResourceDescription[] delete(IResource[] iResourceArray, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl) throws CoreException {
        ArrayList<CoreException> arrayList = new ArrayList<CoreException>();
        boolean bl2 = false;
        ResourceDescription[] resourceDescriptionArray = new ResourceDescription[iResourceArray.length];
        iProgressMonitor.beginTask("", iResourceArray.length);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
        try {
            int n = 0;
            while (n < iResourceArray.length) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IResource iResource = iResourceArray[n];
                try {
                    resourceDescriptionArray[n] = WorkspaceUndoUtil.delete(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, bl2, bl);
                }
                catch (CoreException coreException) {
                    if (iResource.getType() == 1) {
                        IStatus[] iStatusArray = coreException.getStatus().getChildren();
                        if (iStatusArray.length == 1 && iStatusArray[0].getCode() == 274) {
                            int n2 = WorkspaceUndoUtil.queryDeleteOutOfSync(iResource, iAdaptable);
                            if (n2 == 2) {
                                WorkspaceUndoUtil.delete(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, true, bl);
                            } else if (n2 == 4) {
                                bl2 = true;
                                WorkspaceUndoUtil.delete(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, bl2, bl);
                            } else {
                                if (n2 == 1) {
                                    throw new OperationCanceledException();
                                }
                                arrayList.add(coreException);
                            }
                        } else {
                            arrayList.add(coreException);
                        }
                    }
                    arrayList.add(coreException);
                }
                ++n;
            }
            IStatus iStatus = WorkspaceUndoUtil.createResult(arrayList);
            if (!iStatus.isOK()) {
                throw new CoreException(iStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return resourceDescriptionArray;
    }

    static ResourceDescription[] copy(IResource[] iResourceArray, IPath iPath, List list, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl) throws CoreException {
        return WorkspaceUndoUtil.copy(iResourceArray, iPath, list, iProgressMonitor, iAdaptable, bl, false, false, null);
    }

    static ResourceDescription[] copy(IResource[] iResourceArray, IPath iResourceArray2, List list, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl, boolean bl2, boolean bl3, String string) throws CoreException {
        iProgressMonitor.beginTask("", iResourceArray.length);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < iResourceArray.length) {
            IFile iFile;
            Object[] objectArray;
            IResource iResource = iResourceArray[n];
            Object object = bl ? iResourceArray2 : iResourceArray2.append(iResource.getName());
            IWorkspaceRoot iWorkspaceRoot = WorkspaceUndoUtil.getWorkspaceRoot();
            IResource iResource2 = iWorkspaceRoot.findMember((IPath)object);
            if (iResource.getType() == 2 && iResource2 != null) {
                if (iResource.isLinked() && iResource2.isLinked() || iResource.isGroup() && iResource2.isGroup() || !iResource.isLinked() && !iResource2.isLinked() && !iResource.isGroup() && !iResource2.isGroup()) {
                    objectArray = ((IContainer)iResource).members();
                    iFile = WorkspaceUndoUtil.copy(objectArray, (IPath)object, list, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false, bl2, bl3, string);
                    int n2 = 0;
                    while (n2 < ((IFile)iFile).length) {
                        arrayList.add(iFile[n2]);
                        ++n2;
                    }
                } else {
                    objectArray = WorkspaceUndoUtil.delete(new IResource[]{iResource2}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0), iAdaptable, false);
                    if ((bl3 || bl2) && !iResource.isLinked() && !iResource.isGroup()) {
                        iFile = iWorkspaceRoot.getFolder((IPath)object);
                        if (bl2) {
                            iFile.createGroup(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            IResource[] iResourceArray3 = ((IContainer)iResource).members();
                            if (iResourceArray3.length > 0) {
                                arrayList.addAll(Arrays.asList(WorkspaceUndoUtil.copy(iResourceArray3, (IPath)object, list, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false, bl2, bl3, string)));
                            }
                        } else {
                            iFile.createLink(WorkspaceUndoUtil.createRelativePath(iFile.getProject().getPathVariableManager(), iResource.getLocationURI(), string), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                    } else {
                        iResource.copy((IPath)object, 32, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        arrayList.add(objectArray[n3]);
                        ++n3;
                    }
                }
            } else {
                if (iResource2 != null) {
                    if ((bl3 || bl2) && !iResource.isLinked()) {
                        objectArray = WorkspaceUndoUtil.delete(new IResource[]{iResource2}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0), iAdaptable, false);
                        if (iResource.getType() == 1) {
                            iFile = iWorkspaceRoot.getFile((IPath)object);
                            iFile.createLink(WorkspaceUndoUtil.createRelativePath(iFile.getProject().getPathVariableManager(), iResource.getLocationURI(), string), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        } else {
                            iFile = iWorkspaceRoot.getFolder((IPath)object);
                            if (bl2) {
                                iFile.createGroup(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                IResource[] iResourceArray4 = ((IContainer)iResource).members();
                                if (iResourceArray4.length > 0) {
                                    arrayList.addAll(Arrays.asList(WorkspaceUndoUtil.copy(iResourceArray4, (IPath)object, list, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false, bl2, bl3, string)));
                                }
                            } else {
                                iFile.createLink(WorkspaceUndoUtil.createRelativePath(iFile.getProject().getPathVariableManager(), iResource.getLocationURI(), string), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            }
                        }
                        list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                        int n4 = 0;
                        while (n4 < objectArray.length) {
                            arrayList.add(objectArray[n4]);
                            ++n4;
                        }
                    } else if (iResource.isLinked() == iResource2.isLinked()) {
                        arrayList.add(WorkspaceUndoUtil.copyOverExistingResource(iResource, iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false));
                        list.add(iResource2);
                    } else {
                        objectArray = WorkspaceUndoUtil.delete(new IResource[]{iResource2}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0), iAdaptable, false);
                        iResource.copy((IPath)object, 32, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                        int n5 = 0;
                        while (n5 < objectArray.length) {
                            arrayList.add(objectArray[n5]);
                            ++n5;
                        }
                    }
                } else {
                    objectArray = iResourceArray2;
                    if (bl) {
                        objectArray = iResourceArray2.removeLastSegments(1);
                    }
                    iFile = WorkspaceUndoUtil.generateContainers((IPath)objectArray);
                    if ((bl3 || bl2) && !iResource.isLinked()) {
                        if (iResource.getType() == 1) {
                            IFile iFile2 = iWorkspaceRoot.getFile((IPath)object);
                            iFile2.createLink(WorkspaceUndoUtil.createRelativePath(iFile2.getProject().getPathVariableManager(), iResource.getLocationURI(), string), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        } else {
                            IFolder iFolder = iWorkspaceRoot.getFolder((IPath)object);
                            if (bl2) {
                                iFolder.createGroup(0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                IResource[] iResourceArray5 = ((IContainer)iResource).members();
                                if (iResourceArray5.length > 0) {
                                    arrayList.addAll(Arrays.asList(WorkspaceUndoUtil.copy(iResourceArray5, (IPath)object, list, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false, bl2, bl3, string)));
                                }
                            } else {
                                iFolder.createLink(WorkspaceUndoUtil.createRelativePath(iFolder.getProject().getPathVariableManager(), iResource.getLocationURI(), string), 0, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                            }
                        }
                    } else {
                        iResource.copy((IPath)object, 32, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    }
                    if (iFile == null) {
                        list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                    } else {
                        list.add(iFile);
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        iProgressMonitor.done();
        return arrayList.toArray(new ResourceDescription[arrayList.size()]);
    }

    private static URI createRelativePath(IPathVariableManager iPathVariableManager, URI uRI, String string) {
        IPath iPath;
        if (string == null) {
            return uRI;
        }
        IPath iPath2 = URIUtil.toPath((URI)uRI);
        try {
            iPath = iPathVariableManager.convertToRelative(iPath2, true, string);
        }
        catch (CoreException coreException) {
            return uRI;
        }
        return URIUtil.toURI((IPath)iPath);
    }

    static ResourceDescription[] move(IResource[] iResourceArray, IPath resourceDescriptionArray, List list, List list2, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl) throws CoreException {
        iProgressMonitor.beginTask("", iResourceArray.length);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_MovingResources);
        ArrayList<ResourceDescription> arrayList = new ArrayList<ResourceDescription>();
        int n = 0;
        while (n < iResourceArray.length) {
            ResourceDescription[] resourceDescriptionArray2;
            ResourceDescription[] resourceDescriptionArray3;
            IResource iResource = iResourceArray[n];
            Object object = bl ? resourceDescriptionArray : resourceDescriptionArray.append(iResource.getName());
            IWorkspaceRoot iWorkspaceRoot = WorkspaceUndoUtil.getWorkspaceRoot();
            IResource iResource2 = iWorkspaceRoot.findMember((IPath)object);
            if (iResource.getType() == 2 && iResource2 != null) {
                if (iResource.isLinked() == iResource2.isLinked()) {
                    resourceDescriptionArray3 = ((IContainer)iResource).members();
                    resourceDescriptionArray2 = WorkspaceUndoUtil.move((IResource[])resourceDescriptionArray3, (IPath)object, list, list2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, false);
                    int n2 = 0;
                    while (n2 < resourceDescriptionArray2.length) {
                        arrayList.add(resourceDescriptionArray2[n2]);
                        ++n2;
                    }
                    WorkspaceUndoUtil.delete(iResource, iProgressMonitor, iAdaptable, false, false);
                } else {
                    resourceDescriptionArray3 = WorkspaceUndoUtil.delete(new IResource[]{iResource2}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0), iAdaptable, false);
                    list2.add(iResource.getFullPath());
                    iResource.move((IPath)object, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                    int n3 = 0;
                    while (n3 < resourceDescriptionArray3.length) {
                        arrayList.add(resourceDescriptionArray3[n3]);
                        ++n3;
                    }
                }
            } else {
                if (iResource2 != null) {
                    if (iResource.isLinked() == iResource2.isLinked()) {
                        list2.add(iResource.getFullPath());
                        arrayList.add(WorkspaceUndoUtil.copyOverExistingResource(iResource, iResource2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), iAdaptable, true));
                        list.add(iResource2);
                    } else {
                        resourceDescriptionArray3 = WorkspaceUndoUtil.delete(new IResource[]{iResource2}, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 0), iAdaptable, false);
                        list2.add(iResource.getFullPath());
                        iResource.move((IPath)object, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                        int n4 = 0;
                        while (n4 < resourceDescriptionArray3.length) {
                            arrayList.add(resourceDescriptionArray3[n4]);
                            ++n4;
                        }
                    }
                } else {
                    list2.add(iResource.getFullPath());
                    resourceDescriptionArray3 = resourceDescriptionArray;
                    if (bl) {
                        resourceDescriptionArray3 = resourceDescriptionArray.removeLastSegments(1);
                    }
                    resourceDescriptionArray2 = WorkspaceUndoUtil.generateContainers((IPath)resourceDescriptionArray3);
                    iResource.move((IPath)object, 34, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    if (resourceDescriptionArray2 == null) {
                        list.add(WorkspaceUndoUtil.getWorkspace().getRoot().findMember((IPath)object));
                    } else {
                        list.add(resourceDescriptionArray2);
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        iProgressMonitor.done();
        return arrayList.toArray(new ResourceDescription[arrayList.size()]);
    }

    static IResource[] recreate(ResourceDescription[] resourceDescriptionArray, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws CoreException {
        ArrayList<CoreException> arrayList = new ArrayList<CoreException>();
        IResource[] iResourceArray = new IResource[resourceDescriptionArray.length];
        iProgressMonitor.beginTask("", resourceDescriptionArray.length);
        iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CreateResourcesProgress);
        try {
            int n = 0;
            while (n < resourceDescriptionArray.length) {
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    iResourceArray[n] = resourceDescriptionArray[n].createResource((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                }
                catch (CoreException coreException) {
                    arrayList.add(coreException);
                }
                ++n;
            }
            IStatus iStatus = WorkspaceUndoUtil.createResult(arrayList);
            if (!iStatus.isOK()) {
                throw new CoreException(iStatus);
            }
        }
        finally {
            iProgressMonitor.done();
        }
        return iResourceArray;
    }

    static ResourceDescription delete(IResource iResource, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl, boolean bl2) throws CoreException {
        ResourceDescription resourceDescription = ResourceDescription.fromResource(iResource);
        if (iResource.getType() == 4) {
            iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
            IProject iProject = (IProject)iResource;
            iProject.delete(bl2, bl, iProgressMonitor);
        } else {
            iProgressMonitor.beginTask("", 2);
            iProgressMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_DeleteResourcesProgress);
            int n = bl ? 3 : 2;
            iResource.delete(n, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            resourceDescription.recordStateFromHistory(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.done();
        }
        return resourceDescription;
    }

    private static ResourceDescription copyOverExistingResource(IResource iResource, IResource iResource2, IProgressMonitor iProgressMonitor, IAdaptable iAdaptable, boolean bl) throws CoreException {
        if (!(iResource instanceof IFile) || !(iResource2 instanceof IFile)) {
            return null;
        }
        IFile iFile = (IFile)iResource;
        IFile iFile2 = (IFile)iResource2;
        iProgressMonitor.beginTask(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress, 3);
        if (iFile != null && iFile2 != null && WorkspaceUndoUtil.validateEdit(iFile, iFile2, WorkspaceUndoUtil.getShell(iAdaptable))) {
            FileDescription fileDescription = new FileDescription(iFile2);
            iFile2.setContents(iFile.getContents(), 2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            fileDescription.recordStateFromHistory((IResource)iFile2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (bl) {
                iFile.delete(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
            iProgressMonitor.done();
            return fileDescription;
        }
        iProgressMonitor.done();
        return null;
    }

    private static IContainer generateContainers(IPath iPath) throws CoreException {
        if (iPath.segmentCount() == 0) {
            return null;
        }
        Object object = WorkspaceUndoUtil.getWorkspaceRoot().findMember(iPath);
        if (object != null) {
            return null;
        }
        object = iPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
        ContainerDescription containerDescription = ContainerDescription.fromContainer((IContainer)object);
        object = containerDescription.createResourceHandle();
        containerDescription.createExistentResourceFromHandle((IResource)object, (IProgressMonitor)new NullProgressMonitor());
        return (IContainer)object;
    }

    private static int queryDeleteOutOfSync(IResource iResource, IAdaptable iAdaptable) {
        Shell shell = WorkspaceUndoUtil.getShell(iAdaptable);
        final MessageDialog messageDialog = new MessageDialog(shell, UndoMessages.AbstractResourcesOperation_deletionMessageTitle, null, NLS.bind((String)UndoMessages.AbstractResourcesOperation_outOfSyncQuestion, (Object)iResource.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                messageDialog.open();
            }
        });
        int n = messageDialog.getReturnCode();
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 3;
        }
        return 1;
    }

    private static IStatus createResult(List list) {
        if (list.isEmpty()) {
            return Status.OK_STATUS;
        }
        int n = list.size();
        if (n == 1) {
            return ((CoreException)((Object)list.get(0))).getStatus();
        }
        CoreException[] coreExceptionArray = list.toArray(new CoreException[n]);
        boolean bl = false;
        int n2 = 0;
        while (n2 < coreExceptionArray.length) {
            if (coreExceptionArray[n2].getStatus().getCode() == 274) {
                bl = true;
                break;
            }
            ++n2;
        }
        String string = bl ? UndoMessages.AbstractResourcesOperation_outOfSyncError : UndoMessages.AbstractResourcesOperation_deletionExceptionMessage;
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui.ide", 0, string, null);
        int n3 = 0;
        while (n3 < n) {
            CoreException coreException = coreExceptionArray[n3];
            IStatus iStatus = coreException.getStatus();
            multiStatus.add((IStatus)new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), (Throwable)coreException));
            ++n3;
        }
        return multiStatus;
    }

    private static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return WorkspaceUndoUtil.getWorkspace().getRoot();
    }

    private static boolean validateEdit(IFile iFile, IFile iFile2, Shell shell) {
        if (iFile2.isReadOnly()) {
            IWorkspace iWorkspace = WorkspaceUndoUtil.getWorkspace();
            IStatus iStatus = iFile.isReadOnly() ? iWorkspace.validateEdit(new IFile[]{iFile, iFile2}, (Object)shell) : iWorkspace.validateEdit(new IFile[]{iFile2}, (Object)shell);
            return iStatus.isOK();
        }
        return true;
    }

    public static Shell getShell(IAdaptable iAdaptable) {
        if (iAdaptable != null) {
            Shell shell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Shell");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((shell = (Shell)iAdaptable.getAdapter((Class)clazz)) != null) {
                return shell;
            }
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

