/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.BundleGroupProperties;
import org.eclipse.ui.internal.ProductProperties;

public final class AboutInfo {
    private ProductProperties productProperties;
    private BundleGroupProperties bundleGroupProperties;
    private Long featureImageCRC;
    private boolean calculatedImageCRC = false;

    public AboutInfo(IProduct iProduct) {
        this.productProperties = new ProductProperties(iProduct);
    }

    public AboutInfo(IBundleGroup iBundleGroup) {
        this.bundleGroupProperties = new BundleGroupProperties(iBundleGroup);
    }

    public static AboutInfo readFeatureInfo(String string, String string2) {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null && string.equals(ProductProperties.getProductId((IProduct)iProduct))) {
            return new AboutInfo(iProduct);
        }
        IBundleGroup iBundleGroup = AboutInfo.getBundleGroup(string, string2);
        if (iBundleGroup != null) {
            return new AboutInfo(iBundleGroup);
        }
        return null;
    }

    private static IBundleGroup getBundleGroup(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        int n = 0;
        while (n < iBundleGroupProviderArray.length) {
            IBundleGroup[] iBundleGroupArray = iBundleGroupProviderArray[n].getBundleGroups();
            int n2 = 0;
            while (n2 < iBundleGroupArray.length) {
                if (string.equals(iBundleGroupArray[n2].getIdentifier()) && string2.equals(iBundleGroupArray[n2].getVersion())) {
                    return iBundleGroupArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public ImageDescriptor getAboutImage() {
        return this.productProperties == null ? null : this.productProperties.getAboutImage();
    }

    public ImageDescriptor getFeatureImage() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getFeatureImage();
    }

    public String getFeatureImageName() {
        if (this.bundleGroupProperties == null) {
            return null;
        }
        URL uRL = this.bundleGroupProperties.getFeatureImageUrl();
        return uRL == null ? null : new Path(uRL.getPath()).lastSegment();
    }

    public Long getFeatureImageCRC() {
        if (this.bundleGroupProperties == null) {
            return null;
        }
        if (!this.calculatedImageCRC) {
            this.featureImageCRC = AboutInfo.calculateImageCRC(this.bundleGroupProperties.getFeatureImageUrl());
            this.calculatedImageCRC = this.featureImageCRC != null;
        }
        return this.featureImageCRC;
    }

    /*
     * Loose catch block
     */
    private static Long calculateImageCRC(URL uRL) {
        Long l;
        InputStream inputStream;
        block13: {
            if (uRL == null) {
                return null;
            }
            inputStream = null;
            CRC32 cRC32 = new CRC32();
            inputStream = new CheckedInputStream(uRL.openStream(), cRC32);
            byte[] byArray = new byte[2048];
            while (inputStream.read(byArray) > 0) {
            }
            l = new Long(cRC32.getValue());
            if (inputStream == null) break block13;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return l;
        catch (IOException iOException) {
            block14: {
                try {
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public String getFeatureLabel() {
        if (this.productProperties != null) {
            return this.productProperties.getProductName();
        }
        if (this.bundleGroupProperties != null) {
            return this.bundleGroupProperties.getFeatureLabel();
        }
        return null;
    }

    public String getFeatureId() {
        String string = null;
        if (this.productProperties != null) {
            string = this.productProperties.getProductId();
        } else if (this.bundleGroupProperties != null) {
            string = this.bundleGroupProperties.getFeatureId();
        }
        return string != null ? string : "";
    }

    public String getAboutText() {
        return this.productProperties == null ? null : this.productProperties.getAboutText();
    }

    public String getAppName() {
        return this.productProperties == null ? null : this.productProperties.getAppName();
    }

    public String getProductName() {
        return this.productProperties == null ? null : this.productProperties.getProductName();
    }

    public String getProviderName() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getProviderName();
    }

    public String getVersionId() {
        return this.bundleGroupProperties == null ? "" : this.bundleGroupProperties.getFeatureVersion();
    }

    public URL getWelcomePageURL() {
        if (this.productProperties != null) {
            return this.productProperties.getWelcomePageUrl();
        }
        if (this.bundleGroupProperties != null) {
            return this.bundleGroupProperties.getWelcomePageUrl();
        }
        return null;
    }

    public String getWelcomePerspectiveId() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getWelcomePerspective();
    }

    public String getTipsAndTricksHref() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getTipsAndTricksHref();
    }

    public ImageDescriptor[] getWindowImages() {
        return this.productProperties == null ? null : this.productProperties.getWindowImages();
    }

    public String getBrandingBundleId() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getBrandingBundleId();
    }

    public String getBrandingBundleVersion() {
        return this.bundleGroupProperties == null ? null : this.bundleGroupProperties.getBrandingBundleVersion();
    }
}

