/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ChooseWorkspaceData {
    private static final int RECENT_MAX_LENGTH = 5;
    private static final String PERS_FOLDER = "org.eclipse.ui.ide";
    private static final String PERS_FILENAME = "recentWorkspaces.xml";
    private static final int PERS_ENCODING_VERSION = 1;
    private static final int PERS_ENCODING_VERSION_CONFIG_PREFS = 2;
    private static final int PERS_ENCODING_VERSION_CONFIG_PREFS_NO_COMMAS = 3;
    private boolean showDialog = true;
    private String initialDefault;
    private String selection;
    private String[] recentWorkspaces;

    public ChooseWorkspaceData(String string) {
        this.readPersistedData();
        this.setInitialDefault(string);
    }

    public ChooseWorkspaceData(URL uRL) {
        this.readPersistedData();
        if (uRL != null) {
            this.setInitialDefault(new File(uRL.getFile()).toString());
        }
    }

    public String getInitialDefault() {
        if (this.initialDefault == null) {
            this.setInitialDefault(String.valueOf(System.getProperty("user.dir")) + File.separator + "workspace");
        }
        return this.initialDefault;
    }

    private void setInitialDefault(String string) {
        if (string == null || string.length() <= 0) {
            this.initialDefault = null;
            return;
        }
        string = new Path(string).toOSString();
        while (string.charAt(string.length() - 1) == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        this.initialDefault = string;
    }

    public String getSelection() {
        return this.selection;
    }

    public boolean getShowDialog() {
        return this.showDialog;
    }

    public String[] getRecentWorkspaces() {
        return this.recentWorkspaces;
    }

    public void workspaceSelected(String string) {
        this.selection = string;
    }

    public void toggleShowDialog() {
        this.showDialog = !this.showDialog;
    }

    public void setRecentWorkspaces(String[] stringArray) {
        this.recentWorkspaces = stringArray == null ? new String[0] : stringArray;
    }

    public void writePersistedData() {
        String string;
        IEclipsePreferences iEclipsePreferences = new ConfigurationScope().getNode(PERS_FOLDER);
        iEclipsePreferences.putBoolean("SHOW_WORKSPACE_SELECTION_DIALOG", this.showDialog);
        iEclipsePreferences.putInt("MAX_RECENT_WORKSPACES", this.recentWorkspaces.length);
        if (this.selection != null) {
            string = this.recentWorkspaces[0];
            this.recentWorkspaces[0] = this.selection;
            int n = 1;
            while (n < this.recentWorkspaces.length && string != null) {
                if (this.selection.equals(string)) break;
                String string2 = this.recentWorkspaces[n];
                this.recentWorkspaces[n] = string;
                string = string2;
                ++n;
            }
        }
        string = ChooseWorkspaceData.encodeStoredWorkspacePaths(this.recentWorkspaces);
        iEclipsePreferences.put("RECENT_WORKSPACES", string);
        iEclipsePreferences.putInt("RECENT_WORKSPACES_PROTOCOL", 3);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean readPersistedData_file() {
        URL uRL = null;
        Location location = Platform.getConfigurationLocation();
        if (location != null) {
            uRL = ChooseWorkspaceData.getPersistenceUrl(location.getURL(), false);
        }
        try {
            IMemento[] iMementoArray;
            if (uRL == null) {
                return false;
            }
            FileReader fileReader = new FileReader(uRL.getFile());
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)fileReader);
            if (xMLMemento == null || !ChooseWorkspaceData.compatibleFileProtocol((IMemento)xMLMemento)) {
                return false;
            }
            IMemento iMemento = xMLMemento.getChild("alwaysAsk");
            this.showDialog = iMemento == null ? true : iMemento.getInteger("showDialog") == 1;
            IMemento iMemento2 = xMLMemento.getChild("recentWorkspaces");
            if (iMemento2 == null) {
                return false;
            }
            Integer n = iMemento2.getInteger("maxLength");
            int n2 = 5;
            if (n != null) {
                n2 = n;
            }
            if ((iMementoArray = iMemento2.getChildren("workspace")) == null || iMementoArray.length <= 0) {
                return false;
            }
            try {
                n2 = Math.max(n2, iMementoArray.length);
                this.recentWorkspaces = new String[n2];
                int n3 = 0;
                while (n3 < iMementoArray.length) {
                    String string = iMementoArray[n3].getString("path");
                    if (string == null) {
                        break;
                    }
                    this.recentWorkspaces[n3] = string;
                    ++n3;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            catch (WorkbenchException workbenchException) {
                return false;
            }
        }
        finally {
            if (this.recentWorkspaces == null) {
                this.recentWorkspaces = new String[5];
            }
        }
        return true;
    }

    public static boolean getShowDialogValue() {
        ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData("");
        return chooseWorkspaceData.readPersistedData() ? chooseWorkspaceData.showDialog : true;
    }

    public static void setShowDialogValue(boolean bl) {
        ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData("");
        chooseWorkspaceData.showDialog = bl;
        chooseWorkspaceData.writePersistedData();
    }

    public boolean readPersistedData() {
        ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), PERS_FOLDER);
        int n = scopedPreferenceStore.getInt("RECENT_WORKSPACES_PROTOCOL");
        if (n == 0 && this.readPersistedData_file()) {
            return true;
        }
        this.showDialog = scopedPreferenceStore.getBoolean("SHOW_WORKSPACE_SELECTION_DIALOG");
        int n2 = scopedPreferenceStore.getInt("MAX_RECENT_WORKSPACES");
        n2 = Math.max(n2, 5);
        String string = scopedPreferenceStore.getString("RECENT_WORKSPACES");
        this.recentWorkspaces = ChooseWorkspaceData.decodeStoredWorkspacePaths(n, n2, string);
        return true;
    }

    private static String encodeStoredWorkspacePaths(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) break;
            if (string != null) {
                stringBuffer.append("\n");
            }
            string = stringArray[n];
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String[] decodeStoredWorkspacePaths(int n, int n2, String string) {
        String[] stringArray = new String[n2];
        if (string == null || string.length() <= 0) {
            return stringArray;
        }
        String string2 = null;
        switch (n) {
            case 3: {
                string2 = "\n";
                break;
            }
            case 2: {
                string2 = ",";
            }
        }
        if (string2 == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n3 = 0;
        while (n3 < stringArray.length && stringTokenizer.hasMoreTokens()) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    private static boolean compatibleFileProtocol(IMemento iMemento) {
        IMemento iMemento2 = iMemento.getChild("protocol");
        if (iMemento2 == null) {
            return false;
        }
        Integer n = iMemento2.getInteger("version");
        return n != null && n == 1;
    }

    private static URL getPersistenceUrl(URL uRL, boolean bl) {
        File file;
        block6: {
            File file2;
            URL uRL2;
            block5: {
                if (uRL == null) {
                    return null;
                }
                try {
                    uRL2 = new URL(uRL, PERS_FOLDER);
                    file2 = new File(uRL2.getFile());
                    if (file2.exists() || bl && file2.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            uRL2 = new URL(file2.toURL(), PERS_FILENAME);
            file = new File(uRL2.getFile());
            if (file.exists() || bl && file.createNewFile()) break block6;
            return null;
        }
        return file.toURL();
    }

    private static interface XML {
        public static final String PROTOCOL = "protocol";
        public static final String VERSION = "version";
        public static final String ALWAYS_ASK = "alwaysAsk";
        public static final String SHOW_DIALOG = "showDialog";
        public static final String WORKSPACE = "workspace";
        public static final String RECENT_WORKSPACES = "recentWorkspaces";
        public static final String MAX_LENGTH = "maxLength";
        public static final String PATH = "path";
    }
}

