/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ChooseWorkspaceDialog
extends TitleAreaDialog {
    private static final String DIALOG_SETTINGS_SECTION = "ChooseWorkspaceDialogSettings";
    private ChooseWorkspaceData launchData;
    private Combo text;
    private boolean suppressAskAgain = false;
    private boolean centerOnMonitor = false;

    public ChooseWorkspaceDialog(Shell shell, ChooseWorkspaceData chooseWorkspaceData, boolean bl, boolean bl2) {
        super(shell);
        this.launchData = chooseWorkspaceData;
        this.suppressAskAgain = bl;
        this.centerOnMonitor = bl2;
    }

    public void prompt(boolean bl) {
        if (bl || this.launchData.getShowDialog()) {
            this.open();
            if (this.getReturnCode() == 1) {
                this.launchData.workspaceSelected(null);
            }
            return;
        }
        String[] stringArray = this.launchData.getRecentWorkspaces();
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (string == null || string.length() == 0) {
            string = this.launchData.getInitialDefault();
        }
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)string));
    }

    protected Control createDialogArea(Composite composite) {
        String string = ChooseWorkspaceDialog.getWindowTitle();
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.setTitle(IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogTitle);
        this.setMessage(NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogMessage, (Object)string));
        if (this.getTitleImageLabel() != null) {
            this.getTitleImageLabel().setVisible(false);
        }
        this.createWorkspaceBrowseRow(composite2);
        if (!this.suppressAskAgain) {
            this.createShowDialogButton(composite2);
        }
        boolean bl = Boolean.getBoolean("eclipse.gcj");
        String string2 = System.getProperty("java.vm.name");
        if (!bl && string2 != null && string2.indexOf("libgcj") != -1) {
            composite2.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ChooseWorkspaceDialog.this.setMessage(IDEWorkbenchMessages.UnsupportedVM_message, 2);
                }
            });
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public static String getWindowTitle() {
        String string = null;
        IProduct iProduct = Platform.getProduct();
        if (iProduct != null) {
            string = iProduct.getName();
        }
        if (string == null) {
            string = IDEWorkbenchMessages.ChooseWorkspaceDialog_defaultProductName;
        }
        return string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_dialogName);
    }

    protected void okPressed() {
        this.launchData.workspaceSelected(TextProcessor.deprocess((String)this.getWorkspaceLocation()));
        super.okPressed();
    }

    protected String getWorkspaceLocation() {
        return this.text.getText();
    }

    protected void cancelPressed() {
        this.launchData.workspaceSelected(null);
        super.cancelPressed();
    }

    private void createWorkspaceBrowseRow(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_workspaceEntryLabel);
        this.text = new Combo(composite2, 18436);
        this.text.setFocus();
        this.text.setLayoutData((Object)new GridData(400, -1));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                Button button = ChooseWorkspaceDialog.this.getButton(0);
                if (button != null && !button.isDisposed()) {
                    boolean bl = false;
                    String string = ChooseWorkspaceDialog.this.getWorkspaceLocation();
                    int n = 0;
                    while (!bl && n < string.length()) {
                        if (!Character.isWhitespace(string.charAt(n))) {
                            bl = true;
                        }
                        ++n;
                    }
                    button.setEnabled(bl);
                }
            }
        });
        this.setInitialTextValues(this.text);
        Button button = new Button(composite2, 8);
        button.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_browseLabel);
        this.setButtonLayoutData(button);
        GridData gridData = (GridData)button.getLayoutData();
        gridData.horizontalAlignment = 128;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ChooseWorkspaceDialog.this.getShell());
                directoryDialog.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserTitle);
                directoryDialog.setMessage(IDEWorkbenchMessages.ChooseWorkspaceDialog_directoryBrowserMessage);
                directoryDialog.setFilterPath(ChooseWorkspaceDialog.this.getInitialBrowsePath());
                String string = directoryDialog.open();
                if (string != null) {
                    ChooseWorkspaceDialog.this.text.setText(TextProcessor.process((String)string));
                }
            }
        });
    }

    private String getInitialBrowsePath() {
        File file = new File(this.getWorkspaceLocation());
        while (file != null && !file.exists()) {
            file = file.getParentFile();
        }
        return file != null ? file.getAbsolutePath() : System.getProperty("user.dir");
    }

    protected Point getInitialLocation(Point point) {
        Composite composite = this.getShell().getParent();
        if (!this.centerOnMonitor || composite == null) {
            return super.getInitialLocation(point);
        }
        Monitor monitor = composite.getMonitor();
        Rectangle rectangle = monitor.getClientArea();
        Point point2 = Geometry.centerPoint((Rectangle)rectangle);
        return new Point(point2.x - point.x / 2, Math.max(rectangle.y, Math.min(point2.y - point.y * 2 / 3, rectangle.y + rectangle.height - point.y)));
    }

    private void createShowDialogButton(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.verticalAlignment = 3;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 32);
        button.setText(IDEWorkbenchMessages.ChooseWorkspaceDialog_useDefaultMessage);
        button.setSelection(!this.launchData.getShowDialog());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChooseWorkspaceDialog.this.launchData.toggleShowDialog();
            }
        });
    }

    private void setInitialTextValues(Combo combo) {
        String[] stringArray = this.launchData.getRecentWorkspaces();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                combo.add(stringArray[n]);
            }
            ++n;
        }
        combo.setText(TextProcessor.process((String)(combo.getItemCount() > 0 ? combo.getItem(0) : this.launchData.getInitialDefault())));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        if (this.centerOnMonitor) {
            return null;
        }
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return iDialogSettings2;
    }
}

