/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.preferences.SettingsTransfer;

public class ChooseWorkspaceWithSettingsDialog
extends ChooseWorkspaceDialog {
    private static final String WORKBENCH_SETTINGS = "WORKBENCH_SETTINGS";
    private static final String ENABLED_TRANSFERS = "ENABLED_TRANSFERS";
    private static final String ATT_CLASS = "class";
    private static final String ATT_NAME = "name";
    private static final String ATT_ID = "id";
    private static final String ATT_HELP_CONTEXT = "helpContext";
    private Collection selectedSettings = new HashSet();

    public ChooseWorkspaceWithSettingsDialog(Shell shell, ChooseWorkspaceData chooseWorkspaceData, boolean bl, boolean bl2) {
        super(shell, chooseWorkspaceData, bl, bl2);
    }

    protected Control createDialogArea(Composite composite) {
        Control control = super.createDialogArea(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.switch_workspace_dialog_context");
        this.createSettingsControls((Composite)control);
        ChooseWorkspaceWithSettingsDialog.applyDialogFont((Control)composite);
        return control;
    }

    private void createSettingsControls(Composite composite) {
        final FormToolkit formToolkit = new FormToolkit(composite.getDisplay());
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                formToolkit.dispose();
            }
        });
        final ScrolledForm scrolledForm = formToolkit.createScrolledForm(composite);
        scrolledForm.setBackground(composite.getBackground());
        scrolledForm.getBody().setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        scrolledForm.setLayoutData((Object)gridData);
        ExpandableComposite expandableComposite = formToolkit.createExpandableComposite(scrolledForm.getBody(), 2);
        expandableComposite.setText(IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SettingsGroupName);
        expandableComposite.setBackground(composite.getBackground());
        expandableComposite.setLayout((Layout)new GridLayout());
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        expandableComposite.addExpansionListener(new IExpansionListener(){
            boolean notExpanded = true;

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                scrolledForm.reflow(true);
                if (expansionEvent.getState() && this.notExpanded) {
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setRedraw(false);
                    Rectangle rectangle = ChooseWorkspaceWithSettingsDialog.this.getShell().getBounds();
                    int n = Math.min(4, SettingsTransfer.getSettingsTransfers().length);
                    rectangle.height += ChooseWorkspaceWithSettingsDialog.this.convertHeightInCharsToPixels(n) + 4;
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setBounds(rectangle);
                    ChooseWorkspaceWithSettingsDialog.this.getShell().setRedraw(true);
                    this.notExpanded = false;
                }
            }

            public void expansionStateChanging(ExpansionEvent expansionEvent) {
            }
        });
        Composite composite2 = formToolkit.createComposite((Composite)expandableComposite);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setBackground(composite.getBackground());
        if (this.createButtons(formToolkit, composite2)) {
            expandableComposite.setExpanded(true);
        }
        expandableComposite.setClient((Control)composite2);
    }

    private boolean createButtons(FormToolkit formToolkit, Composite composite) {
        IConfigurationElement[] iConfigurationElementArray = SettingsTransfer.getSettingsTransfers();
        String[] stringArray = this.getEnabledSettings(IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS));
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            final IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            final Button button = formToolkit.createButton(composite, iConfigurationElementArray[n].getAttribute(ATT_NAME), 32);
            String string = iConfigurationElementArray[n].getAttribute(ATT_HELP_CONTEXT);
            if (string != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)button, string);
            }
            if (stringArray != null && stringArray.length > 0) {
                String string2 = iConfigurationElementArray[n].getAttribute(ATT_ID);
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].equals(string2)) {
                        button.setSelection(true);
                        this.selectedSettings.add(iConfigurationElement);
                        break;
                    }
                    ++n2;
                }
            }
            button.setBackground(composite.getBackground());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (button.getSelection()) {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.add(iConfigurationElement);
                    } else {
                        ChooseWorkspaceWithSettingsDialog.this.selectedSettings.remove(iConfigurationElement);
                    }
                }
            });
            ++n;
        }
        return stringArray != null && stringArray.length > 0;
    }

    private String[] getEnabledSettings(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return null;
        }
        return iDialogSettings.getArray(ENABLED_TRANSFERS);
    }

    protected void okPressed() {
        Iterator iterator = this.selectedSettings.iterator();
        MultiStatus multiStatus = new MultiStatus("org.eclipse.ui", 0, IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ProblemsTransferTitle, null);
        Path path = new Path(this.getWorkspaceLocation());
        String[] stringArray = new String[this.selectedSettings.size()];
        int n = 0;
        while (iterator.hasNext()) {
            IConfigurationElement iConfigurationElement = (IConfigurationElement)iterator.next();
            multiStatus.add(this.transferSettings(iConfigurationElement, (IPath)path));
            stringArray[n] = iConfigurationElement.getAttribute(ATT_ID);
        }
        if (multiStatus.getSeverity() != 0) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_TransferFailedMessage, (String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_SaveSettingsFailed, (IStatus)multiStatus);
            return;
        }
        this.saveSettings(stringArray);
        super.okPressed();
    }

    private void saveSettings(String[] stringArray) {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(WORKBENCH_SETTINGS);
        if (iDialogSettings == null) {
            iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(WORKBENCH_SETTINGS);
        }
        iDialogSettings.put(ENABLED_TRANSFERS, stringArray);
    }

    private IStatus transferSettings(final IConfigurationElement iConfigurationElement, final IPath iPath) {
        final IStatus[] iStatusArray = new IStatus[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                try {
                    SettingsTransfer settingsTransfer = (SettingsTransfer)WorkbenchPlugin.createExtension((IConfigurationElement)iConfigurationElement, (String)ChooseWorkspaceWithSettingsDialog.ATT_CLASS);
                    settingsTransfer.transferSettings(iPath);
                }
                catch (CoreException coreException) {
                    iStatusArray[0] = coreException.getStatus();
                }
            }

            public void handleException(Throwable throwable) {
                iStatusArray[0] = StatusUtil.newStatus(4, NLS.bind((String)IDEWorkbenchMessages.ChooseWorkspaceWithSettingsDialog_ClassCreationFailed, (Object)iConfigurationElement.getAttribute(ChooseWorkspaceWithSettingsDialog.ATT_CLASS)), throwable);
            }
        });
        if (iStatusArray[0] != null) {
            return iStatusArray[0];
        }
        return Status.OK_STATUS;
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }
}

