/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.model.WorkbenchFile;

public class ContentTypeDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object object, IDecoration iDecoration) {
        IContentType iContentType;
        if (!(object instanceof IFile)) {
            return;
        }
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench.isClosing()) {
            return;
        }
        IFile iFile = (IFile)object;
        ImageDescriptor imageDescriptor = null;
        IContentDescription iContentDescription = null;
        try {
            iContentDescription = iFile.getContentDescription();
        }
        catch (CoreException coreException) {}
        if (iContentDescription != null && (iContentType = iContentDescription.getContentType()) != null) {
            imageDescriptor = iWorkbench.getEditorRegistry().getImageDescriptor(iFile.getName(), iContentType);
        }
        try {
            if (iFile.getSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY) != imageDescriptor) {
                iFile.setSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY, imageDescriptor);
            }
        }
        catch (CoreException coreException) {}
        if (imageDescriptor != null) {
            iDecoration.addOverlay(imageDescriptor);
        }
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }
}

