/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class EditorAreaDropAdapter
extends DropTargetAdapter {
    private IWorkbenchWindow window;

    public EditorAreaDropAdapter(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
        dropTargetEvent.feedback = 0;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
        dropTargetEvent.feedback = 0;
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 1;
        dropTargetEvent.feedback = 0;
    }

    public void drop(final DropTargetEvent dropTargetEvent) {
        Display display = this.window.getShell().getDisplay();
        final IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
        if (iWorkbenchPage != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    EditorAreaDropAdapter.this.asyncDrop(dropTargetEvent, iWorkbenchPage);
                }
            });
        }
    }

    private void asyncDrop(DropTargetEvent dropTargetEvent, IWorkbenchPage iWorkbenchPage) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (!EditorInputTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) break block7;
                        Assert.isTrue((boolean)(dropTargetEvent.data instanceof EditorInputTransfer.EditorInputData[]));
                        EditorInputTransfer.EditorInputData[] editorInputDataArray = (EditorInputTransfer.EditorInputData[])dropTargetEvent.data;
                        int n = 0;
                        while (n < editorInputDataArray.length) {
                            IEditorInput iEditorInput = editorInputDataArray[n].input;
                            String string = editorInputDataArray[n].editorId;
                            this.openNonExternalEditor(iWorkbenchPage, iEditorInput, string);
                            ++n;
                        }
                        break block8;
                    }
                    if (!MarkerTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) break block9;
                    Assert.isTrue((boolean)(dropTargetEvent.data instanceof IMarker[]));
                    IMarker[] iMarkerArray = (IMarker[])dropTargetEvent.data;
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        this.openNonExternalEditor(iWorkbenchPage, iMarkerArray[n]);
                        ++n;
                    }
                    break block8;
                }
                if (!ResourceTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) break block10;
                Assert.isTrue((boolean)(dropTargetEvent.data instanceof IResource[]));
                IResource[] iResourceArray = (IResource[])dropTargetEvent.data;
                int n = 0;
                while (n < iResourceArray.length) {
                    IFile iFile;
                    if (iResourceArray[n] instanceof IFile && !(iFile = (IFile)iResourceArray[n]).isPhantom()) {
                        this.openNonExternalEditor(iWorkbenchPage, iFile);
                    }
                    ++n;
                }
                break block8;
            }
            if (!FileTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType)) break block8;
            Assert.isTrue((boolean)(dropTargetEvent.data instanceof String[]));
            String[] stringArray = (String[])dropTargetEvent.data;
            int n = 0;
            while (n < stringArray.length) {
                IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(stringArray[n]));
                try {
                    IDE.openEditorOnFileStore(iWorkbenchPage, iFileStore);
                }
                catch (PartInitException partInitException) {}
                ++n;
            }
        }
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage iWorkbenchPage, IFile iFile) {
        IEditorPart iEditorPart;
        try {
            IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor(iFile);
            if (iEditorDescriptor != null && !iEditorDescriptor.isOpenExternal()) {
                iEditorPart = IDE.openEditor(iWorkbenchPage, iFile, true);
            } else {
                IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor iEditorDescriptor2 = null;
                if (iEditorRegistry.isSystemInPlaceEditorAvailable(iFile.getName())) {
                    iEditorDescriptor2 = iEditorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
                }
                if (iEditorDescriptor2 == null) {
                    iEditorDescriptor2 = iEditorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor");
                }
                if (iEditorDescriptor2 == null) {
                    throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
                }
                iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor2.getId(), true);
            }
        }
        catch (PartInitException partInitException) {
            iEditorPart = null;
        }
        return iEditorPart;
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage iWorkbenchPage, IMarker iMarker) {
        IEditorPart iEditorPart;
        block7: {
            if (iMarker.getResource() instanceof IFile) break block7;
            return null;
        }
        try {
            IFile iFile = (IFile)iMarker.getResource();
            IEditorDescriptor iEditorDescriptor = null;
            try {
                String string = (String)iMarker.getAttribute("org.eclipse.ui.editorID");
                if (string != null) {
                    IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                    iEditorDescriptor = iEditorRegistry.findEditor(string);
                }
            }
            catch (CoreException coreException) {}
            if ((iEditorPart = iEditorDescriptor != null && !iEditorDescriptor.isOpenExternal() ? iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), iEditorDescriptor.getId(), true) : this.openNonExternalEditor(iWorkbenchPage, iFile)) != null) {
                IDE.gotoMarker(iEditorPart, iMarker);
            }
        }
        catch (PartInitException partInitException) {
            iEditorPart = null;
        }
        return iEditorPart;
    }

    private IEditorPart openNonExternalEditor(IWorkbenchPage iWorkbenchPage, IEditorInput iEditorInput, String string) {
        IEditorPart iEditorPart;
        try {
            IEditorRegistry iEditorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.findEditor(string);
            iEditorPart = iEditorDescriptor != null && !iEditorDescriptor.isOpenExternal() ? iWorkbenchPage.openEditor(iEditorInput, string) : null;
        }
        catch (PartInitException partInitException) {
            iEditorPart = null;
        }
        return iEditorPart;
    }
}

