/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;

public class FeatureSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private AboutInfo[] features;
    private ListViewer listViewer;
    private String helpContextId;

    public FeatureSelectionDialog(Shell shell, AboutInfo[] aboutInfoArray, String string, String string2, String string3, String string4) {
        super(shell);
        if (aboutInfoArray == null || aboutInfoArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.features = aboutInfoArray;
        this.helpContextId = string4;
        this.setTitle(string2);
        this.setMessage(string3);
        Arrays.sort(aboutInfoArray, new Comparator(){
            Collator coll = Collator.getInstance((Locale)Locale.getDefault());

            public int compare(Object object, Object object2) {
                AboutInfo aboutInfo = (AboutInfo)object;
                String string = aboutInfo.getFeatureLabel();
                AboutInfo aboutInfo2 = (AboutInfo)object2;
                String string2 = aboutInfo2.getFeatureLabel();
                if (string == null) {
                    string = "";
                }
                if (string2 == null) {
                    string2 = "";
                }
                return this.coll.compare(string, string2);
            }
        });
        int n = 0;
        while (n < aboutInfoArray.length) {
            if (aboutInfoArray[n].getFeatureId().equals(string)) {
                this.setInitialSelections(new Object[]{aboutInfoArray[n]});
                return;
            }
            ++n;
        }
        this.setInitialSelections(new Object[0]);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, this.helpContextId);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.createMessageArea(composite2);
        this.listViewer = new ListViewer(composite2, 2820);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)gridData);
        this.listViewer.getList().setFont(composite.getFont());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return object == null ? "" : ((AboutInfo)object).getFeatureLabel();
            }
        });
        SimpleListContentProvider simpleListContentProvider = new SimpleListContentProvider();
        simpleListContentProvider.setElements(this.features);
        this.listViewer.setContentProvider((IContentProvider)simpleListContentProvider);
        this.listViewer.setInput(new Object());
        this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                FeatureSelectionDialog.this.getOkButton().setEnabled(!selectionChangedEvent.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                FeatureSelectionDialog.this.okPressed();
            }
        });
        return composite2;
    }

    protected void okPressed() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(iStructuredSelection.toList());
        super.okPressed();
    }
}

