/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.statushandlers.StatusManager;

public class IDESelectionConversionService
implements ISelectionConversionService {
    public IStructuredSelection convertToResources(IStructuredSelection iStructuredSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            IResource iResource = ResourceUtil.getResource(e);
            if (iResource == null) {
                ResourceMapping resourceMapping = ResourceUtil.getResourceMapping(e);
                if (resourceMapping == null) continue;
                ResourceTraversal[] resourceTraversalArray = null;
                try {
                    resourceTraversalArray = resourceMapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    StatusManager.getManager().handle(coreException, "org.eclipse.ui.ide");
                }
                if (resourceTraversalArray == null) continue;
                ResourceTraversal resourceTraversal = null;
                IResource[] iResourceArray = null;
                int n = 0;
                while (n < resourceTraversalArray.length) {
                    resourceTraversal = resourceTraversalArray[n];
                    iResourceArray = resourceTraversal.getResources();
                    if (iResourceArray != null) {
                        int n2 = 0;
                        while (n2 < iResourceArray.length) {
                            arrayList.add(iResourceArray[n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
                continue;
            }
            arrayList.add(iResource);
        }
        if (arrayList.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(arrayList.toArray());
    }
}

