/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class IDEWorkbenchActivityHelper {
    private static final String NATURE_POINT = "org.eclipse.ui.ide.natures";
    private IResourceChangeListener listener;
    private Map natureMap;
    private final IDEWorkbenchActivityHelper lock;
    private WorkbenchJob fUpdateJob;
    private HashSet fPendingNatureUpdates = new HashSet();
    private static IDEWorkbenchActivityHelper singleton;

    public static IDEWorkbenchActivityHelper getInstance() {
        if (singleton == null) {
            singleton = new IDEWorkbenchActivityHelper();
        }
        return singleton;
    }

    private IDEWorkbenchActivityHelper() {
        this.lock = this;
        this.natureMap = new HashMap();
        Platform.getExtensionRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
                if (iRegistryChangeEvent.getExtensionDeltas("org.eclipse.core.resources", "natures").length > 0) {
                    IDEWorkbenchActivityHelper.this.loadNatures();
                }
            }
        }, "org.eclipse.core.resources");
        this.loadNatures();
        this.listener = this.getChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.processProjects(new HashSet<IProject>(Arrays.asList(iProjectArray)));
    }

    public void loadNatures() {
        this.natureMap.clear();
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources.natures");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            final String string = iExtension.getSimpleIdentifier();
            final String string2 = iExtension.getNamespaceIdentifier();
            String string3 = iExtension.getUniqueIdentifier();
            this.natureMap.put(string3, new IPluginContribution(){

                public String getLocalId() {
                    return string;
                }

                public String getPluginId() {
                    return string2;
                }
            });
            ++n;
        }
    }

    private IResourceChangeListener getChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                if (!WorkbenchActivityHelper.isFiltering()) {
                    return;
                }
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta == null) {
                    return;
                }
                if (iResourceDelta.getKind() == 4 && iResourceDelta.getResource().getType() == 8) {
                    IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                    HashSet<IProject> hashSet = new HashSet<IProject>();
                    int n = 0;
                    while (n < iResourceDeltaArray.length) {
                        IProject iProject;
                        IResourceDelta iResourceDelta2 = iResourceDeltaArray[n];
                        if (iResourceDelta2.getResource().getType() == 4 && (iProject = (IProject)iResourceDelta2.getResource()).isOpen()) {
                            hashSet.add(iProject);
                        }
                        ++n;
                    }
                    IDEWorkbenchActivityHelper.this.processProjects(hashSet);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPendingUpdates() {
        String[] stringArray = null;
        IDEWorkbenchActivityHelper iDEWorkbenchActivityHelper = this.lock;
        synchronized (iDEWorkbenchActivityHelper) {
            stringArray = this.fPendingNatureUpdates.toArray(new String[this.fPendingNatureUpdates.size()]);
            this.fPendingNatureUpdates.clear();
        }
        iDEWorkbenchActivityHelper = PlatformUI.getWorkbench().getActivitySupport();
        int n = 0;
        while (n < stringArray.length) {
            IPluginContribution iPluginContribution = (IPluginContribution)this.natureMap.get(stringArray[n]);
            if (iPluginContribution != null) {
                ITriggerPoint iTriggerPoint = iDEWorkbenchActivityHelper.getTriggerPointManager().getTriggerPoint(NATURE_POINT);
                WorkbenchActivityHelper.allowUseOf((ITriggerPoint)iTriggerPoint, (Object)iPluginContribution);
            }
            ++n;
        }
    }

    public void shutdown() {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processProjects(Set set) {
        boolean bl = false;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                IProject iProject = (IProject)iterator.next();
                String[] stringArray = iProject.getDescription().getNatureIds();
                if (stringArray.length == 0) continue;
                IDEWorkbenchActivityHelper iDEWorkbenchActivityHelper = this.lock;
                synchronized (iDEWorkbenchActivityHelper) {
                    bl = this.fPendingNatureUpdates.addAll(Arrays.asList(stringArray)) | bl;
                }
            }
            catch (CoreException coreException) {}
        }
        if (bl) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new WorkbenchJob(IDEWorkbenchMessages.IDEWorkbenchActivityHelper_jobName){

                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                        IDEWorkbenchActivityHelper.this.runPendingUpdates();
                        return Status.OK_STATUS;
                    }
                };
                this.fUpdateJob.setSystem(true);
            }
            this.fUpdateJob.schedule();
        }
    }
}

