/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.ide.dialogs.InternalErrorDialog;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.WorkbenchErrorHandler;

public class IDEWorkbenchErrorHandler
extends WorkbenchErrorHandler {
    private int exceptionCount = 0;
    private static FatalErrorDialog dialog;
    private boolean closing = false;
    private IWorkbenchConfigurer workbenchConfigurer;
    private static String MSG_OutOfMemoryError;
    private static String MSG_StackOverflowError;
    private static String MSG_VirtualMachineError;
    private static String MSG_SWTError;
    private static String MSG_FATAL_ERROR;
    private static String MSG_FATAL_ERROR_Recursive;
    private static String MSG_FATAL_ERROR_Title;
    private final Map map = Collections.synchronizedMap(new WeakHashMap());

    static {
        MSG_OutOfMemoryError = IDEWorkbenchMessages.FatalError_OutOfMemoryError;
        MSG_StackOverflowError = IDEWorkbenchMessages.FatalError_StackOverflowError;
        MSG_VirtualMachineError = IDEWorkbenchMessages.FatalError_VirtualMachineError;
        MSG_SWTError = IDEWorkbenchMessages.FatalError_SWTError;
        MSG_FATAL_ERROR = IDEWorkbenchMessages.FatalError;
        MSG_FATAL_ERROR_Recursive = IDEWorkbenchMessages.FatalError_RecursiveError;
        MSG_FATAL_ERROR_Title = IDEWorkbenchMessages.InternalError;
    }

    public IDEWorkbenchErrorHandler(IWorkbenchConfigurer iWorkbenchConfigurer) {
        this.workbenchConfigurer = iWorkbenchConfigurer;
    }

    public void handle(final StatusAdapter statusAdapter, int n) {
        if (this.isFatal(statusAdapter)) {
            if (this.map.containsKey(statusAdapter.getStatus())) {
                return;
            }
            this.map.put(statusAdapter.getStatus(), null);
            if (statusAdapter.getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) == Boolean.TRUE) {
                statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.FALSE);
            }
            super.handle(statusAdapter, n | 4);
        } else {
            super.handle(statusAdapter, n);
        }
        if (this.isFatal(statusAdapter)) {
            UIJob uIJob = new UIJob("IDE Exception Handler"){

                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                    IDEWorkbenchErrorHandler.this.handleException(statusAdapter.getStatus().getException());
                    return new Status(0, "org.eclipse.ui.ide", IDEWorkbenchMessages.IDEExceptionHandler_ExceptionHandledMessage);
                }
            };
            uIJob.setSystem(true);
            uIJob.schedule();
        }
    }

    private boolean isFatal(StatusAdapter statusAdapter) {
        return statusAdapter.getStatus().getException() != null && (statusAdapter.getStatus().getException() instanceof OutOfMemoryError || statusAdapter.getStatus().getException() instanceof StackOverflowError || statusAdapter.getStatus().getException() instanceof VirtualMachineError || statusAdapter.getStatus().getException() instanceof SWTError);
    }

    private void handleException(Throwable throwable) {
        try {
            ++this.exceptionCount;
            if (this.exceptionCount > 1) {
                dialog.updateMessage(MessageFormat.format((String)MSG_FATAL_ERROR, (Object[])new Object[]{MSG_FATAL_ERROR_Recursive}));
                dialog.getShell().forceActive();
            } else if (this.openQuestionDialog(throwable)) {
                this.closeWorkbench();
            }
        }
        finally {
            --this.exceptionCount;
        }
    }

    private boolean openQuestionDialog(Throwable throwable) {
        try {
            String string = null;
            string = throwable instanceof OutOfMemoryError ? MSG_OutOfMemoryError : (throwable instanceof StackOverflowError ? MSG_StackOverflowError : (throwable instanceof VirtualMachineError ? MSG_VirtualMachineError : (throwable instanceof SWTError ? MSG_SWTError : (throwable.getMessage() == null ? IDEWorkbenchMessages.InternalErrorNoArg : NLS.bind((String)IDEWorkbenchMessages.InternalErrorOneArg, (Object)throwable.getMessage())))));
            Throwable throwable2 = throwable;
            if (!Policy.DEBUG_OPEN_ERROR_DIALOG) {
                throwable2 = null;
            }
            return (dialog = this.openInternalQuestionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MSG_FATAL_ERROR_Title, MessageFormat.format((String)MSG_FATAL_ERROR, (Object[])new Object[]{string}), throwable2, 1)).open() == 0;
        }
        catch (Throwable throwable3) {
            System.err.println("Error while informing user about event loop exception:");
            throwable.printStackTrace();
            System.err.println("Dialog open exception:");
            throwable3.printStackTrace();
            return true;
        }
    }

    private FatalErrorDialog openInternalQuestionDialog(Shell shell, String string, String string2, Throwable throwable, int n) {
        String[] stringArray = throwable == null ? new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL} : new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.SHOW_DETAILS_LABEL};
        FatalErrorDialog fatalErrorDialog = new FatalErrorDialog(shell, string, null, string2, throwable, 3, stringArray, n);
        if (throwable != null) {
            fatalErrorDialog.setDetailButton(2);
        }
        return fatalErrorDialog;
    }

    private void closeWorkbench() {
        if (this.closing) {
            return;
        }
        try {
            this.closing = true;
            if (dialog != null && dialog.getShell() != null && !dialog.getShell().isDisposed()) {
                dialog.close();
            }
            if (this.workbenchConfigurer != null) {
                this.workbenchConfigurer.emergencyClose();
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Fatal runtime error happened during workbench emergency close.");
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Error error) {
            System.err.println("Fatal error happened during workbench emergency close.");
            error.printStackTrace();
            throw error;
        }
    }

    private class FatalErrorDialog
    extends InternalErrorDialog {
        public FatalErrorDialog(Shell shell, String string, Image image, String string2, Throwable throwable, int n, String[] stringArray, int n2) {
            super(shell, string, image, string2, throwable, n, stringArray, n2);
        }

        public void updateMessage(String string) {
            this.message = string;
            this.messageLabel.setText(string);
            this.messageLabel.update();
        }
    }
}

