/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class IDEWorkbenchPlugin
extends AbstractUIPlugin {
    private static IDEWorkbenchPlugin inst;
    public static boolean DEBUG;
    public static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PL_MARKER_IMAGE_PROVIDER = "markerImageProviders";
    public static final String PL_MARKER_HELP = "markerHelp";
    public static final String PL_MARKER_RESOLUTION = "markerResolution";
    public static final String PL_CAPABILITIES = "capabilities";
    public static final String PL_PROJECT_NATURE_IMAGES = "projectNatureImages";
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private ProjectImageRegistry projectImageRegistry = null;
    private MarkerImageProviderRegistry markerImageProviderRegistry = null;
    private ResourceManager resourceManager;

    static {
        DEBUG = false;
    }

    public IDEWorkbenchPlugin() {
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        Bundle bundle = Platform.getBundle((String)iConfigurationElement.getNamespace());
        if (bundle.getState() == 32) {
            return iConfigurationElement.createExecutableExtension(string);
        }
        final Object[] objectArray = new Object[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return objectArray[0];
    }

    public static IDEWorkbenchPlugin getDefault() {
        return inst;
    }

    public static IWorkspace getPluginWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(String string) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
    }

    public static void log(String string, Throwable throwable) {
        IStatus iStatus = StatusUtil.newStatus(4, string, throwable);
        IDEWorkbenchPlugin.log(string, iStatus);
    }

    public static void log(Class clazz, String string, Throwable throwable) {
        String string2 = MessageFormat.format((String)"Exception in {0}.{1}: {2}", (Object[])new Object[]{clazz.getName(), string, throwable});
        IDEWorkbenchPlugin.log(string2, throwable);
    }

    public static void log(String string, IStatus iStatus) {
        if (string != null) {
            IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, string, null));
        }
        IDEWorkbenchPlugin.getDefault().getLog().log(iStatus);
    }

    protected void refreshPluginActions() {
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public AboutInfo[] getFeatureInfos() {
        ArrayList<AboutInfo> arrayList = new ArrayList<AboutInfo>();
        IBundleGroupProvider[] iBundleGroupProviderArray = Platform.getBundleGroupProviders();
        if (iBundleGroupProviderArray != null) {
            int n = 0;
            while (n < iBundleGroupProviderArray.length) {
                IBundleGroup[] iBundleGroupArray = iBundleGroupProviderArray[n].getBundleGroups();
                int n2 = 0;
                while (n2 < iBundleGroupArray.length) {
                    arrayList.add(new AboutInfo(iBundleGroupArray[n2]));
                    ++n2;
                }
                ++n;
            }
        }
        return arrayList.toArray(new AboutInfo[arrayList.size()]);
    }

    public AboutInfo getPrimaryInfo() {
        IProduct iProduct = Platform.getProduct();
        return iProduct == null ? null : new AboutInfo(iProduct);
    }

    public static ImageDescriptor getIDEImageDescriptor(String string) {
        return IDEWorkbenchPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH, (String)(ICONS_PATH + string));
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.update.configurator");
        if (bundle != null) {
            try {
                bundle.start(1);
            }
            catch (BundleException bundleException) {}
        }
    }
}

