/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class LineDelimiterEditor {
    private Button defaultButton;
    private Button otherButton;
    private Combo choiceCombo;
    private IProject project;
    private Group group;

    public LineDelimiterEditor(Composite composite) {
        this(composite, null);
    }

    public LineDelimiterEditor(Composite composite, IProject iProject) {
        this.project = iProject;
        this.createControl(composite);
    }

    protected void createControl(Composite composite) {
        Font font = composite.getFont();
        this.group = new Group(composite, 0);
        GridData gridData = new GridData(768);
        this.group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.group.setLayout((Layout)gridLayout);
        this.group.setText(IDEWorkbenchMessages.IDEWorkspacePreference_fileLineDelimiter);
        this.group.setFont(font);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (selectionEvent.widget.equals(LineDelimiterEditor.this.defaultButton)) {
                    LineDelimiterEditor.this.updateState(true);
                } else {
                    LineDelimiterEditor.this.updateState(false);
                }
            }
        };
        this.defaultButton = new Button((Composite)this.group, 16);
        if (this.project == null) {
            this.defaultButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelim);
        } else {
            this.defaultButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_defaultLineDelimProj);
        }
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.defaultButton.setLayoutData((Object)gridData);
        this.defaultButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.defaultButton.setFont(font);
        this.otherButton = new Button((Composite)this.group, 16);
        this.otherButton.setText(IDEWorkbenchMessages.IDEWorkspacePreference_otherLineDelim);
        this.otherButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.otherButton.setFont(font);
        this.choiceCombo = new Combo((Composite)this.group, 8);
        gridData = new GridData();
        this.choiceCombo.setFont(font);
        this.choiceCombo.setLayoutData((Object)gridData);
        this.populateChoiceCombo(this.getChoices());
    }

    public void doLoad() {
        if (this.choiceCombo != null) {
            this.populateChoiceCombo(this.getChoices());
            String string = this.getStoredValue();
            this.updateState(string == null);
        }
    }

    public void loadDefault() {
        if (this.choiceCombo != null) {
            this.updateState(true);
        }
    }

    public String getStoredValue() {
        IScopeContext[] iScopeContextArray = new IScopeContext[]{this.getScopeContext()};
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode("org.eclipse.core.runtime");
        return iEclipsePreferences.get("line.separator", null);
    }

    private IScopeContext getScopeContext() {
        if (this.project != null) {
            return new ProjectScope(this.project);
        }
        return new InstanceScope();
    }

    protected String[] getChoices() {
        Set set = Platform.knownPlatformLineSeparators().keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    private void populateChoiceCombo(String[] stringArray) {
        this.choiceCombo.setItems(stringArray);
        if (this.getStoredValue() == null) {
            this.choiceCombo.setText("");
        } else {
            this.selectChoice();
        }
    }

    private void updateState(boolean bl) {
        if (bl) {
            this.defaultButton.setSelection(true);
            this.otherButton.setSelection(false);
            this.choiceCombo.setEnabled(false);
        } else {
            this.defaultButton.setSelection(false);
            this.otherButton.setSelection(true);
            this.choiceCombo.setEnabled(true);
            this.selectChoice();
        }
    }

    private void selectChoice() {
        String[] stringArray;
        String string = null;
        Map map = Platform.knownPlatformLineSeparators();
        Set set = map.keySet();
        String string2 = this.getStoredValue();
        if (string2 != null) {
            stringArray = set.iterator();
            while (stringArray.hasNext()) {
                String string3 = (String)stringArray.next();
                if (!map.get(string3).equals(string2)) continue;
                string = string3;
                break;
            }
        }
        stringArray = this.choiceCombo.getItems();
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string4.equals(string)) {
                this.choiceCombo.select(n);
                break;
            }
            ++n;
        }
    }

    public void store() {
        Map map;
        String string;
        if (this.defaultButton.getSelection() || this.choiceCombo.getText().equals("")) {
            string = null;
        } else {
            map = Platform.knownPlatformLineSeparators();
            string = (String)map.get(this.choiceCombo.getText());
        }
        map = this.getScopeContext().getNode("org.eclipse.core.runtime");
        if (string == null) {
            map.remove("line.separator");
        } else {
            map.put("line.separator", string);
        }
        try {
            map.flush();
        }
        catch (BackingStoreException backingStoreException) {
            IDEWorkbenchPlugin.log(backingStoreException.getMessage(), backingStoreException);
        }
    }

    public void setEnabled(boolean bl) {
        this.group.setEnabled(bl);
        Control[] controlArray = this.group.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }
}

