/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LinkedResourceDecorator
implements ILightweightLabelDecorator {
    private static final ImageDescriptor LINK = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/link_ovr.gif");
    private static final ImageDescriptor LINK_WARNING = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui.ide", (String)"$nl$/icons/full/ovr16/linkwarn_ovr.gif");

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        if (!(object instanceof IResource)) {
            return;
        }
        IResource iResource = (IResource)object;
        if (iResource.isLinked() && !iResource.isGroup()) {
            IFileInfo iFileInfo = null;
            URI uRI = iResource.getLocationURI();
            if (uRI != null) {
                iFileInfo = IDEResourceInfoUtils.getFileInfo(uRI);
            }
            if (iFileInfo != null && iFileInfo.exists()) {
                iDecoration.addOverlay(LINK);
            } else {
                iDecoration.addOverlay(LINK_WARNING);
            }
        }
    }
}

