/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class ResourceWorkingSetUpdater
implements IWorkingSetUpdater,
IResourceChangeListener {
    private List fWorkingSets = new ArrayList();

    public ResourceWorkingSetUpdater() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet iWorkingSet) {
        this.checkElementExistence(iWorkingSet);
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(iWorkingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet iWorkingSet) {
        boolean bl;
        List list = this.fWorkingSets;
        synchronized (list) {
            bl = this.fWorkingSets.remove(iWorkingSet);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet iWorkingSet) {
        List list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(iWorkingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IWorkingSet[] iWorkingSetArray;
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        List list = this.fWorkingSets;
        synchronized (list) {
            iWorkingSetArray = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        int n = 0;
        while (n < iWorkingSetArray.length) {
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(iWorkingSetArray[n]);
            this.processResourceDelta(workingSetDelta, iResourceDelta);
            workingSetDelta.process();
            ++n;
        }
    }

    private void processResourceDelta(WorkingSetDelta workingSetDelta, IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        int n = iResource.getType();
        int n2 = workingSetDelta.indexOf(iResource);
        int n3 = iResourceDelta.getKind();
        int n4 = iResourceDelta.getFlags();
        if (n3 == 4 && n == 4 && n2 != -1 && (n4 & 0x4000) != 0) {
            workingSetDelta.set(n2, iResource);
        }
        if (n2 != -1 && n3 == 2) {
            if ((n4 & 0x2000) != 0) {
                workingSetDelta.set(n2, ResourcesPlugin.getWorkspace().getRoot().findMember(iResourceDelta.getMovedToPath()));
            } else {
                workingSetDelta.remove(n2);
            }
        }
        if (this.projectGotClosedOrOpened(iResource, n3, n4)) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        int n5 = 0;
        while (n5 < iResourceDeltaArray.length) {
            this.processResourceDelta(workingSetDelta, iResourceDeltaArray[n5]);
            ++n5;
        }
    }

    private boolean projectGotClosedOrOpened(IResource iResource, int n, int n2) {
        return iResource.getType() == 4 && n == 4 && (n2 & 0x4000) != 0;
    }

    private void checkElementExistence(IWorkingSet iWorkingSet) {
        ArrayList<IAdaptable> arrayList = new ArrayList<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IAdaptable iAdaptable = (IAdaptable)iterator.next();
            boolean bl2 = false;
            if (iAdaptable instanceof IResource) {
                IResource iResource = (IResource)iAdaptable;
                IProject iProject = iResource.getProject();
                boolean bl3 = bl2 = (iProject == null || iProject.isOpen()) && !iResource.exists();
            }
            if (!bl2) continue;
            iterator.remove();
            bl = true;
        }
        if (bl) {
            iWorkingSet.setElements(arrayList.toArray(new IAdaptable[arrayList.size()]));
        }
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet iWorkingSet) {
            this.fWorkingSet = iWorkingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(iWorkingSet.getElements()));
        }

        public int indexOf(Object object) {
            return this.fElements.indexOf(object);
        }

        public void set(int n, Object object) {
            this.fElements.set(n, object);
            this.fChanged = true;
        }

        public void remove(int n) {
            if (this.fElements.remove(n) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

