/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.FeatureSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class TipsAndTricksAction
extends PartEventAction
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public TipsAndTricksAction(IWorkbenchWindow iWorkbenchWindow) {
        super(IDEWorkbenchMessages.TipsAndTricks_text);
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = iWorkbenchWindow;
        this.setToolTipText(IDEWorkbenchMessages.TipsAndTricks_toolTip);
        iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.tips_and_tricks_action_context");
        this.setActionDefinitionId("org.eclipse.ui.help.tipsAndTricksAction");
        this.workbenchWindow.getPartService().addPartListener((IPartListener)this);
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        AboutInfo[] aboutInfoArray = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
        ArrayList<AboutInfo> arrayList = new ArrayList<AboutInfo>(aboutInfoArray.length);
        int n = 0;
        while (n < aboutInfoArray.length) {
            if (aboutInfoArray[n].getTipsAndTricksHref() != null) {
                arrayList.add(aboutInfoArray[n]);
            }
            ++n;
        }
        Shell shell = this.workbenchWindow.getShell();
        if (arrayList.size() == 0) {
            MessageDialog.openInformation((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksMessageDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksMessageDialog_message);
            return;
        }
        AboutInfo[] aboutInfoArray2 = new AboutInfo[arrayList.size()];
        arrayList.toArray(aboutInfoArray2);
        IProduct iProduct = Platform.getProduct();
        FeatureSelectionDialog featureSelectionDialog = new FeatureSelectionDialog(shell, aboutInfoArray2, iProduct == null ? null : iProduct.getId(), IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_title, IDEWorkbenchMessages.TipsAndTricksPageSelectionDialog_message, "org.eclipse.ui.ide.tips_and_tricks_page_selection_dialog");
        featureSelectionDialog.create();
        featureSelectionDialog.getOkButton().setEnabled(false);
        if (featureSelectionDialog.open() != 0 || featureSelectionDialog.getResult().length != 1) {
            return;
        }
        AboutInfo aboutInfo = (AboutInfo)featureSelectionDialog.getResult()[0];
        if (aboutInfo != null) {
            final String string = aboutInfo.getTipsAndTricksHref();
            if (string != null) {
                BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        TipsAndTricksAction.this.workbenchWindow.getWorkbench().getHelpSystem().displayHelpResource(string);
                    }
                });
            } else {
                Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
                ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, (IStatus)status);
            }
        } else {
            Status status = new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.TipsAndTricksErrorDialog_noHref, null);
            ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_title, (String)IDEWorkbenchMessages.TipsAndTricksErrorDialog_noFeatures, (IStatus)status);
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow.getPartService().removePartListener((IPartListener)this);
        this.workbenchWindow = null;
    }
}

