/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildSetMenu;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.actions.QuickMenuAction;
import org.eclipse.ui.internal.ide.actions.RetargetActionWithDefault;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public final class WorkbenchActionBuilder
extends ActionBarAdvisor {
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction closeAllSavedAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction newWindowAction;
    private ActionFactory.IWorkbenchAction newEditorAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction hideShowEditorAction;
    private ActionFactory.IWorkbenchAction savePerspectiveAction;
    private ActionFactory.IWorkbenchAction resetPerspectiveAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction closePerspAction;
    private ActionFactory.IWorkbenchAction lockToolBarAction;
    private ActionFactory.IWorkbenchAction closeAllPerspsAction;
    private ActionFactory.IWorkbenchAction showViewMenuAction;
    private ActionFactory.IWorkbenchAction showPartPaneMenuAction;
    private ActionFactory.IWorkbenchAction nextPartAction;
    private ActionFactory.IWorkbenchAction prevPartAction;
    private ActionFactory.IWorkbenchAction nextEditorAction;
    private ActionFactory.IWorkbenchAction prevEditorAction;
    private ActionFactory.IWorkbenchAction nextPerspectiveAction;
    private ActionFactory.IWorkbenchAction prevPerspectiveAction;
    private ActionFactory.IWorkbenchAction activateEditorAction;
    private ActionFactory.IWorkbenchAction maximizePartAction;
    private ActionFactory.IWorkbenchAction minimizePartAction;
    private ActionFactory.IWorkbenchAction switchToEditorAction;
    private ActionFactory.IWorkbenchAction workbookEditorsAction;
    private ActionFactory.IWorkbenchAction quickAccessAction;
    private ActionFactory.IWorkbenchAction backwardHistoryAction;
    private ActionFactory.IWorkbenchAction forwardHistoryAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction goIntoAction;
    private ActionFactory.IWorkbenchAction backAction;
    private ActionFactory.IWorkbenchAction forwardAction;
    private ActionFactory.IWorkbenchAction upAction;
    private ActionFactory.IWorkbenchAction nextAction;
    private ActionFactory.IWorkbenchAction previousAction;
    private ActionFactory.IWorkbenchAction openWorkspaceAction;
    private ActionFactory.IWorkbenchAction projectPropertyDialogAction;
    private ActionFactory.IWorkbenchAction newWizardAction;
    private ActionFactory.IWorkbenchAction newWizardDropDownAction;
    private ActionFactory.IWorkbenchAction importResourcesAction;
    private ActionFactory.IWorkbenchAction exportResourcesAction;
    ActionFactory.IWorkbenchAction buildAllAction;
    private ActionFactory.IWorkbenchAction cleanAction;
    private ActionFactory.IWorkbenchAction toggleAutoBuildAction;
    MenuManager buildWorkingSetMenu;
    private ActionFactory.IWorkbenchAction quickStartAction;
    private ActionFactory.IWorkbenchAction tipsAndTricksAction;
    private QuickMenuAction showInQuickMenu;
    private QuickMenuAction newQuickMenu;
    private ActionFactory.IWorkbenchAction introAction;
    ActionFactory.IWorkbenchAction buildProjectAction;
    private NewWizardMenu newWizardMenu;
    private IContributionItem pinEditorContributionItem;
    private StatusLineContributionItem statusLineItem;
    private Preferences.IPropertyChangeListener prefListener;
    private IPropertyChangeListener propPrefListener;
    private IPageListener pageListener;
    private IResourceChangeListener resourceListener;
    private boolean isDisposed = false;
    private MenuManager coolbarPopupMenuManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkbenchActionBuilder(IActionBarConfigurer iActionBarConfigurer) {
        super(iActionBarConfigurer);
        this.window = iActionBarConfigurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    private void hookListeners() {
        this.pageListener = new IPageListener(){

            public void pageActivated(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageClosed(IWorkbenchPage iWorkbenchPage) {
            }

            public void pageOpened(IWorkbenchPage iWorkbenchPage) {
                BuildAction buildAction = new BuildAction((IShellProvider)iWorkbenchPage.getWorkbenchWindow(), 10);
                ((RetargetActionWithDefault)WorkbenchActionBuilder.this.buildProjectAction).setDefaultHandler((IAction)buildAction);
            }
        };
        this.getWindow().addPageListener(this.pageListener);
        this.prefListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("description.autobuilding")) {
                    WorkbenchActionBuilder.this.updateBuildActions(false);
                }
            }
        };
        ResourcesPlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.prefListener);
        this.propPrefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("REUSE_OPEN_EDITORS_BOOLEAN") && WorkbenchActionBuilder.this.window.getShell() != null && !WorkbenchActionBuilder.this.window.getShell().isDisposed()) {
                    WorkbenchActionBuilder.this.window.getShell().getDisplay().syncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            3.access$0(this.this$1).updatePinActionToolbar();
                        }
                    });
                }
            }

            static /* synthetic */ WorkbenchActionBuilder access$0(3 var0) {
                return var0.WorkbenchActionBuilder.this;
            }
        };
        WorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propPrefListener);
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta == null) {
                    return;
                }
                IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
                int n = 0;
                while (n < iResourceDeltaArray.length) {
                    boolean bl;
                    int n2 = iResourceDeltaArray[n].getKind();
                    boolean bl2 = bl = (iResourceDeltaArray[n].getFlags() & 0x84000) != 0;
                    if (n2 != 4 || bl) {
                        WorkbenchActionBuilder.this.updateBuildActions(false);
                        return;
                    }
                    ++n;
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 1);
    }

    public void fillActionBars(int n) {
        super.fillActionBars(n);
        if ((n & 1) == 0) {
            this.updateBuildActions(true);
            this.hookListeners();
        }
    }

    protected void fillCoolBar(ICoolBarManager iCoolBarManager) {
        IActionBarConfigurer2 iActionBarConfigurer2 = (IActionBarConfigurer2)this.getActionBarConfigurer();
        this.coolbarPopupMenuManager = new MenuManager();
        this.coolbarPopupMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.lockToolBarAction));
        this.coolbarPopupMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.editActionSetAction));
        iCoolBarManager.setContextMenuManager((IMenuManager)this.coolbarPopupMenuManager);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService iMenuService = (IMenuService)this.window.getService((Class)clazz);
        iMenuService.populateContributionManager((ContributionManager)this.coolbarPopupMenuManager, "popup:windowCoolbarContextMenu");
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.file"));
        iMenuService = iActionBarConfigurer2.createToolBarManager();
        iMenuService.add((IContributionItem)new Separator("new.group"));
        iMenuService.add((IAction)this.newWizardDropDownAction);
        iMenuService.add((IContributionItem)new GroupMarker("new.ext"));
        iMenuService.add((IContributionItem)new GroupMarker("save.group"));
        iMenuService.add((IAction)this.saveAction);
        iMenuService.add((IContributionItem)new GroupMarker("save.ext"));
        iMenuService.add(this.getPrintItem());
        iMenuService.add((IContributionItem)new GroupMarker("print.ext"));
        iMenuService.add((IContributionItem)new Separator("build.group"));
        iMenuService.add((IContributionItem)new GroupMarker("build.ext"));
        iMenuService.add((IContributionItem)new Separator("additions"));
        iCoolBarManager.add((IContributionItem)iActionBarConfigurer2.createToolBarContributionItem((IToolBarManager)iMenuService, "org.eclipse.ui.workbench.file"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("additions"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.nav"));
        iMenuService = iActionBarConfigurer2.createToolBarManager();
        iMenuService.add((IContributionItem)new Separator("history.group"));
        iMenuService.add((IContributionItem)new GroupMarker("group.application"));
        iMenuService.add((IAction)this.backwardHistoryAction);
        iMenuService.add((IAction)this.forwardHistoryAction);
        iMenuService.add((IContributionItem)new Separator("pin.group"));
        iMenuService.add(this.pinEditorContributionItem);
        iCoolBarManager.add((IContributionItem)iActionBarConfigurer2.createToolBarContributionItem((IToolBarManager)iMenuService, "org.eclipse.ui.workbench.navigate"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.editor"));
        iCoolBarManager.add((IContributionItem)new GroupMarker("group.help"));
        iMenuService = iActionBarConfigurer2.createToolBarManager();
        iMenuService.add((IContributionItem)new Separator("group.help"));
        iMenuService.add((IContributionItem)new GroupMarker("group.application"));
        iCoolBarManager.add((IContributionItem)iActionBarConfigurer2.createToolBarContributionItem((IToolBarManager)iMenuService, "org.eclipse.ui.workbench.help"));
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)this.createFileMenu());
        iMenuManager.add((IContributionItem)this.createEditMenu());
        iMenuManager.add((IContributionItem)this.createNavigateMenu());
        iMenuManager.add((IContributionItem)this.createProjectMenu());
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
        iMenuManager.add((IContributionItem)this.createWindowMenu());
        iMenuManager.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_file, "file");
        menuManager.add((IContributionItem)new GroupMarker("fileStart"));
        String string = IDEWorkbenchMessages.Workbench_new;
        String string2 = ActionFactory.NEW.getId();
        MenuManager menuManager2 = new MenuManager(string, string2);
        menuManager2.setActionDefinitionId("org.eclipse.ui.file.newQuickMenu");
        menuManager2.add((IContributionItem)new Separator(string2));
        this.newWizardMenu = new NewWizardMenu(this.getWindow());
        menuManager2.add((IContributionItem)this.newWizardMenu);
        menuManager2.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)menuManager2);
        menuManager.add((IContributionItem)new GroupMarker("new.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.closeAction);
        menuManager.add((IAction)this.closeAllAction);
        menuManager.add((IContributionItem)new GroupMarker("close.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.saveAction);
        menuManager.add((IAction)this.saveAsAction);
        menuManager.add((IAction)this.saveAllAction);
        menuManager.add(this.getRevertItem());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getMoveItem());
        menuManager.add(this.getRenameItem());
        menuManager.add(this.getRefreshItem());
        menuManager.add((IContributionItem)new GroupMarker("save.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getPrintItem());
        menuManager.add((IContributionItem)new GroupMarker("print.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openWorkspaceAction);
        menuManager.add((IContributionItem)new GroupMarker("open.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.importResourcesAction);
        menuManager.add((IAction)this.exportResourcesAction);
        menuManager.add((IContributionItem)new GroupMarker("import.ext"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getPropertiesItem());
        menuManager.add(ContributionItemFactory.REOPEN_EDITORS.create(this.getWindow()));
        menuManager.add((IContributionItem)new GroupMarker("mru"));
        menuManager.add((IContributionItem)new Separator());
        string = new ActionContributionItem((IAction)this.quitAction);
        string.setVisible(!Util.isMac());
        menuManager.add((IContributionItem)string);
        menuManager.add((IContributionItem)new GroupMarker("fileEnd"));
        return menuManager;
    }

    private MenuManager createEditMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_edit, "edit");
        menuManager.add((IContributionItem)new GroupMarker("editStart"));
        menuManager.add((IAction)this.undoAction);
        menuManager.add((IAction)this.redoAction);
        menuManager.add((IContributionItem)new GroupMarker("undo.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getCutItem());
        menuManager.add(this.getCopyItem());
        menuManager.add(this.getPasteItem());
        menuManager.add((IContributionItem)new GroupMarker("cut.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getDeleteItem());
        menuManager.add(this.getSelectAllItem());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getFindItem());
        menuManager.add((IContributionItem)new GroupMarker("find.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.getBookmarkItem());
        menuManager.add(this.getTaskItem());
        menuManager.add((IContributionItem)new GroupMarker("add.ext"));
        menuManager.add((IContributionItem)new GroupMarker("editEnd"));
        menuManager.add((IContributionItem)new Separator("additions"));
        return menuManager;
    }

    private MenuManager createNavigateMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_navigate, "navigate");
        menuManager.add((IContributionItem)new GroupMarker("navStart"));
        menuManager.add((IAction)this.goIntoAction);
        MenuManager menuManager2 = new MenuManager(IDEWorkbenchMessages.Workbench_goTo, "goTo");
        menuManager.add((IContributionItem)menuManager2);
        menuManager2.add((IAction)this.backAction);
        menuManager2.add((IAction)this.forwardAction);
        menuManager2.add((IAction)this.upAction);
        menuManager2.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("open.ext"));
        int n = 2;
        while (n < 5) {
            menuManager.add((IContributionItem)new Separator("open.ext" + n));
            ++n;
        }
        menuManager.add((IContributionItem)new Separator("show.ext"));
        MenuManager menuManager3 = new MenuManager(IDEWorkbenchMessages.Workbench_showIn, "showIn");
        menuManager3.setActionDefinitionId(this.showInQuickMenu.getActionDefinitionId());
        menuManager3.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getWindow()));
        menuManager.add((IContributionItem)menuManager3);
        int n2 = 2;
        while (n2 < 5) {
            menuManager.add((IContributionItem)new Separator("show.ext" + n2));
            ++n2;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.nextAction);
        menuManager.add((IAction)this.previousAction);
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new GroupMarker("navEnd"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.backwardHistoryAction);
        menuManager.add((IAction)this.forwardHistoryAction);
        return menuManager;
    }

    private MenuManager createProjectMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_project, "project");
        menuManager.add((IContributionItem)new Separator("projStart"));
        menuManager.add(this.getOpenProjectItem());
        menuManager.add(this.getCloseProjectItem());
        menuManager.add((IContributionItem)new GroupMarker("open.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.buildAllAction);
        menuManager.add((IAction)this.buildProjectAction);
        this.addWorkingSetBuildActions(menuManager);
        menuManager.add((IAction)this.cleanAction);
        menuManager.add((IAction)this.toggleAutoBuildAction);
        menuManager.add((IContributionItem)new GroupMarker("build.ext"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        menuManager.add((IContributionItem)new GroupMarker("projEnd"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.projectPropertyDialogAction);
        return menuManager;
    }

    private MenuManager createWindowMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_window, "window");
        menuManager.add((IAction)this.newWindowAction);
        menuManager.add((IAction)this.newEditorAction);
        menuManager.add((IContributionItem)new Separator());
        this.addPerspectiveActions(menuManager);
        menuManager.add((IContributionItem)new Separator());
        this.addKeyboardShortcuts(menuManager);
        Separator separator = new Separator("additions");
        separator.setVisible(!Util.isMac());
        menuManager.add((IContributionItem)separator);
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        actionContributionItem.setVisible(!Util.isMac());
        menuManager.add((IContributionItem)actionContributionItem);
        menuManager.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menuManager;
    }

    private void addPerspectiveActions(MenuManager menuManager) {
        String string = IDEWorkbenchMessages.Workbench_openPerspective;
        MenuManager menuManager2 = new MenuManager(string, "openPerspective");
        IContributionItem iContributionItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(this.getWindow());
        menuManager2.add(iContributionItem);
        menuManager.add((IContributionItem)menuManager2);
        string = new MenuManager(IDEWorkbenchMessages.Workbench_showView, "showView");
        menuManager2 = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        string.add((IContributionItem)menuManager2);
        menuManager.add((IContributionItem)string);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.editActionSetAction);
        menuManager.add((IAction)this.savePerspectiveAction);
        menuManager.add((IAction)this.resetPerspectiveAction);
        menuManager.add((IAction)this.closePerspAction);
        menuManager.add((IAction)this.closeAllPerspsAction);
    }

    private void addWorkingSetBuildActions(MenuManager menuManager) {
        this.buildWorkingSetMenu = new MenuManager(IDEWorkbenchMessages.Workbench_buildSet);
        BuildSetMenu buildSetMenu = new BuildSetMenu(this.window, this.getActionBarConfigurer());
        this.buildWorkingSetMenu.add((IContributionItem)buildSetMenu);
        menuManager.add((IContributionItem)this.buildWorkingSetMenu);
    }

    private void addKeyboardShortcuts(MenuManager menuManager) {
        MenuManager menuManager2 = new MenuManager(IDEWorkbenchMessages.Workbench_shortcuts, "shortcuts");
        menuManager.add((IContributionItem)menuManager2);
        menuManager2.add((IAction)this.showPartPaneMenuAction);
        menuManager2.add((IAction)this.showViewMenuAction);
        menuManager2.add((IAction)this.quickAccessAction);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)this.maximizePartAction);
        menuManager2.add((IAction)this.minimizePartAction);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)this.activateEditorAction);
        menuManager2.add((IAction)this.nextEditorAction);
        menuManager2.add((IAction)this.prevEditorAction);
        menuManager2.add((IAction)this.switchToEditorAction);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)this.nextPartAction);
        menuManager2.add((IAction)this.prevPartAction);
        menuManager2.add((IContributionItem)new Separator());
        menuManager2.add((IAction)this.nextPerspectiveAction);
        menuManager2.add((IAction)this.prevPerspectiveAction);
    }

    private MenuManager createHelpMenu() {
        MenuManager menuManager = new MenuManager(IDEWorkbenchMessages.Workbench_help, "help");
        this.addSeparatorOrGroupMarker(menuManager, "group.intro");
        if (this.introAction != null) {
            menuManager.add((IAction)this.introAction);
        } else if (this.quickStartAction != null) {
            menuManager.add((IAction)this.quickStartAction);
        }
        menuManager.add((IContributionItem)new GroupMarker("group.intro.ext"));
        this.addSeparatorOrGroupMarker(menuManager, "group.main");
        menuManager.add((IAction)this.helpContentsAction);
        menuManager.add((IAction)this.helpSearchAction);
        menuManager.add((IAction)this.dynamicHelpAction);
        this.addSeparatorOrGroupMarker(menuManager, "group.assist");
        if (this.tipsAndTricksAction != null) {
            menuManager.add((IAction)this.tipsAndTricksAction);
        }
        menuManager.add((IContributionItem)new GroupMarker("helpStart"));
        menuManager.add((IContributionItem)new GroupMarker("group.main.ext"));
        this.addSeparatorOrGroupMarker(menuManager, "group.tutorials");
        this.addSeparatorOrGroupMarker(menuManager, "group.tools");
        this.addSeparatorOrGroupMarker(menuManager, "group.updates");
        menuManager.add((IContributionItem)new GroupMarker("helpEnd"));
        this.addSeparatorOrGroupMarker(menuManager, "additions");
        menuManager.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)this.aboutAction);
        actionContributionItem.setVisible(!Util.isMac());
        menuManager.add((IContributionItem)actionContributionItem);
        menuManager.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menuManager;
    }

    private void addSeparatorOrGroupMarker(MenuManager menuManager, String string) {
        String string2 = "useSeparator." + menuManager.getId() + "." + string;
        boolean bl = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(string2);
        if (bl) {
            menuManager.add((IContributionItem)new Separator(string));
        } else {
            menuManager.add((IContributionItem)new GroupMarker(string));
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMenuService iMenuService = (IMenuService)this.window.getService((Class)clazz);
        iMenuService.releaseContributions((ContributionManager)this.coolbarPopupMenuManager);
        this.coolbarPopupMenuManager.dispose();
        this.getActionBarConfigurer().getStatusLineManager().remove((IContributionItem)this.statusLineItem);
        if (this.pageListener != null) {
            this.window.removePageListener(this.pageListener);
            this.pageListener = null;
        }
        if (this.prefListener != null) {
            ResourcesPlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        if (this.propPrefListener != null) {
            WorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propPrefListener);
            this.propPrefListener = null;
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
            this.resourceListener = null;
        }
        this.pinEditorContributionItem.dispose();
        this.showInQuickMenu.dispose();
        this.newQuickMenu.dispose();
        this.closeAction = null;
        this.closeAllAction = null;
        this.closeAllSavedAction = null;
        this.closeOthersAction = null;
        this.saveAction = null;
        this.saveAllAction = null;
        this.newWindowAction = null;
        this.newEditorAction = null;
        this.helpContentsAction = null;
        this.helpSearchAction = null;
        this.dynamicHelpAction = null;
        this.aboutAction = null;
        this.openPreferencesAction = null;
        this.saveAsAction = null;
        this.hideShowEditorAction = null;
        this.savePerspectiveAction = null;
        this.resetPerspectiveAction = null;
        this.editActionSetAction = null;
        this.closePerspAction = null;
        this.lockToolBarAction = null;
        this.closeAllPerspsAction = null;
        this.showViewMenuAction = null;
        this.showPartPaneMenuAction = null;
        this.nextPartAction = null;
        this.prevPartAction = null;
        this.nextEditorAction = null;
        this.prevEditorAction = null;
        this.nextPerspectiveAction = null;
        this.prevPerspectiveAction = null;
        this.activateEditorAction = null;
        this.maximizePartAction = null;
        this.minimizePartAction = null;
        this.switchToEditorAction = null;
        this.quickAccessAction.dispose();
        this.quickAccessAction = null;
        this.backwardHistoryAction = null;
        this.forwardHistoryAction = null;
        this.undoAction = null;
        this.redoAction = null;
        this.quitAction = null;
        this.goIntoAction = null;
        this.backAction = null;
        this.forwardAction = null;
        this.upAction = null;
        this.nextAction = null;
        this.previousAction = null;
        this.openWorkspaceAction = null;
        this.projectPropertyDialogAction = null;
        this.newWizardAction = null;
        this.newWizardDropDownAction = null;
        this.importResourcesAction = null;
        this.exportResourcesAction = null;
        this.buildAllAction = null;
        this.cleanAction = null;
        this.toggleAutoBuildAction = null;
        this.buildWorkingSetMenu = null;
        this.quickStartAction = null;
        this.tipsAndTricksAction = null;
        this.showInQuickMenu = null;
        this.newQuickMenu = null;
        this.buildProjectAction = null;
        this.newWizardMenu = null;
        this.pinEditorContributionItem = null;
        this.statusLineItem = null;
        this.prefListener = null;
        this.propPrefListener = null;
        this.introAction = null;
        super.dispose();
    }

    void updateModeLine(String string) {
        this.statusLineItem.setText(string);
    }

    public boolean isApplicationMenu(String string) {
        if (string.equals("file")) {
            return true;
        }
        return string.equals("window");
    }

    public boolean isWorkbenchCoolItemId(String string) {
        if ("org.eclipse.ui.workbench.file".equalsIgnoreCase(string)) {
            return true;
        }
        return "org.eclipse.ui.workbench.navigate".equalsIgnoreCase(string);
    }

    protected void fillStatusLine(IStatusLineManager iStatusLineManager) {
        iStatusLineManager.add((IContributionItem)this.statusLineItem);
    }

    protected void makeActions(final IWorkbenchWindow iWorkbenchWindow) {
        this.statusLineItem = new StatusLineContributionItem("ModeContributionItem");
        this.newWizardAction = ActionFactory.NEW.create(iWorkbenchWindow);
        this.register((IAction)this.newWizardAction);
        this.newWizardDropDownAction = IDEActionFactory.NEW_WIZARD_DROP_DOWN.create(iWorkbenchWindow);
        this.register((IAction)this.newWizardDropDownAction);
        this.importResourcesAction = ActionFactory.IMPORT.create(iWorkbenchWindow);
        this.register((IAction)this.importResourcesAction);
        this.exportResourcesAction = ActionFactory.EXPORT.create(iWorkbenchWindow);
        this.register((IAction)this.exportResourcesAction);
        this.buildAllAction = IDEActionFactory.BUILD.create(iWorkbenchWindow);
        this.register((IAction)this.buildAllAction);
        this.cleanAction = IDEActionFactory.BUILD_CLEAN.create(iWorkbenchWindow);
        this.register((IAction)this.cleanAction);
        this.toggleAutoBuildAction = IDEActionFactory.BUILD_AUTOMATICALLY.create(iWorkbenchWindow);
        this.register((IAction)this.toggleAutoBuildAction);
        this.saveAction = ActionFactory.SAVE.create(iWorkbenchWindow);
        this.register((IAction)this.saveAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(iWorkbenchWindow);
        this.register((IAction)this.saveAsAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(iWorkbenchWindow);
        this.register((IAction)this.saveAllAction);
        this.newWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(this.getWindow());
        this.newWindowAction.setText(IDEWorkbenchMessages.Workbench_openNewWindow);
        this.register((IAction)this.newWindowAction);
        this.newEditorAction = ActionFactory.NEW_EDITOR.create(iWorkbenchWindow);
        this.register((IAction)this.newEditorAction);
        this.undoAction = ActionFactory.UNDO.create(iWorkbenchWindow);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(iWorkbenchWindow);
        this.register((IAction)this.redoAction);
        this.closeAction = ActionFactory.CLOSE.create(iWorkbenchWindow);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(iWorkbenchWindow);
        this.register((IAction)this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(iWorkbenchWindow);
        this.register((IAction)this.closeOthersAction);
        this.closeAllSavedAction = ActionFactory.CLOSE_ALL_SAVED.create(iWorkbenchWindow);
        this.register((IAction)this.closeAllSavedAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(iWorkbenchWindow);
        this.register((IAction)this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(iWorkbenchWindow);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(iWorkbenchWindow);
        this.register((IAction)this.dynamicHelpAction);
        this.aboutAction = ActionFactory.ABOUT.create(iWorkbenchWindow);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(iWorkbenchWindow);
        this.register((IAction)this.openPreferencesAction);
        this.makeFeatureDependentActions(iWorkbenchWindow);
        this.showViewMenuAction = ActionFactory.SHOW_VIEW_MENU.create(iWorkbenchWindow);
        this.register((IAction)this.showViewMenuAction);
        this.showPartPaneMenuAction = ActionFactory.SHOW_PART_PANE_MENU.create(iWorkbenchWindow);
        this.register((IAction)this.showPartPaneMenuAction);
        this.nextEditorAction = ActionFactory.NEXT_EDITOR.create(iWorkbenchWindow);
        this.register((IAction)this.nextEditorAction);
        this.prevEditorAction = ActionFactory.PREVIOUS_EDITOR.create(iWorkbenchWindow);
        this.register((IAction)this.prevEditorAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextEditorAction, (ActionFactory.IWorkbenchAction)this.prevEditorAction);
        this.nextPartAction = ActionFactory.NEXT_PART.create(iWorkbenchWindow);
        this.register((IAction)this.nextPartAction);
        this.prevPartAction = ActionFactory.PREVIOUS_PART.create(iWorkbenchWindow);
        this.register((IAction)this.prevPartAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPartAction, (ActionFactory.IWorkbenchAction)this.prevPartAction);
        this.nextPerspectiveAction = ActionFactory.NEXT_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.nextPerspectiveAction);
        this.prevPerspectiveAction = ActionFactory.PREVIOUS_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.prevPerspectiveAction);
        ActionFactory.linkCycleActionPair((ActionFactory.IWorkbenchAction)this.nextPerspectiveAction, (ActionFactory.IWorkbenchAction)this.prevPerspectiveAction);
        this.activateEditorAction = ActionFactory.ACTIVATE_EDITOR.create(iWorkbenchWindow);
        this.register((IAction)this.activateEditorAction);
        this.maximizePartAction = ActionFactory.MAXIMIZE.create(iWorkbenchWindow);
        this.register((IAction)this.maximizePartAction);
        this.minimizePartAction = ActionFactory.MINIMIZE.create(iWorkbenchWindow);
        this.register((IAction)this.minimizePartAction);
        this.switchToEditorAction = ActionFactory.SHOW_OPEN_EDITORS.create(iWorkbenchWindow);
        this.register((IAction)this.switchToEditorAction);
        this.workbookEditorsAction = ActionFactory.SHOW_WORKBOOK_EDITORS.create(iWorkbenchWindow);
        this.register((IAction)this.workbookEditorsAction);
        this.quickAccessAction = ActionFactory.SHOW_QUICK_ACCESS.create(iWorkbenchWindow);
        this.hideShowEditorAction = ActionFactory.SHOW_EDITOR.create(iWorkbenchWindow);
        this.register((IAction)this.hideShowEditorAction);
        this.savePerspectiveAction = ActionFactory.SAVE_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.savePerspectiveAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(iWorkbenchWindow);
        this.register((IAction)this.editActionSetAction);
        this.lockToolBarAction = ActionFactory.LOCK_TOOL_BAR.create(iWorkbenchWindow);
        this.register((IAction)this.lockToolBarAction);
        this.resetPerspectiveAction = ActionFactory.RESET_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.resetPerspectiveAction);
        this.closePerspAction = ActionFactory.CLOSE_PERSPECTIVE.create(iWorkbenchWindow);
        this.register((IAction)this.closePerspAction);
        this.closeAllPerspsAction = ActionFactory.CLOSE_ALL_PERSPECTIVES.create(iWorkbenchWindow);
        this.register((IAction)this.closeAllPerspsAction);
        this.forwardHistoryAction = ActionFactory.FORWARD_HISTORY.create(iWorkbenchWindow);
        this.register((IAction)this.forwardHistoryAction);
        this.backwardHistoryAction = ActionFactory.BACKWARD_HISTORY.create(iWorkbenchWindow);
        this.register((IAction)this.backwardHistoryAction);
        this.quitAction = ActionFactory.QUIT.create(iWorkbenchWindow);
        this.register((IAction)this.quitAction);
        this.goIntoAction = ActionFactory.GO_INTO.create(iWorkbenchWindow);
        this.register((IAction)this.goIntoAction);
        this.backAction = ActionFactory.BACK.create(iWorkbenchWindow);
        this.register((IAction)this.backAction);
        this.forwardAction = ActionFactory.FORWARD.create(iWorkbenchWindow);
        this.register((IAction)this.forwardAction);
        this.upAction = ActionFactory.UP.create(iWorkbenchWindow);
        this.register((IAction)this.upAction);
        this.nextAction = ActionFactory.NEXT.create(iWorkbenchWindow);
        this.nextAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_NEXT_NAV"));
        this.register((IAction)this.nextAction);
        this.previousAction = ActionFactory.PREVIOUS.create(iWorkbenchWindow);
        this.previousAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_PREVIOUS_NAV"));
        this.register((IAction)this.previousAction);
        this.buildProjectAction = IDEActionFactory.BUILD_PROJECT.create(iWorkbenchWindow);
        this.register((IAction)this.buildProjectAction);
        this.openWorkspaceAction = IDEActionFactory.OPEN_WORKSPACE.create(iWorkbenchWindow);
        this.register((IAction)this.openWorkspaceAction);
        this.projectPropertyDialogAction = IDEActionFactory.OPEN_PROJECT_PROPERTIES.create(iWorkbenchWindow);
        this.register((IAction)this.projectPropertyDialogAction);
        if (iWorkbenchWindow.getWorkbench().getIntroManager().hasIntro()) {
            this.introAction = ActionFactory.INTRO.create(iWorkbenchWindow);
            this.register((IAction)this.introAction);
        }
        String string = "org.eclipse.ui.navigate.showInQuickMenu";
        this.showInQuickMenu = new QuickMenuAction(string){

            protected void fillMenu(IMenuManager iMenuManager) {
                iMenuManager.add(ContributionItemFactory.VIEWS_SHOW_IN.create(iWorkbenchWindow));
            }
        };
        this.register((IAction)this.showInQuickMenu);
        this.newQuickMenu = new QuickMenuAction("org.eclipse.ui.file.newQuickMenu"){

            protected void fillMenu(IMenuManager iMenuManager) {
                iMenuManager.add((IContributionItem)new NewWizardMenu(iWorkbenchWindow));
            }
        };
        this.register((IAction)this.newQuickMenu);
        this.pinEditorContributionItem = ContributionItemFactory.PIN_EDITOR.create(iWorkbenchWindow);
    }

    private void makeFeatureDependentActions(IWorkbenchWindow iWorkbenchWindow) {
        AboutInfo[] aboutInfoArray = null;
        IPreferenceStore iPreferenceStore = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String string = "platformState";
        String string2 = iPreferenceStore.getString(string);
        String string3 = String.valueOf(Platform.getStateStamp());
        boolean bl = string3.equals(string2);
        if (!bl) {
            iPreferenceStore.putValue(string, string3);
        }
        String string4 = IDEActionFactory.QUICK_START.getId();
        String string5 = iPreferenceStore.getString(string4);
        if (bl && "true".equals(string5)) {
            this.quickStartAction = IDEActionFactory.QUICK_START.create(iWorkbenchWindow);
            this.register((IAction)this.quickStartAction);
        } else if (!bl || !"false".equals(string5)) {
            aboutInfoArray = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            boolean bl2 = this.hasWelcomePage(aboutInfoArray);
            iPreferenceStore.setValue(string4, bl2);
            if (bl2) {
                this.quickStartAction = IDEActionFactory.QUICK_START.create(iWorkbenchWindow);
                this.register((IAction)this.quickStartAction);
            }
        }
        String string6 = IDEActionFactory.TIPS_AND_TRICKS.getId();
        String string7 = iPreferenceStore.getString(string6);
        if (bl && "true".equals(string7)) {
            this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(iWorkbenchWindow);
            this.register((IAction)this.tipsAndTricksAction);
        } else if (!bl || !"false".equals(string7)) {
            if (aboutInfoArray == null) {
                aboutInfoArray = IDEWorkbenchPlugin.getDefault().getFeatureInfos();
            }
            boolean bl3 = this.hasTipsAndTricks(aboutInfoArray);
            iPreferenceStore.setValue(string6, bl3);
            if (bl3) {
                this.tipsAndTricksAction = IDEActionFactory.TIPS_AND_TRICKS.create(iWorkbenchWindow);
                this.register((IAction)this.tipsAndTricksAction);
            }
        }
    }

    private boolean hasWelcomePage(AboutInfo[] aboutInfoArray) {
        int n = 0;
        while (n < aboutInfoArray.length) {
            if (aboutInfoArray[n].getWelcomePageURL() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasTipsAndTricks(AboutInfo[] aboutInfoArray) {
        int n = 0;
        while (n < aboutInfoArray.length) {
            if (aboutInfoArray[n].getTipsAndTricksHref() != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void updateBuildActions(boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                boolean bl;
                if (WorkbenchActionBuilder.this.isDisposed) {
                    return;
                }
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
                boolean bl2 = BuildUtilities.isEnabled(iProjectArray, 10);
                WorkbenchActionBuilder.this.buildAllAction.setEnabled(bl2);
                WorkbenchActionBuilder.this.buildProjectAction.setEnabled(bl2);
                WorkbenchActionBuilder.this.toggleAutoBuildAction.setChecked(iWorkspace.isAutoBuilding());
                WorkbenchActionBuilder.this.cleanAction.setEnabled(BuildUtilities.isEnabled(iProjectArray, 15));
                ICoolBarManager iCoolBarManager = WorkbenchActionBuilder.this.getActionBarConfigurer().getCoolBarManager();
                IContributionItem iContributionItem = iCoolBarManager.find("org.eclipse.ui.workbench.file");
                if (!(iContributionItem instanceof IToolBarContributionItem)) {
                    IDEWorkbenchPlugin.log("File toolbar contribution item is missing");
                    return;
                }
                IToolBarContributionItem iToolBarContributionItem = (IToolBarContributionItem)iContributionItem;
                IToolBarManager iToolBarManager = iToolBarContributionItem.getToolBarManager();
                if (iToolBarManager == null) {
                    IDEWorkbenchPlugin.log("File toolbar is missing");
                    return;
                }
                boolean bl3 = bl = iToolBarManager.find(WorkbenchActionBuilder.this.buildAllAction.getId()) != null;
                if (bl2 && !bl) {
                    iToolBarManager.appendToGroup("build.group", (IAction)WorkbenchActionBuilder.this.buildAllAction);
                    iToolBarManager.update(false);
                    iToolBarContributionItem.update("size");
                } else if (WorkbenchActionBuilder.this.buildAllAction != null && bl && !bl2) {
                    iToolBarManager.remove(WorkbenchActionBuilder.this.buildAllAction.getId());
                    iToolBarManager.update(false);
                    iToolBarContributionItem.update("size");
                }
            }
        };
        if (bl) {
            runnable.run();
        } else {
            Shell shell = this.window.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.getDisplay().asyncExec(runnable);
            }
        }
    }

    void updatePinActionToolbar() {
        ICoolBarManager iCoolBarManager = this.getActionBarConfigurer().getCoolBarManager();
        IContributionItem iContributionItem = iCoolBarManager.find("org.eclipse.ui.workbench.navigate");
        if (!(iContributionItem instanceof IToolBarContributionItem)) {
            IDEWorkbenchPlugin.log("Navigation toolbar contribution item is missing");
            return;
        }
        IToolBarContributionItem iToolBarContributionItem = (IToolBarContributionItem)iContributionItem;
        IToolBarManager iToolBarManager = iToolBarContributionItem.getToolBarManager();
        if (iToolBarManager == null) {
            IDEWorkbenchPlugin.log("Navigate toolbar is missing");
            return;
        }
        iToolBarManager.update(false);
        iToolBarContributionItem.update("size");
    }

    private IContributionItem getCutItem() {
        return this.getItem(ActionFactory.CUT.getId(), "org.eclipse.ui.edit.cut", "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED", WorkbenchMessages.Workbench_cut, WorkbenchMessages.Workbench_cutToolTip, null);
    }

    private IContributionItem getCopyItem() {
        return this.getItem(ActionFactory.COPY.getId(), "org.eclipse.ui.edit.copy", "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED", WorkbenchMessages.Workbench_copy, WorkbenchMessages.Workbench_copyToolTip, null);
    }

    private IContributionItem getPasteItem() {
        return this.getItem(ActionFactory.PASTE.getId(), "org.eclipse.ui.edit.paste", "IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED", WorkbenchMessages.Workbench_paste, WorkbenchMessages.Workbench_pasteToolTip, null);
    }

    private IContributionItem getPrintItem() {
        return this.getItem(ActionFactory.PRINT.getId(), "org.eclipse.ui.file.print", "IMG_ETOOL_PRINT_EDIT", "IMG_ETOOL_PRINT_EDIT_DISABLED", WorkbenchMessages.Workbench_print, WorkbenchMessages.Workbench_printToolTip, null);
    }

    private IContributionItem getSelectAllItem() {
        return this.getItem(ActionFactory.SELECT_ALL.getId(), "org.eclipse.ui.edit.selectAll", null, null, WorkbenchMessages.Workbench_selectAll, WorkbenchMessages.Workbench_selectAllToolTip, null);
    }

    private IContributionItem getFindItem() {
        return this.getItem(ActionFactory.FIND.getId(), "org.eclipse.ui.edit.findReplace", null, null, WorkbenchMessages.Workbench_findReplace, WorkbenchMessages.Workbench_findReplaceToolTip, null);
    }

    private IContributionItem getBookmarkItem() {
        return this.getItem(IDEActionFactory.BOOKMARK.getId(), "org.eclipse.ui.edit.addBookmark", null, null, IDEWorkbenchMessages.Workbench_addBookmark, IDEWorkbenchMessages.Workbench_addBookmarkToolTip, null);
    }

    private IContributionItem getTaskItem() {
        return this.getItem(IDEActionFactory.ADD_TASK.getId(), "org.eclipse.ui.edit.addTask", null, null, IDEWorkbenchMessages.Workbench_addTask, IDEWorkbenchMessages.Workbench_addTaskToolTip, null);
    }

    private IContributionItem getDeleteItem() {
        return this.getItem(ActionFactory.DELETE.getId(), "org.eclipse.ui.edit.delete", "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED", WorkbenchMessages.Workbench_delete, WorkbenchMessages.Workbench_deleteToolTip, "org.eclipse.ui.delete_retarget_action_context");
    }

    private IContributionItem getRevertItem() {
        return this.getItem(ActionFactory.REVERT.getId(), "org.eclipse.ui.file.revert", null, null, WorkbenchMessages.Workbench_revert, WorkbenchMessages.Workbench_revertToolTip, null);
    }

    private IContributionItem getRefreshItem() {
        return this.getItem(ActionFactory.REFRESH.getId(), "org.eclipse.ui.file.refresh", null, null, WorkbenchMessages.Workbench_refresh, WorkbenchMessages.Workbench_refreshToolTip, null);
    }

    private IContributionItem getPropertiesItem() {
        return this.getItem(ActionFactory.PROPERTIES.getId(), "org.eclipse.ui.file.properties", null, null, WorkbenchMessages.Workbench_properties, WorkbenchMessages.Workbench_propertiesToolTip, null);
    }

    private IContributionItem getMoveItem() {
        return this.getItem(ActionFactory.MOVE.getId(), "org.eclipse.ui.edit.move", null, null, WorkbenchMessages.Workbench_move, WorkbenchMessages.Workbench_moveToolTip, null);
    }

    private IContributionItem getRenameItem() {
        return this.getItem(ActionFactory.RENAME.getId(), "org.eclipse.ui.edit.rename", null, null, WorkbenchMessages.Workbench_rename, WorkbenchMessages.Workbench_renameToolTip, null);
    }

    private IContributionItem getOpenProjectItem() {
        return this.getItem(IDEActionFactory.OPEN_PROJECT.getId(), "org.eclipse.ui.project.openProject", null, null, IDEWorkbenchMessages.OpenResourceAction_text, IDEWorkbenchMessages.OpenResourceAction_toolTip, null);
    }

    private IContributionItem getCloseProjectItem() {
        return this.getItem(IDEActionFactory.CLOSE_PROJECT.getId(), "org.eclipse.ui.project.closeProject", null, null, IDEWorkbenchMessages.CloseResourceAction_text, IDEWorkbenchMessages.CloseResourceAction_text, null);
    }

    private IContributionItem getItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ISharedImages iSharedImages = this.getWindow().getWorkbench().getSharedImages();
        IWorkbenchWindow iWorkbenchWindow = this.getWindow();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.internal.handlers.IActionCommandMappingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)iWorkbenchWindow.getService((Class)clazz);
        iActionCommandMappingService.map(string, string2);
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter((IServiceLocator)this.getWindow(), string, string2, null, iSharedImages.getImageDescriptor(string3), iSharedImages.getImageDescriptor(string4), null, string5, null, string6, 8, null, false);
        return new CommandContributionItem(commandContributionItemParameter);
    }
}

