/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class BuildSetAction
extends Action {
    public static BuildSetAction lastBuilt;
    private IWorkingSet workingSet;
    private IWorkbenchWindow window;
    private IActionBarConfigurer actionBars;

    public BuildSetAction(IWorkingSet iWorkingSet, IWorkbenchWindow iWorkbenchWindow, IActionBarConfigurer iActionBarConfigurer) {
        super(iWorkingSet == null ? "" : iWorkingSet.getLabel(), 8);
        this.window = iWorkbenchWindow;
        this.actionBars = iActionBarConfigurer;
        this.workingSet = iWorkingSet;
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public void run() {
        this.setActionDefinitionId("org.eclipse.ui.project.buildLast");
        this.actionBars.registerGlobalAction((IAction)this);
        this.window.getWorkbench().getWorkingSetManager().addRecentWorkingSet(this.workingSet);
        Object[] objectArray = BuildUtilities.extractProjects(this.workingSet.getElements());
        if (objectArray.length == 0) {
            MessageDialog.openInformation((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.BuildSetAction_noBuildTitle, (String)IDEWorkbenchMessages.BuildSetAction_noProjects);
            return;
        }
        lastBuilt = this;
        BuildAction buildAction = new BuildAction((IShellProvider)this.window, 10);
        buildAction.selectionChanged((IStructuredSelection)new StructuredSelection(objectArray));
        buildAction.run();
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof MenuItem && !((MenuItem)event.widget).getSelection()) {
            return;
        }
        this.run();
    }

    public String toString() {
        return "BuildSetAction(" + this.workingSet.getName() + ")";
    }
}

