/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;
import org.eclipse.ui.internal.ide.actions.SelectBuildWorkingSetAction;

public class BuildSetMenu
extends ContributionItem {
    private IActionBarConfigurer actionBars;
    boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager iMenuManager) {
            iMenuManager.markDirty();
            BuildSetMenu.this.dirty = true;
        }
    };
    private IAction selectBuildWorkingSetAction;
    private IWorkbenchWindow window;

    public BuildSetMenu(IWorkbenchWindow iWorkbenchWindow, IActionBarConfigurer iActionBarConfigurer) {
        this.window = iWorkbenchWindow;
        this.actionBars = iActionBarConfigurer;
        this.selectBuildWorkingSetAction = new SelectBuildWorkingSetAction(iWorkbenchWindow, iActionBarConfigurer);
    }

    private void addMnemonic(BuildSetAction buildSetAction, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 9) {
            stringBuffer.append('&');
            stringBuffer.append(n);
            stringBuffer.append(' ');
        }
        stringBuffer.append(buildSetAction.getWorkingSet().getLabel());
        buildSetAction.setText(stringBuffer.toString());
    }

    public void fill(Menu menu, int n) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        this.fillMenu(menu);
        this.dirty = false;
    }

    private void fillMenu(Menu menu) {
        int n;
        boolean bl = ResourcesPlugin.getWorkspace().isAutoBuilding();
        IWorkingSet[] iWorkingSetArray = this.window.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        BuildSetAction buildSetAction = BuildSetAction.lastBuilt;
        Object object = null;
        int n2 = 1;
        if (buildSetAction != null) {
            n = 0;
            int n3 = 0;
            while (n3 < iWorkingSetArray.length) {
                if (iWorkingSetArray[n3].equals(buildSetAction.getWorkingSet())) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n != 0) {
                buildSetAction.setChecked(true);
                buildSetAction.setEnabled(!bl);
                buildSetAction.setActionDefinitionId("org.eclipse.ui.project.buildLast");
                this.addMnemonic(buildSetAction, n2++);
                new ActionContributionItem((IAction)buildSetAction).fill(menu, -1);
                object = buildSetAction.getWorkingSet();
            } else {
                BuildSetAction.lastBuilt = null;
            }
        }
        n = 0;
        while (n < iWorkingSetArray.length) {
            if (object == null || !object.equals(iWorkingSetArray[n])) {
                BuildSetAction buildSetAction2 = new BuildSetAction(iWorkingSetArray[n], this.window, this.actionBars);
                this.addMnemonic(buildSetAction2, n2++);
                buildSetAction2.setEnabled(!bl);
                new ActionContributionItem((IAction)buildSetAction2).fill(menu, -1);
            }
            ++n;
        }
        if (iWorkingSetArray.length > 0) {
            new Separator().fill(menu, -1);
        }
        this.selectBuildWorkingSetAction.setEnabled(!bl);
        new ActionContributionItem(this.selectBuildWorkingSetAction).fill(menu, -1);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }
}

