/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.ide.ResourceUtil;

public class BuildUtilities {
    public static IProject[] extractProjects(Object[] objectArray) {
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < objectArray.length) {
            IResource iResource = ResourceUtil.getResource(objectArray[n]);
            if (iResource != null) {
                hashSet.add(iResource.getProject());
            } else {
                ResourceMapping resourceMapping = ResourceUtil.getResourceMapping(objectArray[n]);
                if (resourceMapping != null) {
                    IProject[] iProjectArray = resourceMapping.getProjects();
                    int n2 = 0;
                    while (n2 < iProjectArray.length) {
                        hashSet.add(iProjectArray[n2]);
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return hashSet.toArray(new IProject[hashSet.size()]);
    }

    public static IProject[] findSelectedProjects(IWorkbenchWindow iWorkbenchWindow) {
        if (iWorkbenchWindow == null) {
            return new IProject[0];
        }
        ISelection iSelection = iWorkbenchWindow.getSelectionService().getSelection();
        IProject[] iProjectArray = null;
        if (iSelection != null && !iSelection.isEmpty() && iSelection instanceof IStructuredSelection) {
            iProjectArray = BuildUtilities.extractProjects(((IStructuredSelection)iSelection).toArray());
        } else {
            IEditorPart iEditorPart;
            IFile iFile;
            IWorkbenchPart iWorkbenchPart = iWorkbenchWindow.getPartService().getActivePart();
            if (iWorkbenchPart instanceof IEditorPart && (iFile = ResourceUtil.getFile((iEditorPart = (IEditorPart)iWorkbenchPart).getEditorInput())) != null) {
                iProjectArray = new IProject[]{iFile.getProject()};
            }
        }
        if (iProjectArray == null) {
            iProjectArray = new IProject[]{};
        }
        return iProjectArray;
    }

    public static boolean isEnabled(IProject[] iProjectArray, int n) {
        if (n == 10 && ResourcesPlugin.getWorkspace().isAutoBuilding() && !BuildUtilities.matchingTrigger(iProjectArray, 9, false)) {
            return false;
        }
        return BuildUtilities.matchingTrigger(iProjectArray, n, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean matchingTrigger(IProject[] iProjectArray, int n, boolean bl) {
        int n2 = 0;
        while (n2 < iProjectArray.length) {
            if (iProjectArray[n2].isAccessible()) {
                try {
                    IProjectDescription iProjectDescription = iProjectArray[n2].getDescription();
                    ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                    int n3 = 0;
                    while (n3 < iCommandArray.length) {
                        if (iCommandArray[n3].isBuilding(n) == bl) {
                            return true;
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return false;
    }

    public static void saveEditors(Collection collection) {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray[n2];
                if (collection == null) {
                    iWorkbenchPage.saveAllEditors(false);
                } else {
                    IEditorPart[] iEditorPartArray = iWorkbenchPage.getDirtyEditors();
                    int n3 = 0;
                    while (n3 < iEditorPartArray.length) {
                        IEditorPart iEditorPart = iEditorPartArray[n3];
                        IFile iFile = ResourceUtil.getFile(iEditorPart.getEditorInput());
                        if (iFile != null && collection.contains(iFile.getProject())) {
                            iWorkbenchPage.saveEditor(iEditorPart, false);
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
    }

    private BuildUtilities() {
    }
}

