/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class OpenLocalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private String filterPath;

    public OpenLocalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.window = null;
        this.filterPath = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
        this.filterPath = System.getProperty("user.home");
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void run() {
        FileDialog fileDialog = new FileDialog(this.window.getShell(), 4098);
        fileDialog.setText(IDEWorkbenchMessages.OpenLocalFileAction_title);
        fileDialog.setFilterPath(this.filterPath);
        fileDialog.open();
        String[] stringArray = fileDialog.getFileNames();
        if (stringArray != null) {
            Object object;
            this.filterPath = fileDialog.getFilterPath();
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < stringArray.length) {
                object = EFS.getLocalFileSystem().getStore((IPath)new Path(this.filterPath));
                IFileInfo iFileInfo = (object = object.getChild(stringArray[n2])).fetchInfo();
                if (!iFileInfo.isDirectory() && iFileInfo.exists()) {
                    IWorkbenchPage iWorkbenchPage = this.window.getActivePage();
                    try {
                        IDE.openEditorOnFileStore(iWorkbenchPage, object);
                    }
                    catch (PartInitException partInitException) {
                        String string = NLS.bind((String)IDEWorkbenchMessages.OpenLocalFileAction_message_errorOnOpen, (Object)object.getName());
                        IDEWorkbenchPlugin.log(string, partInitException.getStatus());
                        MessageDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.OpenLocalFileAction_title, (String)string);
                    }
                } else {
                    if (++n > 1) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(object.getName());
                }
                ++n2;
            }
            if (n > 0) {
                String string = n == 1 ? IDEWorkbenchMessages.OpenLocalFileAction_message_fileNotFound : IDEWorkbenchMessages.OpenLocalFileAction_message_filesNotFound;
                object = NLS.bind((String)string, (Object)stringBuffer.toString());
                MessageDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.OpenLocalFileAction_title, (String)object);
            }
        }
    }
}

