/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceWithSettingsDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class OpenWorkspaceAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_DATA = "-data";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";
    private IWorkbenchWindow window;

    public OpenWorkspaceAction(IWorkbenchWindow iWorkbenchWindow) {
        super(IDEWorkbenchMessages.OpenWorkspaceAction_text, 4);
        if (iWorkbenchWindow == null) {
            throw new IllegalArgumentException();
        }
        this.window = iWorkbenchWindow;
        this.setToolTipText(IDEWorkbenchMessages.OpenWorkspaceAction_toolTip);
        this.setActionDefinitionId("org.eclipse.ui.file.openWorkspace");
        this.setMenuCreator(new IMenuCreator(){
            private MenuManager dropDownMenuMgr;

            private void createDropDownMenuMgr() {
                if (this.dropDownMenuMgr == null) {
                    this.dropDownMenuMgr = new MenuManager();
                    ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
                    chooseWorkspaceData.readPersistedData();
                    String string = chooseWorkspaceData.getInitialDefault();
                    String[] stringArray = chooseWorkspaceData.getRecentWorkspaces();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n] != null && !stringArray[n].equals(string)) {
                            this.dropDownMenuMgr.add((IAction)new WorkspaceMRUAction(stringArray[n], chooseWorkspaceData));
                        }
                        ++n;
                    }
                    if (!this.dropDownMenuMgr.isEmpty()) {
                        this.dropDownMenuMgr.add((IContributionItem)new Separator());
                    }
                    this.dropDownMenuMgr.add((IAction)new OpenDialogAction());
                }
            }

            public Menu getMenu(Control control) {
                this.createDropDownMenuMgr();
                return this.dropDownMenuMgr.createContextMenu(control);
            }

            public Menu getMenu(Menu menu) {
                this.createDropDownMenuMgr();
                Menu menu2 = new Menu(menu);
                IContributionItem[] iContributionItemArray = this.dropDownMenuMgr.getItems();
                int n = 0;
                while (n < iContributionItemArray.length) {
                    IContributionItem iContributionItem;
                    IContributionItem iContributionItem2 = iContributionItem = iContributionItemArray[n];
                    if (iContributionItem instanceof ActionContributionItem) {
                        iContributionItem2 = new ActionContributionItem(((ActionContributionItem)iContributionItem).getAction());
                    }
                    iContributionItem2.fill(menu2, -1);
                    ++n;
                }
                return menu2;
            }

            public void dispose() {
                if (this.dropDownMenuMgr != null) {
                    this.dropDownMenuMgr.dispose();
                    this.dropDownMenuMgr = null;
                }
            }
        });
    }

    public void run() {
        String string = this.promptForWorkspace();
        if (string == null) {
            return;
        }
        this.restart(string);
    }

    private void restart(String string) {
        String string2 = this.buildCommandLine(string);
        if (string2 == null) {
            return;
        }
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        System.setProperty(PROP_EXIT_DATA, string2);
        this.window.getWorkbench().restart();
    }

    private String promptForWorkspace() {
        ChooseWorkspaceData chooseWorkspaceData = new ChooseWorkspaceData(Platform.getInstanceLocation().getURL());
        ChooseWorkspaceWithSettingsDialog chooseWorkspaceWithSettingsDialog = new ChooseWorkspaceWithSettingsDialog(this.window.getShell(), chooseWorkspaceData, true, false);
        chooseWorkspaceWithSettingsDialog.prompt(true);
        String string = chooseWorkspaceData.getSelection();
        if (string == null) {
            return null;
        }
        chooseWorkspaceData.writePersistedData();
        return string;
    }

    private String buildCommandLine(String string) {
        String string2 = System.getProperty(PROP_VM);
        if (string2 == null) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.OpenWorkspaceAction_errorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.OpenWorkspaceAction_errorMessage, (Object)PROP_VM));
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append(string2);
        stringBuffer.append(NEW_LINE);
        String string3 = System.getProperty(PROP_VMARGS);
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        if ((string2 = System.getProperty(PROP_COMMANDS)) == null) {
            stringBuffer.append(CMD_DATA);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(string);
            stringBuffer.append(NEW_LINE);
        } else {
            int n = string2.lastIndexOf(CMD_DATA);
            if (n != -1) {
                stringBuffer.append(string2.substring(0, n += CMD_DATA.length() + 1));
                stringBuffer.append(string);
                stringBuffer.append(string2.substring(string2.indexOf(10, n)));
            } else {
                stringBuffer.append(CMD_DATA);
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(string);
                stringBuffer.append(NEW_LINE);
                stringBuffer.append(string2);
            }
        }
        if (string3 != null) {
            stringBuffer.append(CMD_VMARGS);
            stringBuffer.append(NEW_LINE);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public void dispose() {
        this.window = null;
    }

    class OpenDialogAction
    extends Action {
        OpenDialogAction() {
            super(IDEWorkbenchMessages.OpenWorkspaceAction_other);
            this.setToolTipText(IDEWorkbenchMessages.OpenWorkspaceAction_toolTip);
        }

        public void run() {
            OpenWorkspaceAction.this.run();
        }
    }

    class WorkspaceMRUAction
    extends Action {
        private ChooseWorkspaceData data;
        private String location;

        WorkspaceMRUAction(String string, ChooseWorkspaceData chooseWorkspaceData) {
            this.location = string;
            this.setText(string);
            this.setToolTipText(string);
            this.data = chooseWorkspaceData;
        }

        public void run() {
            this.data.workspaceSelected(this.location);
            this.data.writePersistedData();
            OpenWorkspaceAction.this.restart(this.location);
        }
    }
}

