/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.actions.BuildSetAction;

public class SelectBuildWorkingSetAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow window;
    private IActionBarConfigurer actionBars;

    public SelectBuildWorkingSetAction(IWorkbenchWindow iWorkbenchWindow, IActionBarConfigurer iActionBarConfigurer) {
        super(IDEWorkbenchMessages.SelectWorkingSetAction_text);
        this.window = iWorkbenchWindow;
        this.actionBars = iActionBarConfigurer;
    }

    private IWorkingSet queryForWorkingSet() {
        IWorkingSetManager iWorkingSetManager = this.window.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = iWorkingSetManager.createWorkingSetSelectionDialog(this.window.getShell(), false);
        iWorkingSetSelectionDialog.open();
        IWorkingSet[] iWorkingSetArray = iWorkingSetSelectionDialog.getSelection();
        if (iWorkingSetArray == null || iWorkingSetArray.length == 0) {
            return null;
        }
        return iWorkingSetArray[0];
    }

    public void run() {
        IWorkingSet iWorkingSet = this.queryForWorkingSet();
        if (iWorkingSet != null) {
            new BuildSetAction(iWorkingSet, this.window, this.actionBars).run();
        }
    }

    public void dispose() {
    }

    public void setActionBars(IActionBarConfigurer iActionBarConfigurer) {
        this.actionBars = iActionBarConfigurer;
    }
}

