/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.SimpleListContentProvider;
import org.eclipse.ui.internal.util.PrefUtil;

public class BuildOrderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IWorkbench workbench;
    private Button defaultOrderButton;
    private Label buildLabel;
    private List buildList;
    private Composite buttonComposite;
    private IntegerFieldEditor maxItersField;
    private String[] defaultBuildOrder;
    private String[] customBuildOrder;
    private boolean notCheckedBuildOrder = true;
    private final String UP_LABEL = IDEWorkbenchMessages.BuildOrderPreference_up;
    private final String DOWN_LABEL = IDEWorkbenchMessages.BuildOrderPreference_down;
    private final String ADD_LABEL = IDEWorkbenchMessages.BuildOrderPreference_add;
    private final String REMOVE_LABEL = IDEWorkbenchMessages.BuildOrderPreference_remove;
    private final String PROJECT_SELECTION_MESSAGE = IDEWorkbenchMessages.BuildOrderPreference_selectOtherProjects;
    private final String DEFAULTS_LABEL = IDEWorkbenchMessages.BuildOrderPreference_useDefaults;
    private final String LIST_LABEL = IDEWorkbenchMessages.BuildOrderPreference_projectBuildOrder;
    private final String NOTE_LABEL = IDEWorkbenchMessages.Preference_note;
    private final String REMOVE_MESSAGE = IDEWorkbenchMessages.BuildOrderPreference_removeNote;
    private boolean defaultOrderInitiallySelected;
    private IPropertyChangeListener validityChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("field_editor_is_valid")) {
                BuildOrderPreferencePage.this.updateValidState();
            }
        }
    };

    private void addProject() {
        String[] stringArray = this.buildList.getItems();
        IProject[] iProjectArray = this.getWorkspace().getRoot().getProjects();
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                return (String)object;
            }
        };
        SimpleListContentProvider simpleListContentProvider = new SimpleListContentProvider();
        simpleListContentProvider.setElements(this.sortedDifference(iProjectArray, stringArray));
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.getShell(), (Object)this, (IStructuredContentProvider)simpleListContentProvider, (ILabelProvider)labelProvider, this.PROJECT_SELECTION_MESSAGE);
        if (listSelectionDialog.open() != 0) {
            return;
        }
        Object[] objectArray = listSelectionDialog.getResult();
        int n = stringArray.length;
        int n2 = objectArray.length;
        String[] stringArray2 = new String[n + n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(objectArray, 0, stringArray2, n, objectArray.length);
        this.buildList.setItems(stringArray2);
    }

    private void updateValidState() {
        this.setValid(this.maxItersField.isValid());
    }

    private void createBuildOrderList(Composite composite, boolean bl) {
        Font font = composite.getFont();
        this.buildLabel = new Label(composite, 0);
        this.buildLabel.setText(this.LIST_LABEL);
        this.buildLabel.setEnabled(bl);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.buildLabel.setLayoutData((Object)gridData);
        this.buildLabel.setFont(font);
        this.buildList = new List(composite, 2818);
        this.buildList.setEnabled(bl);
        GridData gridData2 = new GridData();
        gridData2.heightHint = this.buildList.getItemHeight();
        gridData2.verticalAlignment = 4;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        this.buildList.setLayoutData((Object)gridData2);
        this.buildList.setFont(font);
    }

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.build_order_preference_page_context");
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(font);
        String[] stringArray = this.getCurrentBuildOrder();
        boolean bl = stringArray == null;
        this.createDefaultPathButton(composite2, bl);
        this.createBuildOrderList(composite2, true);
        this.createListButtons(composite2, !bl);
        Composite composite3 = this.createNoteComposite(font, composite2, this.NOTE_LABEL, this.REMOVE_MESSAGE);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData2);
        this.createSpacer(composite2);
        this.createMaxIterationsField(composite2);
        this.createSpacer(composite2);
        if (bl) {
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.buildList.setItems(stringArray);
        }
        return composite2;
    }

    private void createSpacer(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
    }

    private void createDefaultPathButton(Composite composite, boolean bl) {
        this.defaultOrderInitiallySelected = bl;
        this.defaultOrderButton = new Button(composite, 16416);
        this.defaultOrderButton.setSelection(bl);
        this.defaultOrderButton.setText(this.DEFAULTS_LABEL);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOrderPreferencePage.this.defaultsButtonSelected(BuildOrderPreferencePage.this.defaultOrderButton.getSelection());
            }
        };
        this.defaultOrderButton.addSelectionListener((SelectionListener)selectionAdapter);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.defaultOrderButton.setLayoutData((Object)gridData);
        this.defaultOrderButton.setFont(composite.getFont());
    }

    private void createListButtons(Composite composite, boolean bl) {
        Font font = composite.getFont();
        this.buttonComposite = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.buttonComposite.setLayoutData((Object)gridData);
        this.buttonComposite.setFont(font);
        Button button = new Button(this.buttonComposite, 0x1000008);
        button.setText(this.UP_LABEL);
        button.setEnabled(bl);
        button.setFont(font);
        this.setButtonLayoutData(button);
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOrderPreferencePage.this.moveSelectionUp();
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        Button button2 = new Button(this.buttonComposite, 0x1000008);
        button2.setText(this.DOWN_LABEL);
        button2.setEnabled(bl);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOrderPreferencePage.this.moveSelectionDown();
            }
        };
        button2.addSelectionListener((SelectionListener)selectionAdapter);
        button2.setFont(font);
        this.setButtonLayoutData(button2);
        Button button3 = new Button(this.buttonComposite, 0x1000008);
        button3.setText(this.ADD_LABEL);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOrderPreferencePage.this.addProject();
            }
        };
        button3.addSelectionListener((SelectionListener)selectionAdapter);
        button3.setEnabled(bl);
        button3.setFont(font);
        this.setButtonLayoutData(button3);
        Button button4 = new Button(this.buttonComposite, 0x1000008);
        button4.setText(this.REMOVE_LABEL);
        selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildOrderPreferencePage.this.removeSelection();
            }
        };
        button4.addSelectionListener((SelectionListener)selectionAdapter);
        button4.setEnabled(bl);
        button4.setFont(font);
        this.setButtonLayoutData(button4);
    }

    private void createMaxIterationsField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        this.maxItersField = new IntegerFieldEditor("", IDEWorkbenchMessages.BuildOrderPreference_maxIterationsLabel, composite2){

            protected void doLoad() {
                Text text = this.getTextControl();
                if (text != null) {
                    int n = BuildOrderPreferencePage.this.getWorkspace().getDescription().getMaxBuildIterations();
                    text.setText(Integer.toString(n));
                }
            }

            protected void doLoadDefault() {
                Text text = this.getTextControl();
                if (text != null) {
                    int n = ResourcesPlugin.getPlugin().getPluginPreferences().getDefaultInt("description.maxbuilditerations");
                    text.setText(Integer.toString(n));
                }
                this.valueChanged();
            }

            protected void doStore() {
                throw new UnsupportedOperationException();
            }
        };
        this.maxItersField.setValidRange(1, Integer.MAX_VALUE);
        this.maxItersField.setPage((DialogPage)this);
        this.maxItersField.setPreferenceStore(this.getPreferenceStore());
        this.maxItersField.setPropertyChangeListener(this.validityChangeListener);
        this.maxItersField.load();
    }

    private void defaultsButtonSelected(boolean bl) {
        if (bl) {
            this.setBuildOrderWidgetsEnablement(false);
            this.customBuildOrder = this.buildList.getItems();
            this.buildList.setItems(this.getDefaultProjectOrder());
        } else {
            this.setBuildOrderWidgetsEnablement(true);
            String[] stringArray = this.getCurrentBuildOrder();
            if (stringArray == null) {
                this.buildList.setItems(this.getDefaultProjectOrder());
            } else {
                this.buildList.setItems(stringArray);
            }
        }
    }

    private String[] getCurrentBuildOrder() {
        if (this.notCheckedBuildOrder) {
            this.customBuildOrder = this.getWorkspace().getDescription().getBuildOrder();
            this.notCheckedBuildOrder = false;
        }
        return this.customBuildOrder;
    }

    private String[] getDefaultProjectOrder() {
        if (this.defaultBuildOrder == null) {
            IWorkspace iWorkspace = this.getWorkspace();
            IWorkspace.ProjectOrder projectOrder = this.getWorkspace().computeProjectOrder(iWorkspace.getRoot().getProjects());
            IProject[] iProjectArray = projectOrder.projects;
            this.defaultBuildOrder = new String[iProjectArray.length];
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.defaultBuildOrder[n2] = iProjectArray[n2].getName();
                ++n2;
            }
        }
        return this.defaultBuildOrder;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private boolean includes(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void init(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.setPreferenceStore(PrefUtil.getInternalPreferenceStore());
    }

    private void moveSelectionDown() {
        int n;
        if (this.buildList.getSelectionCount() == 1 && (n = this.buildList.getSelectionIndex()) < this.buildList.getItemCount() - 1) {
            String string = this.buildList.getItem(n);
            this.buildList.remove(n);
            this.buildList.add(string, n + 1);
            this.buildList.select(n + 1);
        }
    }

    private void moveSelectionUp() {
        int n = this.buildList.getSelectionIndex();
        if (n > 0 && this.buildList.getSelectionCount() == 1) {
            String string = this.buildList.getItem(n);
            this.buildList.remove(n);
            this.buildList.add(string, n - 1);
            this.buildList.select(n - 1);
        }
    }

    protected void performDefaults() {
        this.defaultOrderButton.setSelection(true);
        this.defaultsButtonSelected(true);
        this.maxItersField.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        String[] stringArray = null;
        boolean bl = this.defaultOrderButton.getSelection();
        if (!bl) {
            stringArray = this.buildList.getItems();
        }
        IWorkspaceDescription iWorkspaceDescription = this.getWorkspace().getDescription();
        iWorkspaceDescription.setBuildOrder(stringArray);
        iWorkspaceDescription.setMaxBuildIterations(this.maxItersField.getIntValue());
        try {
            this.getWorkspace().setDescription(iWorkspaceDescription);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (!bl || bl != this.defaultOrderInitiallySelected) {
            this.defaultOrderInitiallySelected = bl;
            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                GlobalBuildAction globalBuildAction = new GlobalBuildAction(this.workbench.getActiveWorkbenchWindow(), 10);
                globalBuildAction.doBuild();
            }
        }
        this.customBuildOrder = null;
        return true;
    }

    private void removeSelection() {
        this.buildList.remove(this.buildList.getSelectionIndices());
    }

    private void setBuildOrderWidgetsEnablement(boolean bl) {
        Control[] controlArray = this.buttonComposite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].setEnabled(bl);
            ++n;
        }
    }

    private String[] sortedDifference(IProject[] iProjectArray, String[] stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < iProjectArray.length) {
            if (!this.includes(stringArray, iProjectArray[n].getName())) {
                treeSet.add(iProjectArray[n].getName());
            }
            ++n;
        }
        String[] stringArray2 = new String[treeSet.size()];
        treeSet.toArray(stringArray2);
        return stringArray2;
    }
}

