/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BuildAction;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.internal.ide.dialogs.ResourceComparator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CleanDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "CleanDialogSettings";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String TOGGLE_SELECTED = "TOGGLE_SELECTED";
    private static final String BUILD_NOW = "BUILD_NOW";
    private static final String BUILD_ALL = "BUILD_ALL";
    private Button allButton;
    private Button selectedButton;
    private Button buildNowButton;
    private Button globalBuildButton;
    private Button projectBuildButton;
    private CheckboxTableViewer projectNames;
    private Object[] selection;
    private IWorkbenchWindow window;

    private static String getQuestion() {
        boolean bl = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (bl) {
            return IDEWorkbenchMessages.CleanDialog_buildCleanAuto;
        }
        return IDEWorkbenchMessages.CleanDialog_buildCleanManual;
    }

    public CleanDialog(IWorkbenchWindow iWorkbenchWindow, IProject[] iProjectArray) {
        super(iWorkbenchWindow.getShell(), IDEWorkbenchMessages.CleanDialog_title, null, CleanDialog.getQuestion(), 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.window = iWorkbenchWindow;
        this.selection = iProjectArray;
        if (this.selection == null) {
            this.selection = new Object[0];
        }
    }

    protected void buttonPressed(int n) {
        final boolean bl = this.allButton.getSelection();
        final boolean bl2 = this.buildNowButton != null && this.buildNowButton.getSelection();
        final boolean bl3 = this.globalBuildButton != null && this.globalBuildButton.getSelection();
        super.buttonPressed(n);
        if (n != 0) {
            return;
        }
        BuildUtilities.saveEditors(null);
        WorkspaceJob workspaceJob = new WorkspaceJob(bl ? IDEWorkbenchMessages.CleanDialog_cleanAllTaskName : IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName){

            public boolean belongsTo(Object object) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD.equals(object);
            }

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                CleanDialog.this.doClean(bl, iProgressMonitor);
                if (bl2) {
                    if (bl3) {
                        GlobalBuildAction globalBuildAction = new GlobalBuildAction(CleanDialog.this.window, 10);
                        globalBuildAction.doBuild();
                    } else {
                        IProject[] iProjectArray = new IProject[CleanDialog.this.selection.length];
                        int n = 0;
                        while (n < CleanDialog.this.selection.length) {
                            iProjectArray[n] = (IProject)CleanDialog.this.selection[n];
                            ++n;
                        }
                        ProjectSubsetBuildAction projectSubsetBuildAction = new ProjectSubsetBuildAction((IShellProvider)CleanDialog.this.window, 10, iProjectArray);
                        projectSubsetBuildAction.runInBackground(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                    }
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        workspaceJob.setUser(true);
        workspaceJob.schedule();
    }

    protected Control createCustomArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CleanDialog.this.updateEnablement();
            }
        };
        IDialogSettings iDialogSettings = this.getDialogSettings(DIALOG_SETTINGS_SECTION);
        boolean bl = iDialogSettings.getBoolean(TOGGLE_SELECTED);
        this.allButton = new Button(composite2, 16);
        this.allButton.setText(IDEWorkbenchMessages.CleanDialog_cleanAllButton);
        this.allButton.setSelection(!bl);
        this.allButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.selectedButton = new Button(composite2, 16);
        this.selectedButton.setText(IDEWorkbenchMessages.CleanDialog_cleanSelectedButton);
        this.selectedButton.setSelection(bl);
        this.selectedButton.addSelectionListener((SelectionListener)selectionAdapter);
        this.createProjectSelectionTable(composite2);
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            this.buildNowButton = new Button(composite, 32);
            this.buildNowButton.setText(IDEWorkbenchMessages.CleanDialog_buildNowButton);
            String string = iDialogSettings.get(BUILD_NOW);
            this.buildNowButton.setSelection(string == null || Boolean.valueOf(string) != false);
            this.buildNowButton.setLayoutData((Object)new GridData(32));
            this.buildNowButton.addSelectionListener((SelectionListener)selectionAdapter);
            this.globalBuildButton = new Button(composite, 16);
            this.globalBuildButton.setText(IDEWorkbenchMessages.CleanDialog_globalBuildButton);
            String string2 = iDialogSettings.get(BUILD_ALL);
            this.globalBuildButton.setSelection(string2 == null || Boolean.valueOf(string2) != false);
            GridData gridData = new GridData(32);
            gridData.horizontalIndent = 10;
            this.globalBuildButton.setLayoutData((Object)gridData);
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
            this.projectBuildButton = new Button(composite, 16);
            this.projectBuildButton.setText(IDEWorkbenchMessages.CleanDialog_buildSelectedProjectsButton);
            this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
            gridData = new GridData(32);
            gridData.horizontalIndent = 10;
            this.projectBuildButton.setLayoutData((Object)gridData);
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
            SelectionAdapter selectionAdapter2 = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    CleanDialog.this.updateBuildRadioEnablement();
                }
            };
            this.globalBuildButton.addSelectionListener((SelectionListener)selectionAdapter2);
            this.projectBuildButton.addSelectionListener((SelectionListener)selectionAdapter2);
        }
        this.projectNames.getTable().setEnabled(bl);
        return composite2;
    }

    private void createProjectSelectionTable(Composite composite) {
        this.projectNames = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        this.projectNames.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.projectNames.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.projectNames.setComparator((ViewerComparator)new ResourceComparator(1));
        this.projectNames.addFilter(new ViewerFilter(){
            private final IProject[] projectHolder = new IProject[1];

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (!(object2 instanceof IProject)) {
                    return false;
                }
                IProject iProject = (IProject)object2;
                if (!iProject.isAccessible()) {
                    return false;
                }
                this.projectHolder[0] = iProject;
                return BuildUtilities.isEnabled(this.projectHolder, 15);
            }
        });
        this.projectNames.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        this.projectNames.getTable().setLayoutData((Object)gridData);
        this.projectNames.setCheckedElements(this.selection);
        this.projectNames.getTable().setEnabled(this.selectedButton.getSelection());
        this.projectNames.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CleanDialog.this.selection = CleanDialog.this.projectNames.getCheckedElements();
                CleanDialog.this.updateEnablement();
            }
        });
    }

    protected void doClean(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        if (bl) {
            ResourcesPlugin.getWorkspace().build(15, iProgressMonitor);
        } else {
            try {
                iProgressMonitor.beginTask(IDEWorkbenchMessages.CleanDialog_cleanSelectedTaskName, this.selection.length);
                int n = 0;
                while (n < this.selection.length) {
                    ((IProject)this.selection[n]).build(15, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    ++n;
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    protected void updateEnablement() {
        this.projectNames.getTable().setEnabled(this.selectedButton.getSelection());
        boolean bl = this.allButton.getSelection() || this.selection.length > 0;
        this.getButton(0).setEnabled(bl);
        if (this.globalBuildButton != null) {
            this.globalBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
        if (this.projectBuildButton != null) {
            this.projectBuildButton.setEnabled(this.buildNowButton.getSelection());
        }
    }

    protected void updateBuildRadioEnablement() {
        this.projectBuildButton.setSelection(!this.globalBuildButton.getSelection());
    }

    public boolean close() {
        this.persistDialogSettings(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point point) {
        Point point2 = this.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return point2 != null ? point2 : super.getInitialLocation(point);
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        return this.getInitialSize(DIALOG_SETTINGS_SECTION, point);
    }

    public Point getInitialLocation(String string) {
        IDialogSettings iDialogSettings = this.getDialogSettings(string);
        try {
            int n = iDialogSettings.getInt(DIALOG_ORIGIN_X);
            int n2 = iDialogSettings.getInt(DIALOG_ORIGIN_Y);
            return new Point(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IDialogSettings getDialogSettings(String string) {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(string);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(string);
        }
        return iDialogSettings2;
    }

    private void persistDialogSettings(Shell shell, String string) {
        Point point = shell.getLocation();
        Point point2 = shell.getSize();
        IDialogSettings iDialogSettings = this.getDialogSettings(string);
        iDialogSettings.put(DIALOG_ORIGIN_X, point.x);
        iDialogSettings.put(DIALOG_ORIGIN_Y, point.y);
        iDialogSettings.put(DIALOG_WIDTH, point2.x);
        iDialogSettings.put(DIALOG_HEIGHT, point2.y);
        if (this.buildNowButton != null) {
            iDialogSettings.put(BUILD_NOW, this.buildNowButton.getSelection());
        }
        if (this.globalBuildButton != null) {
            iDialogSettings.put(BUILD_ALL, this.globalBuildButton.getSelection());
        }
        iDialogSettings.put(TOGGLE_SELECTED, this.selectedButton.getSelection());
    }

    private Point getInitialSize(String string, Point point) {
        IDialogSettings iDialogSettings = this.getDialogSettings(string);
        try {
            int n = iDialogSettings.getInt(DIALOG_WIDTH);
            int n2 = iDialogSettings.getInt(DIALOG_HEIGHT);
            return new Point(Math.max(n, point.x), Math.max(n2, point.y));
        }
        catch (NumberFormatException numberFormatException) {
            return point;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private class ProjectSubsetBuildAction
    extends BuildAction {
        private IProject[] projectsToBuild = new IProject[0];

        public ProjectSubsetBuildAction(IShellProvider iShellProvider, int n, IProject[] iProjectArray) {
            super(iShellProvider, n);
            this.projectsToBuild = iProjectArray;
        }

        protected List getSelectedResources() {
            return Arrays.asList(this.projectsToBuild);
        }
    }
}

